/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.internal.statistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.ehcache.Cache;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.observer.ChainedEventObserver;
import org.terracotta.statistics.observer.ChainedObserver;

public final class StatsUtils {
    private StatsUtils() {
    }

    public static Matcher<Map<String, Object>> hasTag(final String tag) {
        return Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.contains(tag);
            }
        });
    }

    public static Matcher<Map<String, Object>> hasProperty(final String key, final String value) {
        return Matchers.hasAttribute((String)"properties", (Matcher)new Matcher<Map<String, Object>>(){

            protected boolean matchesSafely(Map<String, Object> properties) {
                Object val = properties.get(key);
                return val != null && value.equals(val);
            }
        });
    }

    public static <T> Optional<T> findStatisticOnDescendants(Object context, String discriminator, String tag, String statName) {
        Set statResult = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), StatsUtils.hasProperty("discriminator", discriminator), StatsUtils.hasTag(tag)})))).build().execute(Collections.singleton(ContextManager.nodeFor((Object)context)));
        if (statResult.size() > 1) {
            throw new RuntimeException("One stat expected for " + statName + " but found " + statResult.size());
        }
        if (statResult.size() == 1) {
            Object result = ((TreeNode)statResult.iterator().next()).getContext().attributes().get("this");
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> findStatisticOnDescendants(Object context, String tag, String statName) {
        Set statResult = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), StatsUtils.hasTag(tag)})))).build().execute(Collections.singleton(ContextManager.nodeFor((Object)context)));
        if (statResult.size() > 1) {
            throw new RuntimeException("One stat expected for " + statName + " but found " + statResult.size());
        }
        if (statResult.size() == 1) {
            Object result = ((TreeNode)statResult.iterator().next()).getContext().attributes().get("this");
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> OperationStatistic<T> findOperationStatisticOnChildren(Object context, Class<T> type, String statName) {
        Query query = QueryBuilder.queryBuilder().children().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), Matchers.hasAttribute((String)"type", type)})))).build();
        Set result = query.execute(Collections.singleton(ContextManager.nodeFor((Object)context)));
        if (result.size() > 1) {
            throw new RuntimeException("result must be unique");
        }
        if (result.isEmpty()) {
            throw new RuntimeException("result must not be null");
        }
        OperationStatistic statistic = (OperationStatistic)((TreeNode)result.iterator().next()).getContext().attributes().get("this");
        return statistic;
    }

    public static String[] findTiers(Cache<?, ?> cache) {
        Query statQuery = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)"eviction"), Matchers.hasAttribute((String)"type", StoreOperationOutcomes.EvictionOutcome.class)})))).build();
        Set statResult = statQuery.execute(Collections.singleton(ContextManager.nodeFor(cache)));
        if (statResult.isEmpty()) {
            throw new RuntimeException("Failed to find tiers using the eviction observer, valid result Set sizes must 1 or more");
        }
        String[] tiers = new String[statResult.size()];
        int i = 0;
        for (TreeNode treeNode : statResult) {
            Set tags = (Set)treeNode.getContext().attributes().get("tags");
            if (tags.size() != 1) {
                throw new RuntimeException("We expect tiers to have only one tag");
            }
            String storeType = tags.iterator().next().toString();
            tiers[i++] = storeType;
        }
        return tiers;
    }

    public static String findLowestTier(String[] tiers) {
        if (tiers.length == 1) {
            return tiers[0];
        }
        if (tiers.length == 0) {
            throw new RuntimeException("No existing tier");
        }
        String lowestTier = tiers[0];
        for (int i = 1; i < tiers.length; ++i) {
            if (tiers[i].compareTo(lowestTier) >= 0) continue;
            lowestTier = tiers[i];
        }
        return lowestTier;
    }

    public static <T extends Enum<T>> boolean hasOperationStat(Object rootNode, final Class<T> statisticType, String statName) {
        Query q = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.identifier((Matcher)Matchers.subclassOf(OperationStatistic.class)))).filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), Matchers.hasAttribute((String)"this", (Matcher)new Matcher<OperationStatistic<T>>(){

            protected boolean matchesSafely(OperationStatistic<T> object) {
                return object.type().equals(statisticType);
            }
        })})))).build();
        Set result = q.execute(Collections.singleton(ContextManager.nodeFor((Object)rootNode)));
        if (result.size() > 1) {
            throw new RuntimeException("a zero or a single stat was expected; found " + result.size());
        }
        return !result.isEmpty();
    }

    public static void registerClearNotification(String alias, Cache<?, ?> cache, Consumer<String> cacheClear) {
        OperationStatistic<CacheOperationOutcomes.ClearOutcome> clear = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ClearOutcome.class, "clear");
        clear.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(CacheOperationOutcomes.ClearOutcome.SUCCESS), new ChainedEventObserver[]{(time, latency) -> cacheClear.accept(alias)}));
    }
}

