/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.reflect.TargetedInvocationHandler;

public final class ClassLoaderUtils {
    private static final Logger LOG = LogManager.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoaderUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static boolean isInstanceOf(Object object, Class<?> instanceClass) {
        if (object == null) {
            return false;
        }
        if (instanceClass.isInstance(object)) {
            return true;
        }
        return ClassLoaderUtils.isInstanceOf(ClassLoaderUtils.unwrapFromProxyOnce(object), instanceClass);
    }

    public static Object unwrapFromProxy(Object proxy) {
        Object unwrapped = ClassLoaderUtils.unwrapFromProxyOnce(proxy);
        if (unwrapped == null) {
            return proxy;
        }
        return ClassLoaderUtils.unwrapFromProxy(unwrapped);
    }

    private static Object unwrapFromProxyOnce(Object proxy) {
        InvocationHandler invocationHandler;
        if (proxy != null && Proxy.isProxyClass(proxy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(proxy)) instanceof TargetedInvocationHandler) {
            return ((TargetedInvocationHandler)invocationHandler).getTarget();
        }
        return null;
    }

    public static boolean isClassVisible(ClassLoader classLoader, Class<?> classToCheck) {
        try {
            Class<?> classFound = classLoader.loadClass(classToCheck.getName());
            return classFound.equals(classToCheck);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class[] getInterfacesToProxy(Object object, ClassLoader proxyClassLoader, String[] packageNamesToFilter) {
        List interfaces = ClassUtils.getAllInterfaces(object.getClass());
        Iterator iterator = interfaces.iterator();
        block0: while (iterator.hasNext()) {
            Class objectInterface = (Class)iterator.next();
            if (packageNamesToFilter != null) {
                for (String packageNames : packageNamesToFilter) {
                    if (!objectInterface.getName().startsWith(packageNames)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            if (proxyClassLoader == null || ClassLoaderUtils.isClassVisible(proxyClassLoader, objectInterface)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("The interface " + String.valueOf(objectInterface) + " was not visible from the proxy ClassLoader when attempting to proxy: " + String.valueOf(object));
            }
            iterator.remove();
        }
        Class[] interfaceArray = new Class[interfaces.size()];
        return interfaces.toArray(interfaceArray);
    }

    public static Class<?> getClass(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        try {
            return ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)className);
        }
        catch (ClassNotFoundException e) {
            throw new RiceRuntimeException(e);
        }
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> type) throws ClassNotFoundException {
        Class theClass = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)className);
        return theClass.asSubclass(type);
    }
}

