/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapImpl;

public class DMapEntry
implements Map.Entry,
Serializable,
PersistenceBrokerAware {
    private static final long serialVersionUID = 4382757889982004339L;
    private transient Logger log = LoggerFactory.getLogger(DMapEntry.class);
    private PBKey pbKey;
    private Integer id;
    private Integer dmapId;
    private Identity keyOid;
    private Identity valueOid;
    private transient Object keyRealSubject;
    private transient Object valueRealSubject;

    public DMapEntry() {
        this.pbKey = this.getPBKey();
    }

    public DMapEntry(DMapImpl dMapImpl, Object object, Object object2) {
        if (dMapImpl != null) {
            this.dmapId = dMapImpl.getId();
        }
        this.keyRealSubject = object;
        this.valueRealSubject = object2;
        this.getPBKey();
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(DMapEntry.class);
        }
        return this.log;
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public PBKey getPBKey() {
        TransactionImpl transactionImpl;
        if (this.pbKey == null && (transactionImpl = this.getTransaction()) != null && transactionImpl.isOpen()) {
            this.pbKey = transactionImpl.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    protected void prepareForPersistency(PersistenceBroker persistenceBroker) {
        if (this.keyOid == null) {
            if (this.keyRealSubject == null) {
                throw new OJBRuntimeException("Key identity and real key object are 'null' - Can not persist empty entry");
            }
            this.keyOid = persistenceBroker.serviceIdentity().buildIdentity(this.keyRealSubject);
        }
        if (this.valueOid == null) {
            if (this.valueRealSubject == null) {
                throw new OJBRuntimeException("Key identity and real key object are 'null' - Can not persist empty entry");
            }
            this.valueOid = persistenceBroker.serviceIdentity().buildIdentity(this.valueRealSubject);
        }
    }

    protected void prepareKeyRealSubject(PersistenceBroker persistenceBroker) {
        if (this.keyOid == null) {
            this.getLog().info("Cannot retrieve real key object because its id is not known");
        } else {
            this.keyRealSubject = persistenceBroker.getObjectByIdentity(this.keyOid);
        }
    }

    protected void prepareValueRealSubject(PersistenceBroker persistenceBroker) {
        if (this.valueOid == null) {
            this.getLog().info("Cannot retrieve real key object because its id is not known");
        } else {
            this.valueRealSubject = persistenceBroker.getObjectByIdentity(this.valueOid);
        }
    }

    public Object getRealKey() {
        if (this.keyRealSubject != null) {
            return this.keyRealSubject;
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl != null && transactionImpl.isOpen()) {
            this.prepareKeyRealSubject(transactionImpl.getBroker());
        } else if (this.getPBKey() != null) {
            PBCapsule pBCapsule = new PBCapsule(this.getPBKey(), null);
            try {
                this.prepareKeyRealSubject(pBCapsule.getBroker());
            }
            finally {
                pBCapsule.destroy();
            }
        } else {
            this.getLog().warn("No tx, no PBKey - can't materialise key with Identity " + this.getKeyOid());
        }
        return this.keyRealSubject;
    }

    public Object getKey() {
        if (this.keyRealSubject == null) {
            return this.getRealKey();
        }
        return this.keyRealSubject;
    }

    public Object getRealValue() {
        if (this.valueRealSubject != null) {
            return this.valueRealSubject;
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl != null && transactionImpl.isOpen()) {
            this.prepareValueRealSubject(transactionImpl.getBroker());
        } else if (this.getPBKey() != null) {
            PBCapsule pBCapsule = new PBCapsule(this.getPBKey(), null);
            try {
                this.prepareValueRealSubject(pBCapsule.getBroker());
            }
            finally {
                pBCapsule.destroy();
            }
        } else {
            this.getLog().warn("No tx, no PBKey - can't materialise value with Identity " + this.getKeyOid());
        }
        return this.valueRealSubject;
    }

    public Object getValue() {
        if (this.valueRealSubject == null) {
            return this.getRealValue();
        }
        return this.valueRealSubject;
    }

    public Object setValue(Object object) {
        Object object2 = this.valueRealSubject;
        this.valueRealSubject = object;
        return object2;
    }

    public Integer getDmapId() {
        return this.dmapId;
    }

    public void setDmapId(Integer n) {
        this.dmapId = n;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Identity getKeyOid() {
        return this.keyOid;
    }

    public void setKeyOid(Identity identity) {
        this.keyOid = identity;
    }

    public Identity getValueOid() {
        return this.valueOid;
    }

    public void setValueOid(Identity identity) {
        this.valueOid = identity;
    }

    @Override
    public void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.prepareForPersistency(persistenceBroker);
    }

    @Override
    public void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void beforeDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterLookup(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }
}

