-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE kc_activemq_acks  (
  CONTAINER    	varchar(250) NOT NULL,
  SUB_DEST     	varchar(250) NULL,
  CLIENT_ID    	varchar(250) NOT NULL,
  SUB_NAME     	varchar(250) NOT NULL,
  SELECTOR     	varchar(250) NULL,
  LAST_ACKED_ID	bigint(20) NULL,
  PRIORITY     	bigint(20) NOT NULL DEFAULT '5',
  XID          	varchar(250) NULL,
  PRIMARY KEY(CONTAINER,CLIENT_ID,SUB_NAME,PRIORITY)
)
  ENGINE = InnoDB
  AUTO_INCREMENT = 0;

CREATE INDEX KC_ACTIVEMQ_ACKS_XIDX USING BTREE
ON kc_activemq_acks(XID);

CREATE TABLE kc_activemq_lock  (
  ID         	bigint(20) NOT NULL,
  TIME       	bigint(20) NULL,
  BROKER_NAME	varchar(250) NULL,
  PRIMARY KEY(ID)
)
  ENGINE = InnoDB
  AUTO_INCREMENT = 0;

CREATE TABLE kc_activemq_msgs  (
  ID        	bigint(20) NOT NULL,
  CONTAINER 	varchar(250) NULL,
  MSGID_PROD	varchar(250) NULL,
  MSGID_SEQ 	bigint(20) NULL,
  EXPIRATION	bigint(20) NULL,
  MSG       	longblob NULL,
  PRIORITY  	bigint(20) NULL,
  XID       	varchar(250) NULL,
  PRIMARY KEY(ID)
)
  ENGINE = InnoDB
  AUTO_INCREMENT = 0;

CREATE INDEX KC_ACTIVEMQ_MSGS_CIDX USING BTREE
ON kc_activemq_msgs(CONTAINER);

CREATE INDEX KC_ACTIVEMQ_MSGS_EIDX USING BTREE
ON kc_activemq_msgs(EXPIRATION);

CREATE INDEX KC_ACTIVEMQ_MSGS_MIDX USING BTREE
ON kc_activemq_msgs(MSGID_PROD, MSGID_SEQ);

CREATE INDEX KC_ACTIVEMQ_MSGS_PIDX USING BTREE
ON kc_activemq_msgs(PRIORITY);

CREATE INDEX KC_ACTIVEMQ_MSGS_XIDX USING BTREE
ON kc_activemq_msgs(XID);
