<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="0.2in" margin-right="0.2in">
				<fo:region-body margin-top="1.3in" margin-bottom="0.45in"/>
				<fo:region-before extent="1.3in"/>
				<fo:region-after extent="0.45in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<xsl:call-template name="footerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<xsl:choose>
								<xsl:when test="budgetSalary/totalPeriod  = 1">
									<xsl:for-each select="budgetSalary">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<xsl:if test="salary">
											<fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
												<fo:table-column column-width="25%"/>
												<fo:table-column column-width="33%"/>
												<fo:table-column column-width="19%"/>
												<fo:table-column column-width="23%"/>
												<fo:table-header start-indent="0pt">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Cost Element</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Name </xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 1</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Total</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body start-indent="0pt">
													<xsl:for-each select="salary">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="costElementDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="name">
																		<xsl:choose>
																			<xsl:when test=". = &quot;Total&quot;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="total">
																		<xsl:choose>
																			<xsl:when test="string-length( . ) &lt;7">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="."/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt; 12">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="budgetSalary/totalPeriod = 2">
									<xsl:for-each select="budgetSalary">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<xsl:if test="salary">
											<fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
												<fo:table-column column-width="25%"/>
												<fo:table-column column-width="33%"/>
												<fo:table-column column-width="13%"/>
												<fo:table-column column-width="13%"/>
												<fo:table-column column-width="16%"/>
												<fo:table-header start-indent="0pt">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" height="5" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Cost Element</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="5" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Name</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="5" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 1</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="5" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 2</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="5" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Total</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body start-indent="0pt">
													<xsl:for-each select="salary">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="costElementDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="name">
																		<xsl:choose>
																			<xsl:when test=". = &quot;Total&quot;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="total">
																		<xsl:choose>
																			<xsl:when test="string-length( . ) &lt;7">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="."/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt; 12">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="budgetSalary/totalPeriod = 3">
									<xsl:for-each select="budgetSalary">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<xsl:if test="salary">
											<fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
												<fo:table-column column-width="24%"/>
												<fo:table-column column-width="30%"/>
												<fo:table-column column-width="11%"/>
												<fo:table-column column-width="11%"/>
												<fo:table-column column-width="10%"/>
												<fo:table-column column-width="13%"/>
												<fo:table-header start-indent="0pt">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Cost Element</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Name</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 1</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 2</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 3</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Total</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body start-indent="0pt">
													<xsl:for-each select="salary">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="costElementDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="name">
																		<xsl:choose>
																			<xsl:when test=". = &quot;Total&quot;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 3  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="total">
																		<xsl:choose>
																			<xsl:when test="string-length( . ) &lt;7">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="."/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt; 12">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="budgetSalary/totalPeriod  = 4">
									<xsl:for-each select="budgetSalary">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<xsl:if test="salary">
											<fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
												<fo:table-column column-width="18%"/>
												<fo:table-column column-width="25%"/>
												<fo:table-column column-width="11%"/>
												<fo:table-column column-width="11%"/>
												<fo:table-column column-width="11%"/>
												<fo:table-column column-width="11%"/>
												<fo:table-column column-width="13%"/>
												<fo:table-header start-indent="0pt">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Cost Element</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Name</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 1</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 2</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 3</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 4</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Total</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body start-indent="0pt">
													<xsl:for-each select="salary">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="costElementDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="name">
																		<xsl:choose>
																			<xsl:when test=". = &quot;Total&quot;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 3  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 4  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="total">
																		<xsl:choose>
																			<xsl:when test="string-length( . ) &lt;7">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="."/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt; 12">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="budgetSalary/totalPeriod = 5">
									<xsl:for-each select="budgetSalary">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<xsl:if test="salary">
											<fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
												<fo:table-column column-width="16%"/>
												<fo:table-column column-width="22%"/>
												<fo:table-column column-width="10%"/>
												<fo:table-column column-width="10%"/>
												<fo:table-column column-width="10%"/>
												<fo:table-column column-width="10%"/>
												<fo:table-column column-width="10%"/>
												<fo:table-column column-width="12%"/>
												<fo:table-header start-indent="0pt">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Cost Element</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Name</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 1</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 2</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 3</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 4</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Period 5</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline font-size="10pt" font-weight="bold">
																	<xsl:text>Total</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body start-indent="0pt">
													<xsl:for-each select="salary">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="costElementDesc">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="name">
																		<xsl:choose>
																			<xsl:when test=". = &quot;Total&quot;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="Period">
																		<xsl:for-each select="periodCost">
																			<xsl:choose>
																				<xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
																					<fo:inline>
																						<xsl:text>$</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
																					<xsl:choose>
																						<xsl:when test="string-length( . ) &lt;7">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="."/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																						<xsl:when test="string-length( . ) &gt; 12">
																							<fo:inline font-weight="bold">
																								<xsl:text>$</xsl:text>
																							</fo:inline>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																							</fo:inline>
																						</xsl:when>
																					</xsl:choose>
																				</xsl:when>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" text-align="right" display-align="center">
																<fo:block>
																	<xsl:for-each select="total">
																		<xsl:choose>
																			<xsl:when test="string-length( . ) &lt;7">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="."/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																			<xsl:when test="string-length( . ) &gt; 12">
																				<fo:inline font-weight="bold">
																					<xsl:text>$</xsl:text>
																				</fo:inline>
																				<fo:inline font-weight="bold">
																					<xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
																				</fo:inline>
																			</xsl:when>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
				<xsl:variable name="parentTypeName" select="budgetSalary/parentTypeName"/>
				<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="12%"/>
						<fo:table-column column-width="38%"/>
						<fo:table-column column-width="35%"/>
						<fo:table-column column-width="15%"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="8" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" padding-bottom="0" number-columns-spanned="4" height="8" display-align="center">
									<fo:block>
										<fo:block/>
										<fo:inline font-family="Times New Roman" font-size="15pt" font-weight="bold">
										
											<xsl:text>Coeus </xsl:text> 
											<xsl:text/> <xsl:value-of select="$parentTypeName" />
											<xsl:text> Development - Salary requested on proposal budget&#160; </xsl:text>
											
										</fo:inline>
										<fo:inline font-family="Times New Roman" font-size="13pt" font-weight="bold">
											<xsl:text>&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-weight="bold">
										<xsl:text/> <xsl:value-of select="$parentTypeName" />
										<xsl:text> Number:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="budgetSalary">
											<xsl:for-each select="proposalNumber">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
														<fo:block>
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-weight="bold">
											<xsl:text>Budget Version:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="budgetSalary">
											<xsl:for-each select="budgetVersion">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
														<fo:block>
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-weight="bold">
											<xsl:text>Start Date:</xsl:text>
										</fo:inline>
										<fo:inline>
											<xsl:text>&#160;</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="budgetSalary">
											<xsl:for-each select="startDate">
												<fo:inline>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>/</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>/</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</fo:inline>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-weight="bold">
											<xsl:text>End Date:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="budgetSalary">
											<xsl:for-each select="endDate">
												<fo:inline>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>/</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>/</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</fo:inline>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
							<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="right" display-align="before">
									<fo:block>
										<fo:inline font-weight="bold">
											<xsl:text>Comments:</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Times New Roman" font-size="9pt" padding-bottom="0" padding="2pt" text-align="left" display-align="before">
									<fo:block>
										<xsl:for-each select="budgetSalary">
											<xsl:for-each select="Comments">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
														<fo:block>
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
						    </fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="footerall">
		<fo:static-content flow-name="xsl-region-after">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-family="Verdana" font-size="7pt" padding="0" text-align="left" display-align="before">
									<fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block font-size="7pt" margin="0pt">
											<fo:block>
												<fo:inline>
													<xsl:text> Page </xsl:text>
												</fo:inline>
												<fo:page-number/>
												<fo:inline>
													<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
										<fo:inline>
											<xsl:text>Printed On:&#160; </xsl:text>
										</fo:inline>
										<xsl:for-each select="budgetSalary">
											<xsl:for-each select="currentDate">
												<fo:inline>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
													<xsl:text>/</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
													<xsl:text>/</xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
												</fo:inline>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Verdana" font-size="7pt" padding="0" text-align="right" display-align="before">
									<fo:block>
										<fo:inline>
											<xsl:text>&#160;&#160;&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
