<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.4in" margin-right="0.4in">
				<fo:region-body margin-top="0.65in" margin-bottom="0.65in"/>
				<fo:region-after extent="0.65in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="footerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" text-align="center" display-align="center">
											<fo:block>
												<xsl:for-each select="InstituteProposal">
													<xsl:for-each select="SchoolInfo">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:block text-align="center" margin="0pt">
															<fo:block>
																<xsl:for-each select="SchoolName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block font-size="16pt" font-weight="bold">
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline font-size="16pt" font-weight="bold">
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:block>
														<fo:block/>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:block text-align="center" margin="0pt">
															<fo:block>
																<fo:inline font-size="14pt" font-weight="bold">
																	<xsl:text>Proposal Summary </xsl:text>
																</fo:inline>
															</fo:block>
														</fo:block>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="proportional-column-width(1)"/>
															<fo:table-column column-width="proportional-column-width(1)"/>
															<fo:table-column column-width="proportional-column-width(1)"/>
															<fo:table-column column-width="proportional-column-width(1)"/>
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Institutional Proposal ID:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="proposalNumber">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Proposal Type:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="proposalType">
																						<xsl:for-each select="proposalTypeDesc">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Account ID:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="accountNumber">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Sponsor Proposal ID:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="sponsorProposalNumber">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Type of Activity:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="activityType">
																						<xsl:for-each select="activityTypeDesc">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Subaward(s):</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="hasSubcontracts">
																						<xsl:choose>
																							<xsl:when test=". = &apos;true&apos;">
																								<fo:inline>
																									<xsl:text>Yes</xsl:text>
																								</fo:inline>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:text>No</xsl:text>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Opportunity ID:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
													                          <xsl:value-of select="opportunityID"></xsl:value-of>
													                        </xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>CFDA No:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
													                          <xsl:value-of select="CFDANum"></xsl:value-of>
													                        </xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Title of Project:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="title">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:block/>
														<fo:inline font-size="12pt" font-weight="bold">
															<xsl:text>Investigators</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block line-height="9pt" padding="0" margin="0pt">
													<fo:block>
														<xsl:for-each select="InstituteProposal">
															<xsl:for-each select="investigators">
																<xsl:if test="principalInvFlag = &apos;true&apos;">
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block padding="0" margin="0pt">
																		<fo:block>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																				<fo:table-column column-width="50%"/>
																				<fo:table-column column-width="proportional-column-width(1)"/>
																				<fo:table-column column-width="proportional-column-width(1)"/>
																				<fo:table-body start-indent="0pt">
																					<fo:table-row>
																						<fo:table-cell line-height="9pt" padding="0" padding-left="30pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="PIName">
																									<xsl:for-each select="fullName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block font-weight="bold">
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline font-weight="bold">
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Faculty:</xsl:text>
																								</fo:inline>
																								<fo:inline>
																									<xsl:text>&#160;</xsl:text>
																								</fo:inline>
																								<xsl:for-each select="facultyFlag">
																									<xsl:choose>
																										<xsl:when test=". = &apos;Y&apos; or .= &apos;true&apos;">
																											<fo:inline>
																												<xsl:text>Yes</xsl:text>
																											</fo:inline>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:text>No</xsl:text>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																					<fo:table-row>
																						<fo:table-cell padding-left="60pt" number-columns-spanned="3" padding="2pt" display-align="center">
																							<fo:block>
																								<fo:block>
																									<fo:leader leader-pattern="space"/>
																								</fo:block>
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																								</fo:inline-container>
																								<fo:block line-height="9pt" margin="0pt">
																									<fo:block>
																										<xsl:for-each select="unit">
																											<fo:block>
																												<fo:leader leader-pattern="space"/>
																											</fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:block line-height="9pt" padding="0" margin="0pt">
																												<fo:block>
																													<xsl:if test="leadUnitFlag = &apos;true&apos;">
																														<xsl:for-each select="unitNumber">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																														<fo:inline font-weight="bold">
																															<xsl:text> : </xsl:text>
																														</fo:inline>
																														<xsl:for-each select="unitName">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</xsl:if>
																												</fo:block>
																											</fo:block>
																										</xsl:for-each>
																									</fo:block>
																								</fo:block>
																								<fo:block>
																									<fo:leader leader-pattern="space"/>
																								</fo:block>
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																								</fo:inline-container>
																								<fo:block line-height="9pt" margin="0pt">
																									<fo:block>
																										<xsl:for-each select="unit">
																											<fo:block>
																												<fo:leader leader-pattern="space"/>
																											</fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:block margin="0pt">
																												<fo:block>
																													<xsl:if test="leadUnitFlag != &apos;true&apos;">
																														<xsl:for-each select="unitNumber">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																														<fo:inline font-weight="bold">
																															<xsl:text> : </xsl:text>
																														</fo:inline>
																														<xsl:for-each select="unitName">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</xsl:if>
																												</fo:block>
																											</fo:block>
																										</xsl:for-each>
																									</fo:block>
																								</fo:block>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-body>
																			</fo:table>
																		</fo:block>
																	</fo:block>
																</xsl:if>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block line-height="9pt" margin="0pt">
													<fo:block>
														<xsl:for-each select="InstituteProposal">
															<xsl:for-each select="investigators">
																<xsl:if test="principalInvFlag !=&apos;true&apos;">
																	<fo:block>
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:block padding="0" margin="0pt">
																		<fo:block>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																				<fo:table-column column-width="50%"/>
																				<fo:table-column column-width="proportional-column-width(1)"/>
																				<fo:table-column column-width="proportional-column-width(1)"/>
																				<fo:table-body start-indent="0pt">
																					<fo:table-row>
																						<fo:table-cell padding="0" padding-left="30pt" display-align="after">
																							<fo:block>
																								<xsl:for-each select="PIName">
																									<xsl:for-each select="fullName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="after">
																							<fo:block>
																								<fo:inline font-weight="bold">
																									<xsl:text>Faculty:</xsl:text>
																								</fo:inline>
																								<fo:inline>
																									<xsl:text>&#160;</xsl:text>
																								</fo:inline>
																								<xsl:for-each select="facultyFlag">
																									<xsl:choose>
																										<xsl:when test=". = &apos;Y&apos; or .= &apos;true&apos;">
																											<fo:inline>
																												<xsl:text>Yes</xsl:text>
																											</fo:inline>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:text>No</xsl:text>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																					<fo:table-row>
																						<fo:table-cell padding-left="60pt" number-columns-spanned="3" padding="2pt" height="155" display-align="before">
																							<fo:block>
																								<fo:block>
																									<fo:leader leader-pattern="space"/>
																								</fo:block>
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																								</fo:inline-container>
																								<fo:block padding="0" margin="0pt">
																									<fo:block>
																										<xsl:for-each select="unit">
																											<fo:block>
																												<fo:leader leader-pattern="space"/>
																											</fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:block line-height="10pt" margin="0pt">
																												<fo:block>
																													<xsl:if test="leadUnitFlag = &apos;true&apos;">
																														<xsl:for-each select="unitNumber">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																														<fo:inline font-weight="bold">
																															<xsl:text> : </xsl:text>
																														</fo:inline>
																														<xsl:for-each select="unitName">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline font-weight="bold">
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</xsl:if>
																												</fo:block>
																											</fo:block>
																										</xsl:for-each>
																									</fo:block>
																								</fo:block>
																								<fo:block>
																									<fo:leader leader-pattern="space"/>
																								</fo:block>
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																								</fo:inline-container>
																								<fo:block margin="0pt">
																									<fo:block>
																										<xsl:for-each select="unit">
																											<fo:block>
																												<fo:leader leader-pattern="space"/>
																											</fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:block margin="0pt">
																												<fo:block>
																													<xsl:if test="leadUnitFlag != &apos;true&apos;">
																														<xsl:for-each select="unitNumber">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																														<fo:inline font-weight="bold">
																															<xsl:text> : </xsl:text>
																														</fo:inline>
																														<xsl:for-each select="unitName">
																															<xsl:variable name="value-of-template">
																																<xsl:apply-templates/>
																															</xsl:variable>
																															<xsl:choose>
																																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																	<fo:block>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:block>
																																</xsl:when>
																																<xsl:otherwise>
																																	<fo:inline>
																																		<xsl:copy-of select="$value-of-template"/>
																																	</fo:inline>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																													</xsl:if>
																												</fo:block>
																											</fo:block>
																										</xsl:for-each>
																									</fo:block>
																								</fo:block>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</fo:table-body>
																			</fo:table>
																		</fo:block>
																	</fo:block>
																</xsl:if>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:inline font-size="12pt" font-weight="bold">
													<xsl:text>Budget Data</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>												
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="boolean(  InstituteProposal/budgetData/requestedStartDateInitial or  InstituteProposal/budgetData/requestedEndDateInitial or  InstituteProposal/budgetData/requestedStartDateTotal or  InstituteProposal/budgetData/requestedEndDateTotal  )   or  number(   InstituteProposal/budgetData/totalCostInitial  ) &gt; 0 or  number(  InstituteProposal/budgetData/totalCostTotal  ) &gt; 0">
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-body start-indent="0pt">
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block/>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Initial Period</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Total Period</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Requested Start Date:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="requestedStartDateInitial">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="requestedStartDateTotal">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Requested End Date:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="requestedEndDateInitial">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="requestedEndDateTotal">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																								<xsl:text>/</xsl:text>
																								<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Total Direct Cost:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="totalDirectCostInitial">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="totalDirectCostTotal">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Total F&amp;A Cost:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="totalIndirectCostInitial">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="totalIndirectCostTotal">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Total All Cost:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="totalCostInitial">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="budgetData">
																						<xsl:for-each select="totalCostTotal">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="(boolean( InstituteProposal/instProposalMaster/gradStudentCount ) and number (InstituteProposal/instProposalMaster/gradStudentCount) &gt;0) or  (boolean(  InstituteProposal/instProposalMaster/gradStudentmonths  )and number (InstituteProposal/instProposalMaster/gradStudentmonths) &gt;0)">
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="25%"/>
																<fo:table-column column-width="75%"/>
																<fo:table-body start-indent="0pt">
																	<fo:table-row>
																		<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Graduate Students</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding-left="30pt" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Head Count:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="instProposalMaster">
																						<xsl:for-each select="gradStudentCount">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##0')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding-left="30pt" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Person Months:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="instProposalMaster">
																						<xsl:for-each select="gradStudentmonths">
																							<fo:inline>
																								<xsl:value-of select="format-number(number(string(.)), '##,##0.00')"/>
																							</fo:inline>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:block/>
														<fo:inline font-size="12pt" font-weight="bold">
															<xsl:text>Sponsor &amp; Program Information</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="25%"/>
															<fo:table-column column-width="75%"/>
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Sponsor:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="sponsor">
																						<xsl:for-each select="sponsorCode">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<xsl:for-each select="sponsorName">
																							<fo:inline>
																								<xsl:text> : </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>NSF Science Code:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="NSFcode">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>																					
																					<xsl:for-each select="NSFcodeDesc">
																							<fo:inline>
																								<xsl:text> : </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																					</xsl:for-each>																					
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Prime Sponsor:</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:for-each select="InstituteProposal">
																				<xsl:for-each select="instProposalMaster">
																					<xsl:for-each select="primeSponsor">
																						<xsl:for-each select="sponsorCode">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<xsl:for-each select="sponsorName">
																							<fo:inline>
																								<xsl:text> : </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
																		<fo:block>
																			<xsl:if test="boolean( InstituteProposal/mailingInfo/mailToPerson )">
																				<fo:inline-container>
																					<fo:block>
																						<xsl:text>&#x2029;</xsl:text>
																					</fo:block>
																				</fo:inline-container>
																				<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																					<fo:table-column column-width="25%"/>
																					<fo:table-column column-width="75%"/>
																					<fo:table-body start-indent="0pt">
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Attention:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="InstituteProposal">
																										<xsl:for-each select="mailingInfo">
																											<xsl:for-each select="mailToPerson">
																												<xsl:for-each select="fullName">
																													<xsl:variable name="value-of-template">
																														<xsl:apply-templates/>
																													</xsl:variable>
																													<xsl:choose>
																														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																															<fo:block>
																																<xsl:copy-of select="$value-of-template"/>
																															</fo:block>
																														</xsl:when>
																														<xsl:otherwise>
																															<fo:inline>
																																<xsl:copy-of select="$value-of-template"/>
																															</fo:inline>
																														</xsl:otherwise>
																													</xsl:choose>
																												</xsl:for-each>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Address:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="InstituteProposal">
																										<xsl:for-each select="mailingInfo">
																											<xsl:for-each select="mailToPerson">
																												<xsl:for-each select="address">
																													<xsl:variable name="value-of-template">
																														<xsl:apply-templates/>
																													</xsl:variable>
																													<xsl:choose>
																														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																															<fo:block>
																																<xsl:copy-of select="$value-of-template"/>
																															</fo:block>
																														</xsl:when>
																														<xsl:otherwise>
																															<fo:inline>
																																<xsl:copy-of select="$value-of-template"/>
																															</fo:inline>
																														</xsl:otherwise>
																													</xsl:choose>
																												</xsl:for-each>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
																								<fo:block>
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																										<fo:table-column column-width="25%"/>
																										<fo:table-column column-width="25%"/>
																										<fo:table-column column-width="8%"/>
																										<fo:table-column column-width="17%"/>
																										<fo:table-column column-width="5%"/>
																										<fo:table-column column-width="20%"/>
																										<fo:table-body start-indent="0pt">
																											<fo:table-row>
																												<fo:table-cell padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline font-weight="bold">
																															<xsl:text>City:</xsl:text>
																														</fo:inline>
																													</fo:block>
																												</fo:table-cell>
																												<fo:table-cell padding="2pt" display-align="center">
																													<fo:block>
																														<xsl:for-each select="InstituteProposal">
																															<xsl:for-each select="mailingInfo">
																																<xsl:for-each select="mailToPerson">
																																	<xsl:for-each select="City">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates/>
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																												<fo:table-cell padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline font-weight="bold">
																															<xsl:text>State:</xsl:text>
																														</fo:inline>
																													</fo:block>
																												</fo:table-cell>
																												<fo:table-cell padding="2pt" display-align="center">
																													<fo:block>
																														<xsl:for-each select="InstituteProposal">
																															<xsl:for-each select="mailingInfo">
																																<xsl:for-each select="mailToPerson">
																																	<xsl:for-each select="state">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates/>
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																												<fo:table-cell padding="2pt" display-align="center">
																													<fo:block>
																														<fo:inline font-weight="bold">
																															<xsl:text>Postal Code:</xsl:text>
																														</fo:inline>
																													</fo:block>
																												</fo:table-cell>
																												<fo:table-cell padding="2pt" display-align="center">
																													<fo:block>
																														<xsl:for-each select="InstituteProposal">
																															<xsl:for-each select="mailingInfo">
																																<xsl:for-each select="mailToPerson">
																																	<xsl:for-each select="zip">
																																		<xsl:variable name="value-of-template">
																																			<xsl:apply-templates/>
																																		</xsl:variable>
																																		<xsl:choose>
																																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																				<fo:block>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:block>
																																			</xsl:when>
																																			<xsl:otherwise>
																																				<fo:inline>
																																					<xsl:copy-of select="$value-of-template"/>
																																				</fo:inline>
																																			</xsl:otherwise>
																																		</xsl:choose>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</fo:block>
																												</fo:table-cell>
																											</fo:table-row>
																										</fo:table-body>
																									</fo:table>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																						<fo:table-row>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<fo:inline font-weight="bold">
																										<xsl:text>Phone Number:</xsl:text>
																									</fo:inline>
																								</fo:block>
																							</fo:table-cell>
																							<fo:table-cell padding="2pt" display-align="center">
																								<fo:block>
																									<xsl:for-each select="InstituteProposal">
																										<xsl:for-each select="mailingInfo">
																											<xsl:for-each select="mailToPerson">
																												<xsl:for-each select="phone">
																													<xsl:variable name="value-of-template">
																														<xsl:apply-templates/>
																													</xsl:variable>
																													<xsl:choose>
																														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																															<fo:block>
																																<xsl:copy-of select="$value-of-template"/>
																															</fo:block>
																														</xsl:when>
																														<xsl:otherwise>
																															<fo:inline>
																																<xsl:copy-of select="$value-of-template"/>
																															</fo:inline>
																														</xsl:otherwise>
																													</xsl:choose>
																												</xsl:for-each>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</fo:block>
																							</fo:table-cell>
																						</fo:table-row>
																					</fo:table-body>
																				</fo:table>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:if test="boolean(  InstituteProposal/instProposalMaster/NoticeOfOpportunity  )">
																				<fo:inline font-weight="bold">
																					<xsl:text>Notice of Opportunity:</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="center">
																		<fo:block>
																			<xsl:if test="boolean(  InstituteProposal/instProposalMaster/NoticeOfOpportunity  )">
																				<xsl:for-each select="InstituteProposal">
																					<xsl:for-each select="instProposalMaster">
																						<xsl:for-each select="NoticeOfOpportunity">
																							<xsl:for-each select="NoticeOfOppDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="boolean( InstituteProposal/mailingInfo/deadlineType ) or  boolean(  InstituteProposal/mailingInfo/mailByOSP  ) or  boolean(  InstituteProposal/mailingInfo/mailType  ) or  string-length(  InstituteProposal/mailingInfo/comments  ) &gt; 0">
															<fo:block/>
															<fo:inline font-size="12pt" font-weight="bold">
																<xsl:text>Delivery Information</xsl:text>
															</fo:inline>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<xsl:if test="boolean( InstituteProposal/mailingInfo/deadlineType ) or  boolean(  InstituteProposal/mailingInfo/mailByOSP  ) or  boolean(  InstituteProposal/mailingInfo/mailType  ) or  string-length(  InstituteProposal/mailingInfo/comments  ) &gt; 0">
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:block margin="0pt">
														<fo:block>
															<xsl:if test="boolean( InstituteProposal/mailingInfo/deadlineType ) or  boolean(  InstituteProposal/mailingInfo/mailByOSP  ) or  boolean(  InstituteProposal/mailingInfo/mailType  )">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																	<fo:table-column column-width="25%"/>
																	<fo:table-column column-width="25%"/>
																	<fo:table-column column-width="50%"/>
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Sponsor Deadline Date:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="mailingInfo">
																							<xsl:for-each select="deadlineDate">
																								<fo:inline>
																									<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																									<xsl:text>/</xsl:text>
																									<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																									<xsl:text>/</xsl:text>
																									<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																								</fo:inline>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Sponsor Deadline Type:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="mailingInfo">
																							<xsl:for-each select="deadlineType">
																								<xsl:choose>
																									<xsl:when test=". = &apos;R&apos;">
																										<fo:inline>
																											<xsl:text>Receipt</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:when test=". = &apos;P&apos;">
																										<fo:inline>
																											<xsl:text>Postmark</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:otherwise/>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Mail By:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="mailingInfo">
																							<xsl:for-each select="mailByOSP">
																								<xsl:choose>
																									<xsl:when test=". = &apos;1&apos;">
																										<fo:inline>
																											<xsl:text>OSP</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:when test=". = &apos;2&apos;">
																										<fo:inline>
																											<xsl:text>Department</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:otherwise/>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Delivery Type:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="mailingInfo">
																							<xsl:for-each select="mailType">
																								<xsl:choose>
																									<xsl:when test=". = &apos;1&apos;">
																										<fo:inline>
																											<xsl:text>Regular</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:when test=". = &apos;3&apos;">
																										<fo:inline>
																											<xsl:text>Express Courier</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:when test=". = &apos;2&apos;">
																										<fo:inline>
																											<xsl:text>Electronic</xsl:text>
																										</fo:inline>
																									</xsl:when>
																									<xsl:otherwise/>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:if test="InstituteProposal/mailingInfo/mailByOSP = &apos;O&apos; and  InstituteProposal/mailingInfo/mailType = &apos;D&apos;">
																						<fo:inline font-weight="bold">
																							<xsl:text>Mail Account No:</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																						</fo:inline>
																						<xsl:for-each select="InstituteProposal">
																							<xsl:for-each select="mailingInfo">
																								<xsl:for-each select="mailAccount">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</xsl:for-each>
																						</xsl:for-each>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																					</xsl:if>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
															<xsl:if test="string-length(  InstituteProposal/mailingInfo/comments  ) &gt; 0">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																	<fo:table-column column-width="25%"/>
																	<fo:table-column column-width="75%"/>
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell padding-top="0" padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Comments:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding-top="0" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="mailingInfo">
																							<xsl:for-each select="comments">
																								<fo:inline-container>
																									<fo:block>
																										<xsl:text>&#x2029;</xsl:text>
																									</fo:block>
																								</fo:inline-container>
																								<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																									<fo:block>
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block line-height="8pt">
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline line-height="8pt">
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</fo:block>
																								</fo:block>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
														</fo:block>
													</fo:block>
												</xsl:if>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/scienceCode">
															<fo:block/>
															<fo:inline font-size="12pt" font-weight="bold">
																<xsl:text>Keywords</xsl:text>
															</fo:inline>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/scienceCode">
															<xsl:for-each select="InstituteProposal">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="scienceCode">
																	<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-header start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Code</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Description</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-header>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="scienceCode">
																				<fo:table-row>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="scienceCode">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="scienceCodeDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</xsl:for-each>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/IDCRates or  string-length(  InstituteProposal/IDCRatesComments  )  &gt; 0">
															<fo:inline font-size="12pt" font-weight="bold">
																<xsl:text>F&amp;A Rates</xsl:text>
															</fo:inline>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" height="18" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/IDCRates or  string-length(  InstituteProposal/IDCRatesComments  )  &gt; 0">
															<xsl:if test="InstituteProposal/IDCRates">
																<xsl:for-each select="InstituteProposal">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="IDCRates">
																		<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-header start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Rate</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>F&amp;A Rate Type</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Year</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>On Campus</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Unrecovered F&amp;A</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Source</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="IDCRates">
																					<fo:table-row>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="rate">
																									<fo:inline>
																										<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																									</fo:inline>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="rateType">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="FY">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="onCampus">
																									<xsl:choose>
																										<xsl:when test=". = &apos;true&apos;">
																											<fo:inline>
																												<xsl:text>Yes</xsl:text>
																											</fo:inline>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:text>No</xsl:text>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="underRecovery">
																									<fo:inline>
																										<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																									</fo:inline>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="sourceAccount">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</xsl:for-each>
															</xsl:if>
															<xsl:if test="string-length(  InstituteProposal/IDCRatesComments  )  &gt; 0">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																	<fo:table-column column-width="17%"/>
																	<fo:table-column column-width="83%"/>
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Comments:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding-left="1pt" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="IDCRatesComments">
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																								<fo:block>
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block line-height="8pt">
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline line-height="8pt">
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</fo:block>
																							</fo:block>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/specialReviews">
															<fo:block/>
															<fo:inline font-size="12pt" font-weight="bold">
																<xsl:text>Compliance</xsl:text>
															</fo:inline>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/specialReviews">
															<xsl:for-each select="InstituteProposal">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="specialReviews">
																	<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-header start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Type</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Approval Status</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Protocol No</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Application Date</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-weight="bold">
																							<xsl:text>Approval Date</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-header>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="specialReviews">
																				<fo:table-row>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="specialReviewType">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="specialReviewStatus">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="protocolNumber">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="applicationDate">
																								<fo:inline>
																									<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																									<xsl:text>/</xsl:text>
																									<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																									<xsl:text>/</xsl:text>
																									<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																								</fo:inline>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="approvalDate">
																								<fo:inline>
																									<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																									<xsl:text>/</xsl:text>
																									<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																									<xsl:text>/</xsl:text>
																									<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																								</fo:inline>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																				<fo:table-row>
																					<fo:table-cell padding-left="30pt" padding-top="0" padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:if test="string-length(  comments  ) &gt;0">
																								<fo:inline font-weight="bold">
																									<xsl:text>comment:</xsl:text>
																								</fo:inline>
																							</xsl:if>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding-top="0" number-columns-spanned="4" padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:if test="string-length(  comments  ) &gt;0">
																								<xsl:for-each select="comments">
																									<fo:inline-container>
																										<fo:block>
																											<xsl:text>&#x2029;</xsl:text>
																										</fo:block>
																									</fo:inline-container>
																									<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																										<fo:block>
																											<xsl:variable name="value-of-template">
																												<xsl:apply-templates/>
																											</xsl:variable>
																											<xsl:choose>
																												<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																													<fo:block line-height="8pt">
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:block>
																												</xsl:when>
																												<xsl:otherwise>
																													<fo:inline line-height="8pt">
																														<xsl:copy-of select="$value-of-template"/>
																													</fo:inline>
																												</xsl:otherwise>
																											</xsl:choose>
																										</fo:block>
																									</fo:block>
																								</xsl:for-each>
																							</xsl:if>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</xsl:for-each>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/costSharingInfo or  string-length(  InstituteProposal/costSharingComments  ) &gt; 0">
															<fo:block/>
															<fo:inline font-size="12pt" font-weight="bold">
																<xsl:text>Cost Sharing</xsl:text>
															</fo:inline>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" padding-left="30pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="InstituteProposal/costSharingInfo or  string-length(  InstituteProposal/costSharingComments  ) &gt; 0">
															<xsl:if test="InstituteProposal/costSharingInfo">
																<xsl:for-each select="InstituteProposal">
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<xsl:if test="costSharingInfo">
																		<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-column column-width="proportional-column-width(1)"/>
																			<fo:table-header start-indent="0pt">
																				<fo:table-row>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Percentage</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Cost Share Type</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:value-of select="/InstituteProposal/costSharingProjectPeriodFieldDescription"/>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Source Account</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<fo:inline font-weight="bold">
																								<xsl:text>Amount</xsl:text>
																							</fo:inline>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:for-each select="costSharingInfo">
																					<fo:table-row>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="percentage">
																									<fo:inline>
																										<xsl:value-of select="format-number(number(string(.)), '##0.00')"/>
																									</fo:inline>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="costSharingType">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="FY">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="sourceAccount">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																						<fo:table-cell padding="2pt" display-align="center">
																							<fo:block>
																								<xsl:for-each select="amount">
																									<fo:inline>
																										<xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
																									</fo:inline>
																								</xsl:for-each>
																							</fo:block>
																						</fo:table-cell>
																					</fo:table-row>
																				</xsl:for-each>
																			</fo:table-body>
																		</fo:table>
																	</xsl:if>
																</xsl:for-each>
															</xsl:if>
															<xsl:if test="string-length(  InstituteProposal/costSharingComments  ) &gt;0">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																	<fo:table-column column-width="20%"/>
																	<fo:table-column column-width="80%"/>
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>comment:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="InstituteProposal">
																						<xsl:for-each select="costSharingComments">
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																								<fo:block>
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block line-height="8pt">
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline line-height="8pt">
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</fo:block>
																							</fo:block>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</xsl:if>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:block>
														<xsl:if test="string-length( InstituteProposal/instProposalMaster/comments ) &gt; 0">
															<fo:block/>
															<fo:inline font-size="12pt" font-weight="bold">
																<xsl:text>Remarks/Summary:</xsl:text>
															</fo:inline>
														</xsl:if>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding-left="30pt" padding="2pt" display-align="center">
											<fo:block>
												<xsl:if test="string-length( InstituteProposal/instProposalMaster/comments ) &gt; 0">
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:block margin="0pt">
														<fo:block>
															<xsl:for-each select="InstituteProposal">
																<xsl:for-each select="instProposalMaster">
																	<xsl:for-each select="comments">
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																			<fo:block>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block line-height="8pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline line-height="8pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:block>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:block>
												</xsl:if>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<xsl:if test="InstituteProposal/otherData">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt" font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-size="12pt" font-weight="bold">
														<xsl:text>Other Data</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="9pt" padding-left="30pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:if test="InstituteProposal/otherData">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>													
														<xsl:if test="InstituteProposal/otherData/OtherGroupDetails">
															<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="25%"/>	
																<fo:table-column column-width="11%"/>															
																<fo:table-column column-width="proportional-column-width(1)"/>																
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-body start-indent="0pt">
																	<xsl:for-each select="InstituteProposal">
																		<xsl:for-each select="otherData">
																			<xsl:for-each select="OtherGroupDetails">
																				<fo:table-row>
																					<fo:table-cell font-family="Arial" font-size="9pt" padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="ColumnName">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block font-weight="bold">
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline font-weight="bold">
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																								<fo:inline>
																									<xsl:text>:</xsl:text>
																								</fo:inline>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial" font-size="9pt" number-columns-spanned="2" padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="ColumnValue">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell font-family="Arial" font-size="9pt" padding-left="20pt" padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="ColumnDesc">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>																					
																				</fo:table-row>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:table-body>
															</fo:table>
														</xsl:if>
													</xsl:if>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:if>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template match="InstituteProposal">
		<xsl:variable name="value-of-template">
			<xsl:apply-templates/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
				<fo:block>
					<xsl:copy-of select="$value-of-template"/>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline>
					<xsl:copy-of select="$value-of-template"/>
				</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="footerall">
		<fo:static-content flow-name="xsl-region-after">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="1" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="1" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" text-align="left" display-align="center">
									<fo:block>
										<fo:inline font-family="Times New Roman" font-size="8pt">
											<xsl:text>Institutional Proposal ID:&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
										</fo:inline>
										<xsl:for-each select="InstituteProposal">
											<xsl:for-each select="instProposalMaster">
												<xsl:for-each select="proposalNumber">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block font-family="Times New Roman" font-size="8pt">
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline font-family="Times New Roman" font-size="8pt">
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding="0" text-align="right" display-align="center">
									<fo:block>
										<fo:inline font-family="Times New Roman" font-size="8pt">
											<xsl:text>Page: </xsl:text>
										</fo:inline>
										<fo:page-number font-family="Times New Roman" font-size="8pt"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
