/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteStoredScriptAction
extends AcknowledgedTransportMasterNodeAction<DeleteStoredScriptRequest> {
    private final ScriptService scriptService;

    @Inject
    public TransportDeleteStoredScriptAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService) {
        super("cluster:admin/script/delete", transportService, clusterService, threadPool, actionFilters, DeleteStoredScriptRequest::new, indexNameExpressionResolver, "same");
        this.scriptService = scriptService;
    }

    @Override
    protected void masterOperation(DeleteStoredScriptRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.scriptService.deleteStoredScript(this.clusterService, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteStoredScriptRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

