/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class IngestStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;
    private final List<PipelineStat> pipelineStats;
    private final Map<String, List<ProcessorStat>> processorStats;

    public IngestStats(Stats totalStats, List<PipelineStat> pipelineStats, Map<String, List<ProcessorStat>> processorStats) {
        this.totalStats = totalStats;
        this.pipelineStats = pipelineStats;
        this.processorStats = processorStats;
    }

    public IngestStats(StreamInput in) throws IOException {
        this.totalStats = new Stats(in);
        int size = in.readVInt();
        this.pipelineStats = new ArrayList<PipelineStat>(size);
        this.processorStats = new HashMap<String, List<ProcessorStat>>(size);
        for (int i = 0; i < size; ++i) {
            String pipelineId = in.readString();
            Stats pipelineStat = new Stats(in);
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineStat));
            if (!in.getVersion().onOrAfter(Version.V_6_5_0)) continue;
            int processorsSize = in.readVInt();
            ArrayList<ProcessorStat> processorStatsPerPipeline = new ArrayList<ProcessorStat>(processorsSize);
            for (int j = 0; j < processorsSize; ++j) {
                String processorName = in.readString();
                String processorType = "_NOT_AVAILABLE";
                if (in.getVersion().onOrAfter(Version.V_7_6_0)) {
                    processorType = in.readString();
                }
                Stats processorStat = new Stats(in);
                processorStatsPerPipeline.add(new ProcessorStat(processorName, processorType, processorStat));
            }
            this.processorStats.put(pipelineId, processorStatsPerPipeline);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVInt(this.pipelineStats.size());
        for (PipelineStat pipelineStat : this.pipelineStats) {
            out.writeString(pipelineStat.getPipelineId());
            pipelineStat.getStats().writeTo(out);
            if (!out.getVersion().onOrAfter(Version.V_6_5_0)) continue;
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.getPipelineId());
            if (processorStatsForPipeline == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeVInt(processorStatsForPipeline.size());
            for (ProcessorStat processorStat : processorStatsForPipeline) {
                out.writeString(processorStat.getName());
                if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
                    out.writeString(processorStat.getType());
                }
                processorStat.getStats().writeTo(out);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ingest");
        builder.startObject("total");
        this.totalStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("pipelines");
        for (PipelineStat pipelineStat : this.pipelineStats) {
            builder.startObject(pipelineStat.getPipelineId());
            pipelineStat.getStats().toXContent(builder, params);
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.getPipelineId());
            builder.startArray("processors");
            if (processorStatsForPipeline != null) {
                for (ProcessorStat processorStat : processorStatsForPipeline) {
                    builder.startObject();
                    builder.startObject(processorStat.getName());
                    builder.field("type", processorStat.getType());
                    builder.startObject("stats");
                    processorStat.getStats().toXContent(builder, params);
                    builder.endObject();
                    builder.endObject();
                    builder.endObject();
                }
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public Stats getTotalStats() {
        return this.totalStats;
    }

    public List<PipelineStat> getPipelineStats() {
        return this.pipelineStats;
    }

    public Map<String, List<ProcessorStat>> getProcessorStats() {
        return this.processorStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestStats that = (IngestStats)o;
        return Objects.equals(this.totalStats, that.totalStats) && Objects.equals(this.pipelineStats, that.pipelineStats) && Objects.equals(this.processorStats, that.processorStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalStats, this.pipelineStats, this.processorStats);
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private final long ingestCount;
        private final long ingestTimeInMillis;
        private final long ingestCurrent;
        private final long ingestFailedCount;

        public Stats(long ingestCount, long ingestTimeInMillis, long ingestCurrent, long ingestFailedCount) {
            this.ingestCount = ingestCount;
            this.ingestTimeInMillis = ingestTimeInMillis;
            this.ingestCurrent = ingestCurrent;
            this.ingestFailedCount = ingestFailedCount;
        }

        public Stats(StreamInput in) throws IOException {
            this.ingestCount = in.readVLong();
            this.ingestTimeInMillis = in.readVLong();
            this.ingestCurrent = in.readVLong();
            this.ingestFailedCount = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.ingestCount);
            out.writeVLong(this.ingestTimeInMillis);
            out.writeVLong(this.ingestCurrent);
            out.writeVLong(this.ingestFailedCount);
        }

        public long getIngestCount() {
            return this.ingestCount;
        }

        public long getIngestTimeInMillis() {
            return this.ingestTimeInMillis;
        }

        public long getIngestCurrent() {
            return this.ingestCurrent;
        }

        public long getIngestFailedCount() {
            return this.ingestFailedCount;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.ingestCount);
            builder.humanReadableField("time_in_millis", "time", (Object)new TimeValue(this.ingestTimeInMillis, TimeUnit.MILLISECONDS));
            builder.field("current", this.ingestCurrent);
            builder.field("failed", this.ingestFailedCount);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats that = (Stats)o;
            return Objects.equals(this.ingestCount, that.ingestCount) && Objects.equals(this.ingestTimeInMillis, that.ingestTimeInMillis) && Objects.equals(this.ingestFailedCount, that.ingestFailedCount) && Objects.equals(this.ingestCurrent, that.ingestCurrent);
        }

        public int hashCode() {
            return Objects.hash(this.ingestCount, this.ingestTimeInMillis, this.ingestFailedCount, this.ingestCurrent);
        }
    }

    public static class PipelineStat {
        private final String pipelineId;
        private final Stats stats;

        public PipelineStat(String pipelineId, Stats stats) {
            this.pipelineId = pipelineId;
            this.stats = stats;
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public Stats getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineStat that = (PipelineStat)o;
            return Objects.equals(this.pipelineId, that.pipelineId) && Objects.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.pipelineId, this.stats);
        }
    }

    public static class ProcessorStat {
        private final String name;
        private final String type;
        private final Stats stats;

        public ProcessorStat(String name, String type, Stats stats) {
            this.name = name;
            this.type = type;
            this.stats = stats;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Stats getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorStat that = (ProcessorStat)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.stats);
        }
    }

    static class Builder {
        private Stats totalStats;
        private List<PipelineStat> pipelineStats = new ArrayList<PipelineStat>();
        private Map<String, List<ProcessorStat>> processorStats = new HashMap<String, List<ProcessorStat>>();

        Builder() {
        }

        Builder addTotalMetrics(IngestMetric totalMetric) {
            this.totalStats = totalMetric.createStats();
            return this;
        }

        Builder addPipelineMetrics(String pipelineId, IngestMetric pipelineMetric) {
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineMetric.createStats()));
            return this;
        }

        Builder addProcessorMetrics(String pipelineId, String processorName, String processorType, IngestMetric metric) {
            this.processorStats.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStat(processorName, processorType, metric.createStats()));
            return this;
        }

        IngestStats build() {
            return new IngestStats(this.totalStats, Collections.unmodifiableList(this.pipelineStats), Collections.unmodifiableMap(this.processorStats));
        }
    }
}

