/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.UnitContactType;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardContactsBean;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.contacts.AwardUnitContactAddRuleImpl;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;

public class AwardUnitContactsBean
extends AwardContactsBean {
    private static final long serialVersionUID = 1421235654899276682L;
    private static final String DEFAULT_GROUP_CODE_FOR_UNIT_CONTACTS = "U";

    public AwardUnitContactsBean(AwardForm awardForm) {
        super(awardForm);
    }

    public void addUnitContact() {
        boolean success = new AwardUnitContactAddRuleImpl().processAddAwardUnitContactBusinessRules(this.getAward(), this.getUnitContact());
        if (success) {
            this.getAward().add(this.getUnitContact());
            this.init();
        }
    }

    public void deleteUnitContact(int lineToDelete) {
        this.deleteUnitContact(this.getUnitContacts(), lineToDelete);
    }

    public void syncAwardUnitContactsToLeadUnitContacts() {
        this.getAward().setAwardUnitContacts(new ArrayList<AwardUnitContact>());
        List<UnitAdministrator> unitAdministrators = this.getUnitService().retrieveUnitAdministratorsByUnitNumber(this.getDocument().getAward().getUnitNumber());
        for (UnitAdministrator unitAdministrator : unitAdministrators) {
            if (!unitAdministrator.getUnitAdministratorType().getDefaultGroupFlag().equals(DEFAULT_GROUP_CODE_FOR_UNIT_CONTACTS)) continue;
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(unitAdministrator.getPersonId());
            AwardUnitContact newAwardUnitContact = new AwardUnitContact(UnitContactType.CONTACT);
            newAwardUnitContact.setPerson(person);
            newAwardUnitContact.setUnitAdministratorUnitNumber(unitAdministrator.getUnitNumber());
            newAwardUnitContact.setAward(this.getDocument().getAward());
            newAwardUnitContact.setUnitAdministratorType(unitAdministrator.getUnitAdministratorType());
            newAwardUnitContact.setUnitAdministratorTypeCode(unitAdministrator.getUnitAdministratorTypeCode());
            newAwardUnitContact.setFullName(person.getFullName());
            newAwardUnitContact.setDefaultUnitContact(true);
            this.getAward().add(newAwardUnitContact);
        }
    }

    public UnitService getUnitService() {
        return KcServiceLocator.getService(UnitService.class);
    }

    @Override
    public KcPersonService getKcPersonService() {
        return KcServiceLocator.getService(KcPersonService.class);
    }

    public AwardUnitContact getUnitContact() {
        return (AwardUnitContact)this.newAwardContact;
    }

    public List<AwardUnitContact> getUnitContacts() {
        return this.getDocument().getAward().getAwardUnitContacts();
    }

    public int getUnitContactsCount() {
        return this.getUnitContacts().size();
    }

    protected void deleteUnitContact(List<AwardUnitContact> contacts, int lineToDelete) {
        if (contacts.size() > lineToDelete) {
            AwardUnitContact foundContact = contacts.get(lineToDelete);
            this.getAward().getAwardUnitContacts().remove(foundContact);
        }
    }

    @Override
    protected Class<? extends ContactRole> getContactRoleType() {
        return ContactType.class;
    }

    @Override
    protected AwardContact createNewContact() {
        return new AwardUnitContact(UnitContactType.CONTACT);
    }
}

