/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.RuleBo;

public class ActionBoServiceImpl
implements ActionBoService {
    private DataObjectService dataObjectService;

    @Override
    public ActionDefinition createAction(ActionDefinition action) {
        String actionNamespaceKey;
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        String actionNameKey = action.getName();
        ActionDefinition existing = this.getActionByNameAndNamespace(actionNameKey, actionNamespaceKey = action.getNamespace());
        if (existing != null) {
            throw new IllegalStateException("the action to create already exists: " + String.valueOf(action));
        }
        ActionBo bo = ActionBo.from(action);
        RuleBo rule = new RuleBo();
        rule.setId(action.getRuleId());
        rule.getActions().add(bo);
        bo.setRule(rule);
        bo = (ActionBo)this.dataObjectService.save((Object)bo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return ActionBo.to(bo);
    }

    @Override
    public ActionDefinition updateAction(ActionDefinition action) {
        ActionDefinition toUpdate;
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        String actionIdKey = action.getId();
        ActionBo existing = (ActionBo)this.dataObjectService.find(ActionBo.class, (Object)actionIdKey);
        if (existing == null) {
            throw new IllegalStateException("the action does not exist: " + String.valueOf(action));
        }
        if (existing.getId().equals(action.getId())) {
            toUpdate = action;
        } else {
            ActionDefinition.Builder builder = ActionDefinition.Builder.create((ActionDefinitionContract)action);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        }
        ActionBo boToUpdate = ActionBo.from(toUpdate);
        BusinessObjectServiceMigrationUtils.deleteMatching(this.dataObjectService, ActionAttributeBo.class, Collections.singletonMap("action.id", toUpdate.getId()));
        ActionBo updatedData = (ActionBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        return ActionBo.to(updatedData);
    }

    @Override
    public ActionDefinition getActionByActionId(String actionId) {
        if (StringUtils.isBlank((String)actionId)) {
            throw new IllegalArgumentException("action ID is null or blank");
        }
        ActionBo bo = (ActionBo)this.dataObjectService.find(ActionBo.class, (Object)actionId);
        return ActionBo.to(bo);
    }

    @Override
    public ActionDefinition getActionByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        ActionBo myAction = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, ActionBo.class, map);
        return ActionBo.to(myAction);
    }

    @Override
    public List<ActionDefinition> getActionsByRuleId(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("ruleId is null or blank");
        }
        List<ActionBo> bos = BusinessObjectServiceMigrationUtils.findMatchingOrderBy(this.dataObjectService, ActionBo.class, Collections.singletonMap("ruleId", ruleId), "sequenceNumber", true);
        return this.convertListOfBosToImmutables(bos);
    }

    @Override
    public ActionDefinition getActionByRuleIdAndSequenceNumber(String ruleId, Integer sequenceNumber) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("ruleId is null or blank");
        }
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("sequenceNumber is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", ruleId);
        map.put("sequenceNumber", sequenceNumber);
        ActionBo bo = (ActionBo)this.dataObjectService.find(ActionBo.class, map);
        return ActionBo.to(bo);
    }

    public ActionAttributeBo getActionAttributeById(String attrId) {
        if (StringUtils.isBlank((String)attrId)) {
            return null;
        }
        return (ActionAttributeBo)this.dataObjectService.find(ActionAttributeBo.class, (Object)attrId);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    List<ActionDefinition> convertListOfBosToImmutables(Collection<ActionBo> actionBos) {
        if (actionBos == null) {
            return Collections.emptyList();
        }
        ArrayList<ActionDefinition> actions = new ArrayList<ActionDefinition>();
        for (ActionBo bo : actionBos) {
            ActionDefinition action = ActionBo.to(bo);
            actions.add(action);
        }
        return Collections.unmodifiableList(actions);
    }
}

