/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinitionContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsTypeAttributeBo;

public final class KrmsAttributeDefinitionServiceImpl
implements KrmsAttributeDefinitionService {
    private CriteriaLookupService criteriaLookupService;
    private DataObjectService dataObjectService;

    @Override
    public Map<String, String> convertAttributeKeys(Map<String, String> attributesByName, String namespace) {
        HashMap<String, String> attributesById = new HashMap<String, String>();
        if (attributesByName != null) {
            for (Map.Entry<String, String> attr : attributesByName.entrySet()) {
                String newKey = this.getKrmsAttributeId(attr.getKey(), namespace);
                if (!StringUtils.isNotEmpty((String)newKey)) continue;
                attributesById.put(newKey, attr.getValue());
            }
        }
        return attributesById;
    }

    @Override
    public String getKrmsAttributeId(String attributeName, String namespace) {
        String returnId = null;
        KrmsAttributeDefinitionBo bo = this.getKrmsAttributeBo(attributeName, namespace);
        if (bo != null) {
            returnId = bo.getId();
        }
        return returnId;
    }

    @Override
    public KrmsAttributeDefinitionBo getKrmsAttributeBo(String attributeName, String namespace) {
        KrmsAttributeDefinitionBo result = null;
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("name", attributeName);
        criteria.put("namespace", namespace);
        criteria.put("active", Boolean.TRUE);
        List<KrmsAttributeDefinitionBo> defs = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), KrmsAttributeDefinitionBo.class, criteria);
        if (CollectionUtils.isNotEmpty(defs)) {
            if (defs.size() > 1) {
                throw new IllegalStateException("Multiple KrmsAttributeDefinitions found with same name and namespace");
            }
            result = (KrmsAttributeDefinitionBo)defs.iterator().next();
        }
        return result;
    }

    @Override
    public KrmsAttributeDefinition createAttributeDefinition(KrmsAttributeDefinition attributeDefinition) {
        String namespaceKey;
        if (attributeDefinition == null) {
            throw new IllegalArgumentException("attributeDefinition is null");
        }
        String nameKey = attributeDefinition.getName();
        KrmsAttributeDefinition existing = this.getAttributeDefinitionByNameAndNamespace(nameKey, namespaceKey = attributeDefinition.getNamespace());
        if (existing != null && existing.getName().equals(nameKey) && existing.getNamespace().equals(namespaceKey)) {
            throw new IllegalStateException("the krms attribute definition to create already exists: " + String.valueOf(attributeDefinition));
        }
        KrmsAttributeDefinitionBo bo = KrmsAttributeDefinitionBo.from(attributeDefinition);
        bo = (KrmsAttributeDefinitionBo)this.getDataObjectService().save((Object)bo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return KrmsAttributeDefinitionBo.to(bo);
    }

    @Override
    public void updateAttributeDefinition(KrmsAttributeDefinition attributeDefinition) {
        KrmsAttributeDefinition toUpdate;
        if (attributeDefinition == null) {
            throw new IllegalArgumentException("attributeDefinition is null");
        }
        String idKey = attributeDefinition.getId();
        KrmsAttributeDefinitionBo existing = (KrmsAttributeDefinitionBo)this.getDataObjectService().find(KrmsAttributeDefinitionBo.class, (Object)idKey);
        if (existing == null) {
            throw new IllegalStateException("the krms attribute definition does not exist: " + String.valueOf(attributeDefinition));
        }
        if (!existing.getId().equals(attributeDefinition.getId())) {
            KrmsAttributeDefinition.Builder builder = KrmsAttributeDefinition.Builder.create((KrmsAttributeDefinitionContract)attributeDefinition);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = attributeDefinition;
        }
        KrmsAttributeDefinitionBo bo = KrmsAttributeDefinitionBo.from(toUpdate);
        this.getDataObjectService().save((Object)bo, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Override
    public KrmsAttributeDefinition getAttributeDefinitionById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is blank");
        }
        KrmsAttributeDefinitionBo bo = (KrmsAttributeDefinitionBo)this.getDataObjectService().find(KrmsAttributeDefinitionBo.class, (Object)id);
        return KrmsAttributeDefinitionBo.to(bo);
    }

    @Override
    public KrmsAttributeDefinition getAttributeDefinitionByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        KrmsAttributeDefinitionBo bo = this.getKrmsAttributeBo(name, namespace);
        if (bo == null) {
            return null;
        }
        return KrmsAttributeDefinitionBo.to(bo);
    }

    @Override
    public List<KrmsAttributeDefinition> findAttributeDefinitionsByNamespace(String namespace) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", namespace);
        map.put("active", Boolean.TRUE);
        List<KrmsAttributeDefinitionBo> krmsAttributeDefinitionBos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), KrmsAttributeDefinitionBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(krmsAttributeDefinitionBos);
    }

    @Override
    public List<KrmsAttributeDefinition> findAttributeDefinitionsByType(String typeId) {
        List<KrmsAttributeDefinition> results = Collections.emptyList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type.id", typeId);
        map.put("active", Boolean.TRUE);
        List<KrmsTypeAttributeBo> krmsTypeAttributeBos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), KrmsTypeAttributeBo.class, Collections.unmodifiableMap(map));
        if (!CollectionUtils.isEmpty(krmsTypeAttributeBos)) {
            Object[] inList = new String[krmsTypeAttributeBos.size()];
            int inListIdex = 0;
            for (KrmsTypeAttributeBo krmsTypeAttributeBo : krmsTypeAttributeBos) {
                inList[inListIdex] = krmsTypeAttributeBo.getAttributeDefinitionId();
                ++inListIdex;
            }
            QueryByCriteria.Builder qBuilder = QueryByCriteria.Builder.create();
            qBuilder.setPredicates(new Predicate[]{PredicateFactory.in((String)"id", (Object[])inList)});
            QueryResults queryResults = this.getDataObjectService().findMatching(KrmsAttributeDefinitionBo.class, qBuilder.build());
            results = this.convertListOfBosToImmutables(queryResults.getResults());
        }
        return results;
    }

    @Override
    public List<KrmsAttributeDefinition> findAllAttributeDefinitions() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("active", Boolean.TRUE);
        List<KrmsAttributeDefinitionBo> krmsAttributeDefinitionBos = BusinessObjectServiceMigrationUtils.findMatching(this.getDataObjectService(), KrmsAttributeDefinitionBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(krmsAttributeDefinitionBos);
    }

    public List<KrmsAttributeDefinition> convertListOfBosToImmutables(Collection<KrmsAttributeDefinitionBo> krmsAttributeDefinitionBos) {
        ArrayList<KrmsAttributeDefinition> krmsAttributeDefinitions = new ArrayList<KrmsAttributeDefinition>();
        for (KrmsAttributeDefinitionBo bo : krmsAttributeDefinitionBos) {
            KrmsAttributeDefinition krmsAttributeDefinition = KrmsAttributeDefinitionBo.to(bo);
            krmsAttributeDefinitions.add(krmsAttributeDefinition);
        }
        return Collections.unmodifiableList(krmsAttributeDefinitions);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }
}

