/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa.converters;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;

@Converter
public class HashConverter
implements AttributeConverter<String, String> {
    public String convertToDatabaseColumn(String objectValue) {
        if (objectValue == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)objectValue.toString())) {
            return "";
        }
        if (objectValue.toString().endsWith("(&^HSH#&)")) {
            return StringUtils.stripEnd((String)objectValue.toString(), (String)"(&^HSH#&)");
        }
        try {
            return CoreApiServiceLocator.getEncryptionService().hash((Object)objectValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while attempting to hash value for DB: ", e);
        }
    }

    public String convertToEntityAttribute(String dataValue) {
        if (dataValue == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)dataValue.toString())) {
            return "";
        }
        return dataValue.toString() + "(&^HSH#&)";
    }
}

