/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.LazyDynaBean;
import org.apache.commons.beanutils2.MutableDynaClass;

public class LazyDynaMap
extends LazyDynaBean
implements MutableDynaClass {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected boolean restricted;
    protected boolean returnNull;

    public LazyDynaMap() {
        this(null, (Map<String, Object>)null);
    }

    public LazyDynaMap(DynaClass dynaClass) {
        this(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public LazyDynaMap(DynaProperty[] properties) {
        this(null, properties);
    }

    public LazyDynaMap(Map<String, Object> values) {
        this(null, values);
    }

    public LazyDynaMap(String name) {
        this(name, (Map<String, Object>)null);
    }

    public LazyDynaMap(String name, DynaProperty[] properties) {
        this(name, (Map<String, Object>)null);
        if (properties != null) {
            for (DynaProperty property : properties) {
                this.add(property);
            }
        }
    }

    public LazyDynaMap(String name, Map<String, Object> values) {
        this.name = name == null ? "LazyDynaMap" : name;
        this.values = values == null ? this.newMap() : values;
        this.dynaClass = this;
    }

    protected void add(DynaProperty property) {
        this.add(property.getName(), property.getType());
    }

    @Override
    public void add(String name) {
        this.add(name, null);
    }

    @Override
    public void add(String name, Class<?> type) {
        Objects.requireNonNull(name, "name");
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No new properties can be added.");
        }
        this.values.computeIfAbsent(name, k -> type == null ? null : this.createProperty(name, type));
    }

    @Override
    public void add(String name, Class<?> type, boolean readable, boolean writable) {
        throw new UnsupportedOperationException("readable/writable properties not supported");
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        int i = 0;
        DynaProperty[] properties = new DynaProperty[this.values.size()];
        for (Map.Entry e : this.values.entrySet()) {
            String name = (String)e.getKey();
            Object value = this.values.get(name);
            properties[i++] = new DynaProperty(name, value == null ? null : value.getClass());
        }
        return properties;
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        Objects.requireNonNull(name, "name");
        Object value = this.values.get(name);
        if (value == null && this.isReturnNull()) {
            return null;
        }
        if (value == null) {
            return new DynaProperty(name);
        }
        return new DynaProperty(name, value.getClass());
    }

    @Override
    public Map<String, Object> getMap() {
        return this.values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean isDynaProperty(String name) {
        return this.values.containsKey(Objects.requireNonNull(name, "name"));
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    @Override
    public DynaBean newInstance() {
        Map newMap = null;
        try {
            Map temp;
            newMap = temp = (Map)this.getMap().getClass().newInstance();
        }
        catch (Exception ex) {
            newMap = this.newMap();
        }
        LazyDynaMap lazyMap = new LazyDynaMap(newMap);
        DynaProperty[] properties = this.getDynaProperties();
        if (properties != null) {
            for (DynaProperty property : properties) {
                lazyMap.add(property);
            }
        }
        return lazyMap;
    }

    @Override
    public void remove(String name) {
        Objects.requireNonNull(name, "name");
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No properties can be removed.");
        }
        this.values.remove(name);
    }

    @Override
    public void set(String name, Object value) {
        if (this.isRestricted() && !this.values.containsKey(name)) {
            throw new IllegalArgumentException("Invalid property name '" + name + "' (DynaClass is restricted)");
        }
        this.values.put(name, value);
    }

    public void setMap(Map<String, Object> values) {
        this.values = values;
    }

    @Override
    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }
}

