/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.util.ArrayList;
import java.util.List;
import org.displaytag.model.Row;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.test.NumberedItem;

public class SimplePaginatedList
implements PaginatedList<Row> {
    private final List<Row> fullList = new ArrayList<Row>();
    private final int objectsPerPage;
    private final int currentPage;

    public SimplePaginatedList(int objectsPerPage, int currentPage) {
        for (int j = 1; j < 11; ++j) {
            this.fullList.add(new NumberedItem(j));
        }
        this.objectsPerPage = objectsPerPage;
        this.currentPage = currentPage;
    }

    @Override
    public List<Row> getList() {
        int startOffset = this.objectsPerPage * (this.currentPage - 1);
        return this.fullList.subList(startOffset, Math.min(this.fullList.size(), startOffset + this.objectsPerPage));
    }

    @Override
    public int getPageNumber() {
        return this.currentPage;
    }

    @Override
    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    @Override
    public int getFullListSize() {
        return this.fullList.size();
    }

    @Override
    public String getSortCriterion() {
        return "number";
    }

    @Override
    public SortOrderEnum getSortDirection() {
        return SortOrderEnum.DESCENDING;
    }

    @Override
    public String getSearchId() {
        return Integer.toHexString(this.objectsPerPage * 10000 + this.currentPage);
    }
}

