/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailSenderFactoryBean
extends AbstractFactoryBean {
    protected final Logger LOG = LogManager.getLogger(MailSenderFactoryBean.class);
    private static final String MAIL_PREFIX = "mail";
    private static final String USERNAME_PROPERTY = "mail.smtp.username";
    private static final String PASSWORD_PROPERTY = "mail.smtp.password";
    private static final String HOST_PROPERTY = "mail.smtp.host";
    private static final String PORT_PROPERTY = "mail.smtp.port";
    private static final String PROTOCOL_PROPERTY = "mail.transport.protocol";
    private Session mailSession;

    protected Object createInstance() throws Exception {
        String protocol;
        Properties properties = new Properties();
        Properties configProps = ConfigContext.getCurrentContextConfig().getProperties();
        this.LOG.debug("createInstance(): collecting mail properties.");
        for (Object keyObj : configProps.keySet()) {
            String key;
            if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith(MAIL_PREFIX)) continue;
            properties.put(key, configProps.get(key));
        }
        String username = properties.getProperty(USERNAME_PROPERTY);
        String password = properties.getProperty(PASSWORD_PROPERTY);
        if (username != null && password != null) {
            this.mailSession = Session.getInstance((Properties)properties, (Authenticator)new SimpleAuthenticator(username, password));
            this.LOG.info("createInstance(): Initializing mail session using SMTP authentication.");
        } else {
            this.mailSession = Session.getInstance((Properties)properties);
            this.LOG.info("createInstance(): Initializing mail session. No SMTP authentication.");
        }
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        this.LOG.debug("createInstance(): setting SMTP host.");
        mailSender.setHost(properties.getProperty(HOST_PROPERTY));
        if (properties.getProperty(PORT_PROPERTY) != null) {
            this.LOG.debug("createInstance(): setting SMTP port.");
            int smtpPort = Integer.parseInt(properties.getProperty(PORT_PROPERTY).trim());
            mailSender.setPort(smtpPort);
        }
        if (StringUtils.isNotBlank((String)(protocol = properties.getProperty(PROTOCOL_PROPERTY)))) {
            this.LOG.debug("createInstance(): setting mail transport protocol = " + protocol);
            mailSender.setProtocol(protocol);
        }
        mailSender.setSession(this.mailSession);
        this.LOG.info("createInstance(): Mail Sender Factory Bean initialized.");
        return mailSender;
    }

    public Class getObjectType() {
        return JavaMailSenderImpl.class;
    }

    private static class SimpleAuthenticator
    extends Authenticator {
        private final PasswordAuthentication passwordAuthentication;

        private SimpleAuthenticator(String username, String password) {
            this.passwordAuthentication = new PasswordAuthentication(username, password);
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.passwordAuthentication;
        }
    }
}

