/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.permission.GenericPermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class GenericPermissionMaintainable
extends KualiMaintainableImpl {
    private static final Logger LOG = LogManager.getLogger(GenericPermissionMaintainable.class);
    private static final long serialVersionUID = -8102504656976243468L;
    protected static final String DETAIL_OBJECTS_ATTRIBUTE_NAME = "attributeDetails.kimAttribute.attributeName";
    protected static final String DETAIL_OBJECTS_ATTRIBUTE_VALUE = "attributeDetails.attributeValue";

    public void saveDataObject() {
        if (this.getDataObject() instanceof GenericPermissionBo) {
            GenericPermissionBo genericPermissionBo = (GenericPermissionBo)this.getDataObject();
            boolean permissionExists = false;
            if (genericPermissionBo.getId() != null) {
                boolean bl = permissionExists = KimApiServiceLocator.getPermissionService().getPermission(genericPermissionBo.getId()) != null;
            }
            if (genericPermissionBo.getTemplateId() != null) {
                genericPermissionBo.setTemplate(PermissionTemplateBo.from((Template)KimApiServiceLocator.getPermissionService().getPermissionTemplate(genericPermissionBo.getTemplateId())));
            }
            PermissionBo perm = GenericPermissionBo.toPermissionBo((GenericPermissionBo)genericPermissionBo);
            if (permissionExists) {
                KimApiServiceLocator.getPermissionService().updatePermission(PermissionBo.to((PermissionBo)perm));
            } else {
                KimApiServiceLocator.getPermissionService().createPermission(PermissionBo.to((PermissionBo)perm));
            }
        } else {
            throw new RuntimeException("Cannot save object of type: " + String.valueOf(this.getDataObjectClass()) + " with permission service");
        }
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        GenericPermissionBo permissionBo = (GenericPermissionBo)document.getNewMaintainableObject().getDataObject();
        this.initializePermissionId(permissionBo);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        GenericPermissionBo permissionBo = (GenericPermissionBo)document.getNewMaintainableObject().getDataObject();
        this.initializePermissionId(permissionBo);
        permissionBo.setVersionNumber(null);
    }

    private void initializePermissionId(Object dataObject) {
        GenericPermissionBo permissionBo;
        if (dataObject instanceof GenericPermissionBo && StringUtils.isBlank((String)(permissionBo = (GenericPermissionBo)dataObject).getId())) {
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_PERM_ID_S");
            permissionBo.setId(incrementer.nextStringValue());
        }
    }

    public Class getBoClass() {
        return GenericPermissionBo.class;
    }

    public boolean isExternalBusinessObject() {
        return true;
    }

    public void prepareBusinessObject(BusinessObject businessObject) {
        try {
            if (businessObject == null) {
                throw new RuntimeException("Configuration ERROR: GenericPermissionMaintainable.prepareBusinessObject passed a null object.");
            }
            if (businessObject instanceof PermissionBo) {
                PermissionBo perm = (PermissionBo)KradDataServiceLocator.getDataObjectService().find(PermissionBo.class, (Object)((PermissionBo)businessObject).getId());
                businessObject = new GenericPermissionBo(perm);
            } else if (businessObject instanceof GenericPermissionBo) {
                PermissionBo perm = (PermissionBo)KradDataServiceLocator.getDataObjectService().find(PermissionBo.class, (Object)((GenericPermissionBo)businessObject).getId());
                ((GenericPermissionBo)businessObject).loadFromPermission(perm);
            } else {
                throw new RuntimeException("Configuration ERROR: GenericPermissionMaintainable passed an unsupported object type: " + String.valueOf(businessObject.getClass()));
            }
            this.setDataObject(businessObject);
            super.prepareBusinessObject(businessObject);
        }
        catch (RuntimeException ex) {
            LOG.error("Exception in prepareBusinessObject()", (Throwable)ex);
            throw ex;
        }
    }

    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
        String attrName = "";
        String attrValue = "";
        GenericPermissionBo permissionBo = (GenericPermissionBo)document.getNewMaintainableObject().getDataObject();
        this.initializePermissionId(permissionBo);
        permissionBo.setActive(true);
        for (String paramName : parameters.keySet()) {
            String[] parameterValues = parameters.get(paramName);
            if (paramName.equals(DETAIL_OBJECTS_ATTRIBUTE_NAME) && parameterValues.length > 0) {
                attrName = parameterValues[0];
            }
            if (!paramName.equals(DETAIL_OBJECTS_ATTRIBUTE_VALUE) || parameterValues.length <= 0) continue;
            attrValue = parameterValues[0];
        }
        if (StringUtils.isNotEmpty((String)attrName) && StringUtils.isNotEmpty((String)attrValue)) {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put(attrName, attrValue);
            permissionBo.setDetails(details);
        }
        document.getNewMaintainableObject().setDataObject((Object)permissionBo);
    }
}

