/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.result;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;

public class ProcessorResult {
    private final transient List<Constraint> constraints;
    private final transient Constrainable definition;
    private final transient AttributeValueReader attributeValueReader;
    private final List<ConstraintValidationResult> constraintValidationResults;

    public ProcessorResult(ConstraintValidationResult constraintValidationResult) {
        this(constraintValidationResult, null, null, new Constraint[0]);
    }

    public ProcessorResult(ConstraintValidationResult constraintValidationResult, Constrainable definition, AttributeValueReader attributeValueReader, Constraint ... constraints) {
        this.constraintValidationResults = Collections.singletonList(constraintValidationResult);
        this.definition = definition;
        this.attributeValueReader = attributeValueReader;
        this.constraints = Arrays.asList(constraints);
    }

    public ProcessorResult(ConstraintValidationResult constraintValidationResult, Constrainable definition, AttributeValueReader attributeValueReader, List<Constraint> constraints) {
        this.constraintValidationResults = Collections.singletonList(constraintValidationResult);
        this.definition = definition;
        this.attributeValueReader = attributeValueReader;
        this.constraints = constraints;
    }

    public ProcessorResult(List<ConstraintValidationResult> constraintValidationResults) {
        this(constraintValidationResults, null, null, new Constraint[0]);
    }

    public ProcessorResult(List<ConstraintValidationResult> constraintValidationResults, Constrainable definition, AttributeValueReader attributeValueReader, Constraint ... constraints) {
        this.constraintValidationResults = constraintValidationResults;
        this.definition = definition;
        this.attributeValueReader = attributeValueReader;
        this.constraints = Arrays.asList(constraints);
    }

    public boolean isSingleConstraintResult() {
        return this.constraintValidationResults.size() == 1;
    }

    public boolean isDefinitionProvided() {
        return this.definition != null;
    }

    public boolean isAttributeValueReaderProvided() {
        return this.attributeValueReader != null;
    }

    public ConstraintValidationResult getFirstConstraintValidationResult() {
        return this.constraintValidationResults.isEmpty() ? null : this.constraintValidationResults.get(0);
    }

    public List<ConstraintValidationResult> getConstraintValidationResults() {
        return this.constraintValidationResults;
    }

    public Constrainable getDefinition() {
        return this.definition;
    }

    public AttributeValueReader getAttributeValueReader() {
        return this.attributeValueReader;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }
}

