/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionFilter;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.CollectionGroupLineBuilder;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.collections.LineBuilderContext;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

public class CollectionGroupBuilder
implements Serializable {
    private static final long serialVersionUID = -4762031957079895244L;

    public void build(View view, Object model, CollectionGroup collectionGroup) {
        List modelCollection;
        if (collectionGroup.isRenderAddLine() && !Boolean.TRUE.equals(collectionGroup.getReadOnly()) && !collectionGroup.isRenderAddBlankLineButton()) {
            this.buildAddLine(view, model, collectionGroup);
        }
        if (collectionGroup.isRenderAddBlankLineButton() && collectionGroup.getAddBlankLineAction() != null) {
            collectionGroup.getAddBlankLineAction().setRefreshId(collectionGroup.getId());
        }
        if ((modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath())) == null) {
            return;
        }
        List<Integer> showIndexes = this.performCollectionFiltering(view, model, collectionGroup, modelCollection);
        if (collectionGroup.getDisplayCollectionSize() != -1 && showIndexes.size() > collectionGroup.getDisplayCollectionSize()) {
            ArrayList<Integer> newShowIndexes = new ArrayList<Integer>();
            Integer counter = 0;
            for (int index = 0; index < showIndexes.size(); ++index) {
                newShowIndexes.add(showIndexes.get(index));
                Integer n = counter;
                counter = counter + 1;
                if (counter.intValue() == collectionGroup.getDisplayCollectionSize()) break;
            }
            showIndexes = newShowIndexes;
        }
        List<IndexedElement> filteredIndexedElements = this.buildFilteredIndexedCollection(showIndexes, modelCollection);
        collectionGroup.setFilteredCollectionSize(filteredIndexedElements.size());
        this.buildLinesForDisplayedRows(filteredIndexedElements, view, model, collectionGroup);
    }

    private List<IndexedElement> buildFilteredIndexedCollection(List<Integer> showIndexes, List<Object> modelCollection) {
        ArrayList<IndexedElement> filteredIndexedElements = new ArrayList<IndexedElement>(modelCollection.size());
        for (Integer showIndex : showIndexes) {
            filteredIndexedElements.add(new IndexedElement(showIndex, modelCollection.get(showIndex)));
        }
        return filteredIndexedElements;
    }

    protected void buildLinesForDisplayedRows(List<IndexedElement> filteredIndexedElements, View view, Object model, CollectionGroup collectionGroup) {
        if (collectionGroup.isUseServerPaging() && collectionGroup.getDisplayLength() == -1) {
            collectionGroup.setDisplayLength(1);
        }
        int displayStart = collectionGroup.getDisplayStart() != -1 && collectionGroup.isUseServerPaging() ? collectionGroup.getDisplayStart() : 0;
        int displayLength = collectionGroup.getDisplayLength() != -1 && collectionGroup.isUseServerPaging() ? collectionGroup.getDisplayLength() : filteredIndexedElements.size() - displayStart;
        int displayEndExclusive = displayStart + displayLength > filteredIndexedElements.size() ? filteredIndexedElements.size() : displayStart + displayLength;
        List<Object> renderedIndexedElements = displayStart < filteredIndexedElements.size() ? filteredIndexedElements.subList(displayStart, displayEndExclusive) : new ArrayList();
        for (IndexedElement indexedElement : renderedIndexedElements) {
            Object currentLine = indexedElement.element;
            String bindingPathPrefix = collectionGroup.getBindingInfo().getBindingPrefixForNested() + "[" + indexedElement.index + "]";
            this.initializeEditLineDialog(collectionGroup, indexedElement.index, currentLine, model);
            List<? extends Component> components = ComponentUtils.copy(collectionGroup.getLineActions());
            ArrayList<? extends Component> actionComponents = new ArrayList<Component>(components);
            List<? extends Component> lineActions = this.initializeLineActions(actionComponents, view, collectionGroup, currentLine, indexedElement.index);
            LineBuilderContext lineBuilderContext = new LineBuilderContext(indexedElement.index, currentLine, bindingPathPrefix, false, (ViewModel)model, collectionGroup, lineActions);
            this.getCollectionGroupLineBuilder(lineBuilderContext).buildLine();
        }
    }

    protected void initializeEditLineDialog(CollectionGroup collectionGroup, int lineIndex, Object currentLine, Object model) {
        if (!collectionGroup.isEditWithDialog()) {
            return;
        }
        String lineSuffix = "_line" + Integer.toString(lineIndex);
        DialogGroup editLineDialog = ComponentUtils.copy(collectionGroup.getEditLineDialogPrototype());
        editLineDialog.setId("Uif-EditLineDialog_" + collectionGroup.getId() + lineSuffix);
        editLineDialog.setRetrieveViaAjax(true);
        if (this.refreshEditLineDialogContents(editLineDialog, model, collectionGroup, lineIndex)) {
            currentLine = ((UifFormBase)model).getDialogDataObject();
            this.setupEditLineDialog(editLineDialog, collectionGroup, lineIndex, lineSuffix, currentLine);
        }
        if (collectionGroup.getLineDialogs() == null || collectionGroup.getLineDialogs().isEmpty()) {
            collectionGroup.setLineDialogs(new ArrayList<DialogGroup>());
        }
        collectionGroup.getLineDialogs().add(editLineDialog);
    }

    protected void setupEditLineDialog(DialogGroup editLineDialog, CollectionGroup group, int lineIndex, String lineSuffix, Object currentLine) {
        Action editLineInDialogSaveAction = ComponentUtils.copy(group.getEditInDialogSaveActionPrototype());
        editLineInDialogSaveAction.setId(editLineDialog.getId() + "_Uif-EditLineInDialogSaveAction" + Integer.toString(lineIndex));
        Action cancelEditLineInDialogAction = (Action)ComponentFactory.getNewComponentInstance("Uif-DialogDismissButton");
        cancelEditLineInDialogAction.setId(editLineDialog.getId() + "_Uif-DialogDismissButton" + Integer.toString(lineIndex));
        cancelEditLineInDialogAction.setRefreshId(group.getId());
        cancelEditLineInDialogAction.setMethodToCall("closeEditLineDialog");
        cancelEditLineInDialogAction.setDialogDismissOption("REQUEST");
        ArrayList<? extends Component> actionComponents = new ArrayList<Component>();
        if (editLineDialog.getFooter().getItems() != null) {
            actionComponents.addAll(editLineDialog.getFooter().getItems());
        }
        actionComponents.add(editLineInDialogSaveAction);
        actionComponents.add(cancelEditLineInDialogAction);
        editLineDialog.getFooter().setItems(actionComponents);
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(actionComponents, Action.class);
        group.getCollectionGroupBuilder().initializeActions(actions, group, lineIndex);
        editLineDialog.getFooter().setItems(actionComponents);
        if (editLineDialog.getHeader().getUpperGroup().getItems() != null) {
            List<Action> headerActions = ViewLifecycleUtils.getElementsOfTypeDeep(editLineDialog.getHeader().getUpperGroup().getItems(), Action.class);
            this.initializeActions(headerActions, group, lineIndex);
            for (Action headerAction : headerActions) {
                headerAction.setRefreshId(group.getId());
                headerAction.setMethodToCall("closeEditLineDialog");
                headerAction.setDialogDismissOption("REQUEST");
                headerAction.setActionScript(null);
            }
        }
        ContextUtils.updateContextForLine(editLineDialog, group, currentLine, lineIndex, lineSuffix);
    }

    protected List<Integer> performCollectionFiltering(View view, Object model, CollectionGroup collectionGroup, Collection<?> collection) {
        CollectionFilter collectionFilter;
        List<Integer> indexes;
        List<Integer> filteredIndexes = new ArrayList<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            filteredIndexes.add(i);
        }
        if (Inactivatable.class.isAssignableFrom(collectionGroup.getCollectionObjectClass()) && !collectionGroup.isShowInactiveLines()) {
            List<Integer> activeIndexes = collectionGroup.getActiveCollectionFilter().filter(view, model, collectionGroup);
            filteredIndexes = ListUtils.intersection(filteredIndexes, activeIndexes);
        }
        Iterator<CollectionFilter> iterator = collectionGroup.getFilters().iterator();
        while (iterator.hasNext() && !(filteredIndexes = ListUtils.intersection(filteredIndexes, indexes = (collectionFilter = iterator.next()).filter(view, model, collectionGroup))).isEmpty()) {
        }
        return filteredIndexes;
    }

    protected void buildAddLine(View view, Object model, CollectionGroup collectionGroup) {
        this.initializeNewCollectionLine(view, model, collectionGroup, false);
        String addLineBindingPath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        List<? extends Component> actionComponents = this.getAddLineActionComponents(view, model, collectionGroup);
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLineBindingPath);
        boolean bindToForm = false;
        if (StringUtils.isBlank((String)collectionGroup.getAddLinePropertyName())) {
            bindToForm = true;
        }
        LineBuilderContext lineBuilderContext = new LineBuilderContext(-1, addLine, addLineBindingPath, bindToForm, (ViewModel)model, collectionGroup, actionComponents);
        this.getCollectionGroupLineBuilder(lineBuilderContext).buildLine();
    }

    protected List<? extends Component> initializeLineActions(List<? extends Component> lineActions, View view, CollectionGroup collectionGroup, Object collectionLine, int lineIndex) {
        ArrayList<? extends Component> actionComponents = new ArrayList<Component>(ComponentUtils.copy(lineActions));
        if (collectionGroup.isEditWithDialog()) {
            Action editLineActionForDialog = this.setupEditLineActionForDialog(collectionGroup, "_line" + Integer.toString(lineIndex), lineIndex, actionComponents.size());
            actionComponents.add(editLineActionForDialog);
        }
        for (Component component : actionComponents) {
            view.getViewHelperService().setElementContext(component, collectionGroup);
        }
        String lineSuffix = "_line" + Integer.toString(lineIndex);
        ContextUtils.updateContextsForLine(actionComponents, collectionGroup, collectionLine, lineIndex, lineSuffix);
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        for (Component component : actionComponents) {
            expressionEvaluator.evaluatePropertyExpression(view, component.getContext(), component, "id", true);
        }
        ComponentUtils.updateIdsWithSuffixNested(actionComponents, lineSuffix);
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(actionComponents, Action.class);
        this.initializeActions(actions, collectionGroup, lineIndex);
        return actionComponents;
    }

    protected Action setupEditLineActionForDialog(CollectionGroup collectionGroup, String lineSuffix, int lineIndex, int actionIndex) {
        Action action = ComponentUtils.copy(collectionGroup.getEditWithDialogActionPrototype());
        action.setId("Uif-EditLineInDialogAction_" + collectionGroup.getId() + lineSuffix + "_act" + actionIndex);
        String actionScript = "showEditLineDialog('Uif-EditLineDialog_" + collectionGroup.getId() + lineSuffix + "', '" + collectionGroup.getBindingInfo().getBindingName() + "', " + lineIndex + ");";
        action.setActionScript(actionScript);
        return action;
    }

    public void initializeActions(List<Action> actions, CollectionGroup collectionGroup, int lineIndex) {
        for (Action action : actions) {
            if (ComponentUtils.containsPropertyExpression(action, "actionParameters", true)) {
                action.getPropertyExpressions().put("actionParameters['selectedCollectionPath']", "@{'" + collectionGroup.getBindingInfo().getBindingPath() + "'}");
                action.getPropertyExpressions().put("actionParameters['selectedCollectionId']", "@{'" + collectionGroup.getId() + "'}");
                action.getPropertyExpressions().put("actionParameters['selectedLineIndex']", "@{'" + Integer.toString(lineIndex) + "'}");
                action.getPropertyExpressions().put("actionParameters['lineIndex']", "@{'" + Integer.toString(lineIndex) + "'}");
            } else {
                action.addActionParameter("selectedCollectionPath", collectionGroup.getBindingInfo().getBindingPath());
                action.addActionParameter("selectedCollectionId", collectionGroup.getId());
                action.addActionParameter("selectedLineIndex", Integer.toString(lineIndex));
                action.addActionParameter("lineIndex", Integer.toString(lineIndex));
            }
            if (StringUtils.isBlank((String)action.getRefreshId()) && StringUtils.isBlank((String)action.getRefreshPropertyName())) {
                action.setRefreshId(collectionGroup.getId());
            }
            if (!action.isPerformClientSideValidation()) continue;
            Object preSubmitScript = "var valid=validateLine('" + collectionGroup.getBindingInfo().getBindingPath() + "'," + Integer.toString(lineIndex) + ");";
            if (StringUtils.isNotBlank((String)action.getPreSubmitCall())) {
                preSubmitScript = ScriptUtils.appendScript((String)preSubmitScript, "if (valid){valid=function(){" + action.getPreSubmitCall() + "}();}");
            }
            preSubmitScript = (String)preSubmitScript + " return valid;";
            action.setPreSubmitCall((String)preSubmitScript);
            action.setPerformClientSideValidation(false);
        }
    }

    protected List<? extends Component> getAddLineActionComponents(View view, Object model, CollectionGroup collectionGroup) {
        Object addLineDialogActions;
        String lineSuffix = "_add";
        List<? extends Component> lineActionComponents = ComponentUtils.copyComponentList(collectionGroup.getAddLineActions(), lineSuffix);
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(lineActionComponents, Action.class);
        if (collectionGroup.isAddWithDialog() && collectionGroup.getAddLineDialog().getFooter() != null && !collectionGroup.getAddLineDialog().getFooter().getItems().isEmpty() && (addLineDialogActions = ViewLifecycleUtils.getElementsOfTypeDeep(collectionGroup.getAddLineDialog().getFooter().getItems(), Action.class)) != null) {
            actions.addAll((Collection<Action>)addLineDialogActions);
        }
        for (Action action : actions) {
            boolean isPageUpdateAction;
            action.addActionParameter("selectedCollectionPath", collectionGroup.getBindingInfo().getBindingPath());
            action.addActionParameter("selectedCollectionId", collectionGroup.getId());
            action.setJumpToIdAfterSubmit(collectionGroup.getId());
            action.addActionParameter("actionType", "addLine");
            boolean bl = isPageUpdateAction = StringUtils.isNotBlank((String)action.getAjaxReturnType()) && action.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
            if (StringUtils.isBlank((String)action.getRefreshId()) && !isPageUpdateAction) {
                action.setRefreshId(collectionGroup.getId());
            }
            if (collectionGroup.isAddWithDialog() && view instanceof FormView && ((FormView)view).isValidateClientSide()) {
                action.setPerformClientSideValidation(true);
            }
            if (action.isPerformClientSideValidation()) {
                Object preSubmitScript = "var valid=validateAddLine('" + collectionGroup.getId() + "');";
                if (StringUtils.isNotBlank((String)action.getPreSubmitCall())) {
                    preSubmitScript = ScriptUtils.appendScript((String)preSubmitScript, "if (valid){valid=function(){" + action.getPreSubmitCall() + "}();}");
                }
                preSubmitScript = (String)preSubmitScript + "return valid;";
                action.setPreSubmitCall((String)preSubmitScript);
                action.setPerformClientSideValidation(false);
                continue;
            }
            if (!collectionGroup.isAddWithDialog()) continue;
            action.setPreSubmitCall("closeLightbox(); return true;");
        }
        String addLinePath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLinePath);
        ContextUtils.updateContextForLine(collectionGroup.getAddLineDialog(), collectionGroup, addLine, -1, lineSuffix);
        ContextUtils.updateContextsForLine(actions, collectionGroup, addLine, -1, lineSuffix);
        return lineActionComponents;
    }

    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        Object newLine = null;
        if (StringUtils.isBlank((String)collectionGroup.getAddLinePropertyName())) {
            if (!(model instanceof UifFormBase)) {
                throw new RuntimeException("Cannot create new collection line for group: " + collectionGroup.getPropertyName() + ". Model does not extend " + UifFormBase.class.getName());
            }
            HashMap newCollectionLines = (HashMap)ObjectPropertyUtils.getPropertyValue(model, "newCollectionLines");
            if (newCollectionLines == null) {
                newCollectionLines = new HashMap();
                ObjectPropertyUtils.setPropertyValue(model, "newCollectionLines", newCollectionLines);
            }
            String newCollectionLineKey = KRADUtils.translateToMapSafeKey(collectionGroup.getBindingInfo().getBindingPath());
            String addLineBindingPath = "newCollectionLines['" + newCollectionLineKey + "']";
            collectionGroup.getAddLineBindingInfo().setBindingPath(addLineBindingPath);
            if (!newCollectionLines.containsKey(newCollectionLineKey) || newCollectionLines.get(newCollectionLineKey) == null || clearExistingLine) {
                newLine = KRADUtils.createNewObjectFromClass(collectionGroup.getCollectionObjectClass());
                newCollectionLines.put(newCollectionLineKey, newLine);
            }
        } else {
            Object addLine = ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getAddLineBindingInfo().getBindingPath());
            if (addLine == null || clearExistingLine) {
                newLine = KRADUtils.createNewObjectFromClass(collectionGroup.getCollectionObjectClass());
                ObjectPropertyUtils.setPropertyValue(model, collectionGroup.getAddLineBindingInfo().getBindingPath(), newLine);
            }
        }
        if (newLine != null) {
            ViewLifecycle.getHelper().applyDefaultValuesForCollectionLine(collectionGroup, newLine);
        }
    }

    public boolean refreshEditLineDialogContents(DialogGroup dialogGroup, Object model, CollectionGroup collectionGroup, int lineIndex) {
        UifFormBase formBase = (UifFormBase)model;
        String selectedCollectionPath = formBase.getActionParamaterValue("selectedCollectionPath");
        String selectedLineIndex = formBase.getActionParamaterValue("selectedLineIndex");
        return ViewLifecycle.isRefreshLifecycle() && StringUtils.equals((String)dialogGroup.getId(), (String)ViewLifecycle.getRefreshComponentId()) && (StringUtils.equals((String)selectedCollectionPath, (String)collectionGroup.getBindingInfo().getBindingPath()) || StringUtils.startsWith((String)selectedCollectionPath, (String)"dialogDataObject")) && StringUtils.equals((String)selectedLineIndex, (String)Integer.toString(lineIndex));
    }

    public CollectionGroupLineBuilder getCollectionGroupLineBuilder(LineBuilderContext lineBuilderContext) {
        return new CollectionGroupLineBuilder(lineBuilderContext);
    }

    private static class IndexedElement {
        final int index;
        final Object element;

        private IndexedElement(int index, Object element) {
            this.index = index;
            this.element = element;
        }
    }
}

