/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;

public class DocumentFormBase
extends UifFormBase {
    private static final long serialVersionUID = 2190268505427404480L;
    private static final Logger LOG = LogManager.getLogger(DocumentFormBase.class);
    private String annotation = "";
    @RequestAccessible
    private String command;
    @RequestAccessible
    private String docId;
    @RequestAccessible
    private String docTypeName;
    protected Document document;

    public DocumentFormBase() {
        this.instantiateDocument();
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public String getDocTypeName() {
        if (this.docTypeName == null && !this.getDefaultDocumentTypeName().isEmpty()) {
            return this.getDefaultDocumentTypeName();
        }
        return this.docTypeName;
    }

    public void setDocTypeName(String docTypeName) {
        this.docTypeName = docTypeName;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    protected String getDefaultDocumentTypeName() {
        return "";
    }

    protected void instantiateDocument() {
        if (this.document == null && StringUtils.isNotBlank((String)this.getDefaultDocumentTypeName())) {
            Class<? extends Document> documentClass = KRADServiceLocatorWeb.getDataDictionaryService().getValidDocumentClassByTypeName(this.getDefaultDocumentTypeName());
            try {
                Document newDocument = documentClass.newInstance();
                this.setDocument(newDocument);
            }
            catch (Exception e) {
                LOG.error("Unable to instantiate document class " + String.valueOf(documentClass) + " document type " + this.getDefaultDocumentTypeName());
                throw new RuntimeException("Unable to instantiate document class " + String.valueOf(documentClass) + " document type " + this.getDefaultDocumentTypeName(), e);
            }
        }
    }

    public String getDocumentInitiatorNetworkId() {
        String initiatorNetworkId = "";
        if (this.getWorkflowDocument() != null) {
            String initiatorPrincipalId = this.getWorkflowDocument().getInitiatorPrincipalId();
            Person initiator = KimApiServiceLocator.getPersonService().getPerson(initiatorPrincipalId);
            if (initiator != null) {
                initiatorNetworkId = initiator.getPrincipalName();
            }
        }
        return initiatorNetworkId;
    }

    public String getDocumentCreateDate() {
        String createDateStr = "";
        if (this.getWorkflowDocument() != null && this.getWorkflowDocument().getDateCreated() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString(this.getWorkflowDocument().getDateCreated().toDate(), "hh:mm a MM/dd/yyyy");
        }
        return createDateStr;
    }

    public WorkflowDocument getWorkflowDocument() {
        return this.getDocument().getDocumentHeader().getWorkflowDocument();
    }
}

