/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.List;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpStats
implements Writeable,
ToXContentFragment {
    private final long serverOpen;
    private final long totalOpen;
    private final java.util.List<ClientStats> clientStats;

    public HttpStats(java.util.List<ClientStats> clientStats, long serverOpen, long totalOpened) {
        this.clientStats = clientStats;
        this.serverOpen = serverOpen;
        this.totalOpen = totalOpened;
    }

    public HttpStats(long serverOpen, long totalOpened) {
        this(List.of(), serverOpen, totalOpened);
    }

    public HttpStats(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.totalOpen = in.readVLong();
        this.clientStats = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readList(ClientStats::new) : List.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOpen);
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeList(this.clientStats);
        }
    }

    public long getServerOpen() {
        return this.serverOpen;
    }

    public long getTotalOpen() {
        return this.totalOpen;
    }

    public java.util.List<ClientStats> getClientStats() {
        return this.clientStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.field("current_open", this.serverOpen);
        builder.field("total_opened", this.totalOpen);
        builder.startArray("clients");
        for (ClientStats clientStats : this.clientStats) {
            clientStats.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String CURRENT_OPEN = "current_open";
        static final String TOTAL_OPENED = "total_opened";
        static final String CLIENTS = "clients";
        static final String CLIENT_ID = "id";
        static final String CLIENT_AGENT = "agent";
        static final String CLIENT_LOCAL_ADDRESS = "local_address";
        static final String CLIENT_REMOTE_ADDRESS = "remote_address";
        static final String CLIENT_LAST_URI = "last_uri";
        static final String CLIENT_OPENED_TIME_MILLIS = "opened_time_millis";
        static final String CLIENT_CLOSED_TIME_MILLIS = "closed_time_millis";
        static final String CLIENT_LAST_REQUEST_TIME_MILLIS = "last_request_time_millis";
        static final String CLIENT_REQUEST_COUNT = "request_count";
        static final String CLIENT_REQUEST_SIZE_BYTES = "request_size_bytes";
        static final String CLIENT_FORWARDED_FOR = "x_forwarded_for";
        static final String CLIENT_OPAQUE_ID = "x_opaque_id";

        Fields() {
        }
    }

    public static class ClientStats
    implements Writeable,
    ToXContentFragment {
        public static final long NOT_CLOSED = -1L;
        final int id;
        final String agent;
        final String localAddress;
        final String remoteAddress;
        final String lastUri;
        final String forwardedFor;
        final String opaqueId;
        final long openedTimeMillis;
        final long closedTimeMillis;
        final long lastRequestTimeMillis;
        final long requestCount;
        final long requestSizeBytes;

        public ClientStats(int id, String agent, String localAddress, String remoteAddress, String lastUri, String forwardedFor, String opaqueId, long openedTimeMillis, long closedTimeMillis, long lastRequestTimeMillis, long requestCount, long requestSizeBytes) {
            this.id = id;
            this.agent = agent;
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
            this.lastUri = lastUri;
            this.forwardedFor = forwardedFor;
            this.opaqueId = opaqueId;
            this.openedTimeMillis = openedTimeMillis;
            this.closedTimeMillis = closedTimeMillis;
            this.lastRequestTimeMillis = lastRequestTimeMillis;
            this.requestCount = requestCount;
            this.requestSizeBytes = requestSizeBytes;
        }

        ClientStats(StreamInput in) throws IOException {
            this.id = in.readInt();
            this.agent = in.readOptionalString();
            this.localAddress = in.readOptionalString();
            this.remoteAddress = in.readOptionalString();
            this.lastUri = in.readOptionalString();
            this.forwardedFor = in.readOptionalString();
            this.opaqueId = in.readOptionalString();
            this.openedTimeMillis = in.readLong();
            this.closedTimeMillis = in.readLong();
            this.lastRequestTimeMillis = in.readLong();
            this.requestCount = in.readLong();
            this.requestSizeBytes = in.readLong();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            if (this.agent != null) {
                builder.field("agent", this.agent);
            }
            if (this.localAddress != null) {
                builder.field("local_address", this.localAddress);
            }
            if (this.remoteAddress != null) {
                builder.field("remote_address", this.remoteAddress);
            }
            if (this.lastUri != null) {
                builder.field("last_uri", this.lastUri);
            }
            if (this.forwardedFor != null) {
                builder.field("x_forwarded_for", this.forwardedFor);
            }
            if (this.opaqueId != null) {
                builder.field("x_opaque_id", this.opaqueId);
            }
            builder.field("opened_time_millis", this.openedTimeMillis);
            if (this.closedTimeMillis != -1L) {
                builder.field("closed_time_millis", this.closedTimeMillis);
            }
            builder.field("last_request_time_millis", this.lastRequestTimeMillis);
            builder.field("request_count", this.requestCount);
            builder.field("request_size_bytes", this.requestSizeBytes);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.id);
            out.writeOptionalString(this.agent);
            out.writeOptionalString(this.localAddress);
            out.writeOptionalString(this.remoteAddress);
            out.writeOptionalString(this.lastUri);
            out.writeOptionalString(this.forwardedFor);
            out.writeOptionalString(this.opaqueId);
            out.writeLong(this.openedTimeMillis);
            out.writeLong(this.closedTimeMillis);
            out.writeLong(this.lastRequestTimeMillis);
            out.writeLong(this.requestCount);
            out.writeLong(this.requestSizeBytes);
        }
    }
}

