/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.pagination.NumberedPage;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pagination {
    private static Logger log = LoggerFactory.getLogger(Pagination.class);
    private final Href href;
    private final String pageParam;
    private Integer firstPage;
    private Integer lastPage;
    private Integer previousPage;
    private Integer nextPage;
    private Integer currentPage;
    private final List<NumberedPage> pages = new ArrayList<NumberedPage>();
    private final TableProperties properties;

    public Pagination(Href baseHref, String pageParameter, TableProperties properties) {
        this.href = baseHref;
        this.pageParam = pageParameter;
        this.properties = properties;
    }

    public void addPage(int number, boolean isSelected) {
        if (log.isDebugEnabled()) {
            log.debug("adding page {}", (Object)number);
        }
        this.pages.add(new NumberedPage(number, isSelected));
    }

    public boolean isFirst() {
        return this.firstPage == null;
    }

    public boolean isLast() {
        return this.lastPage == null;
    }

    public boolean isOnePage() {
        return this.pages == null || this.pages.size() <= 1;
    }

    public Integer getFirst() {
        return this.firstPage;
    }

    public void setFirst(Integer first) {
        this.firstPage = first;
    }

    public Integer getLast() {
        return this.lastPage;
    }

    public void setLast(Integer last) {
        this.lastPage = last;
    }

    public Integer getPrevious() {
        return this.previousPage;
    }

    public void setPrevious(Integer previous) {
        this.previousPage = previous;
    }

    public Integer getNext() {
        return this.nextPage;
    }

    public void setNext(Integer next) {
        this.nextPage = next;
    }

    public void setCurrent(Integer current) {
        this.currentPage = current;
    }

    public String getFormattedBanner(String numberedPageFormat, String numberedPageSelectedFormat, String numberedPageSeparator, String fullBanner) {
        StringBuilder buffer = new StringBuilder(100);
        Iterator<NumberedPage> pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            NumberedPage page = pageIterator.next();
            Integer pageNumber = page.getNumber();
            String urlString = ((Href)this.href.clone()).addParameter(this.pageParam, pageNumber).toString();
            Object[] pageObjects = new Object[]{pageNumber, urlString};
            if (page.getSelected()) {
                buffer.append(new MessageFormat(numberedPageSelectedFormat, this.properties.getLocale()).format(pageObjects));
            } else {
                buffer.append(new MessageFormat(numberedPageFormat, this.properties.getLocale()).format(pageObjects));
            }
            if (!pageIterator.hasNext()) continue;
            buffer.append(numberedPageSeparator);
        }
        String numberedPageString = buffer.toString();
        Object[] pageObjects = new Object[]{numberedPageString, ((Href)this.href.clone()).addParameter(this.pageParam, this.getFirst()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getPrevious()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getNext()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getLast()), this.currentPage, this.isLast() ? this.currentPage : this.lastPage};
        return new MessageFormat(fullBanner, this.properties.getLocale()).format(pageObjects);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("firstPage", (Object)this.firstPage).append("lastPage", (Object)this.lastPage).append("currentPage", (Object)this.currentPage).append("nextPage", (Object)this.nextPage).append("previousPage", (Object)this.previousPage).append("pages", this.pages).append("href", (Object)this.href).append("pageParam", (Object)this.pageParam).toString();
    }
}

