/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.KcKradTransactionalDocumentViewAuthorizerBase;
import org.kuali.coeus.org.kuali.rice.krad.uif.container.KcCollectionGroupBase;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="proposalDevelopmentDocumentViewAuthorizer")
@Scope(value="prototype")
public class ProposalDevelopmentDocumentViewAuthorizer
extends KcKradTransactionalDocumentViewAuthorizerBase {
    public boolean canViewGroup(View view, ViewModel model, Group group, String groupId, Person user) {
        boolean success = super.canViewGroup(view, model, group, groupId, user);
        if (group.getId().contains("personnelQuestionnaire")) {
            ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
            ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
            int index = this.getIndexFromCollectionGroupId("personnelQuestionnaire", groupId);
            ProposalPerson proposalPerson = document.getDevelopmentProposal().getProposalPersons().get(index);
            success &= ((ProposalDevelopmentDocumentAuthorizer)this.getDocumentAuthorizer()).canViewCertification(document, user) || ((ProposalDevelopmentDocumentAuthorizer)this.getDocumentAuthorizer()).hasCertificationPermissions(document, user, proposalPerson);
        }
        return success;
    }

    public boolean canViewDisclosureDisposition(String user, String personWithDispositionStatus) {
        return user.equalsIgnoreCase(personWithDispositionStatus) || ProposalDevelopmentDocumentViewAuthorizer.getPermissionService().hasPermission(user, "KC-SYS", "View COI Disclosure Disposition");
    }

    public int getIndexFromCollectionGroupId(String prefix, String groupId) {
        String indexStr = groupId.substring(prefix.length() + "_line".length());
        return Integer.parseInt(indexStr);
    }

    @Override
    public Set<String> getActionFlags(View view, ViewModel model, Person user, Set<String> actions) {
        Document document = ((DocumentFormBase)model).getDocument();
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        if (actions.contains("submitToSponsor") && !this.canCreateInstitutionalProposal(document, user)) {
            actions.remove("submitToSponsor");
        }
        if (actions.contains("canEdit") && !this.canEditView(view, model, user)) {
            actions.remove("canEdit");
        }
        if (this.canNotifyProposalPerson(document, user)) {
            actions.add("NOTIFY_PROPOSAL_PERSONS");
        }
        if (this.canBlanketApprove(document, user)) {
            actions.add("canBlanketApprove");
        }
        if (actions.contains("canSuperUserApprove") && developmentProposal.isChild()) {
            actions.remove("canSuperUserApprove");
        }
        if (actions.contains("canSuperUserDisapprove") && developmentProposal.isChild()) {
            actions.remove("canSuperUserDisapprove");
        }
        if (actions.contains("canSuperUserTakeAction") && developmentProposal.isChild()) {
            actions.remove("canSuperUserTakeAction");
        }
        return super.getActionFlags(view, model, user, actions);
    }

    private boolean canCreateInstitutionalProposal(Document document, Person user) {
        boolean hasPermission = false;
        this.initializeDocumentAuthorizerIfNecessary(document);
        if (this.getDocumentAuthorizer() instanceof ProposalDevelopmentDocumentAuthorizer) {
            hasPermission = ((ProposalDevelopmentDocumentAuthorizer)this.getDocumentAuthorizer()).canCreateInstitutionalProposal(document, user);
        }
        return hasPermission;
    }

    private boolean canNotifyProposalPerson(Document document, Person user) {
        boolean hasPermission = false;
        this.initializeDocumentAuthorizerIfNecessary(document);
        if (this.getDocumentAuthorizer() instanceof ProposalDevelopmentDocumentAuthorizer) {
            hasPermission = ((ProposalDevelopmentDocumentAuthorizer)this.getDocumentAuthorizer()).canNotifyProposalPerson(document, user);
        }
        return hasPermission;
    }

    public boolean canEditGroup(View view, ViewModel model, Group group, String groupId, Person user) {
        ProposalDevelopmentDocument document;
        ProposalDevelopmentDocumentForm form;
        if (view.getCurrentPageId().contains("PropDev-AttachmentsPage") && group instanceof KcCollectionGroupBase && ((KcCollectionGroupBase)group).getCollectionObjectClass().equals(Note.class)) {
            form = (ProposalDevelopmentDocumentForm)model;
            document = form.getProposalDevelopmentDocument();
            if (this.getDocumentAuthorizer().canAddNoteAttachment((Document)document, "", user)) {
                return true;
            }
        }
        if (view.getCurrentPageId().contains("PropDev-PermissionsPage")) {
            form = (ProposalDevelopmentDocumentForm)model;
            document = form.getProposalDevelopmentDocument();
            if (((ProposalDevelopmentDocumentAuthorizer)this.getDocumentAuthorizer()).hasAddViewerAuthorization(document, user)) {
                return true;
            }
        }
        if (((ProposalDevelopmentDocumentForm)model).isViewOnly()) {
            return false;
        }
        return super.canEditGroup(view, model, group, groupId, user);
    }

    public boolean canEditView(View view, ViewModel model, Person user) {
        ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm = (ProposalDevelopmentDocumentForm)model;
        if (!proposalDevelopmentDocumentForm.isViewOnly()) {
            return this.transactionDocumentViewAuthorizerCanEditView(view, model, user) && this.userHasLock(user, model);
        }
        return false;
    }

    public boolean transactionDocumentViewAuthorizerCanEditView(View view, ViewModel model, Person user) {
        boolean canEditView = this.documentViewAuthorizerCanEditView(view, model, user);
        Map context = view.getContext();
        DocumentEntry documentEntry = (DocumentEntry)context.get("DocumentEntry");
        if (!documentEntry.getUsePessimisticLocking()) {
            return canEditView;
        }
        DocumentFormBase documentForm = (DocumentFormBase)model;
        Document document = documentForm.getDocument();
        if (canEditView) {
            return this.getPessimisticLockService().establishPessimisticLocks(document, user, canEditView);
        }
        return canEditView;
    }

    public boolean documentViewAuthorizerCanEditView(View view, ViewModel model, Person user) {
        DocumentFormBase documentForm = (DocumentFormBase)model;
        return this.viewHelperServiceCanEditView(view, model, user) && this.canEdit(documentForm.getDocument(), user);
    }

    public boolean viewHelperServiceCanEditView(View view, ViewModel model, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", view.getNamespaceCode());
        additionalPermissionDetails.put("viewId", model.getViewId());
        if (this.permissionExistsByTemplate(model, "KR-KRAD", "Edit View", additionalPermissionDetails)) {
            return this.isAuthorizedByTemplate(model, "KR-KRAD", "Edit View", user.getPrincipalId(), additionalPermissionDetails, null);
        }
        return true;
    }

    public boolean userHasLock(Person user, ViewModel model) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
        for (PessimisticLock lock : form.getDocument().getPessimisticLocks()) {
            if (!lock.isOwnedByUser(user)) continue;
            String lockRegion = StringUtils.split((String)lock.getLockDescriptor(), (String)"-")[1];
            if (!lock.isOwnedByUser(user) || !lockRegion.equals("PROPOSAL DEVELOPMENT")) continue;
            return true;
        }
        return false;
    }
}

