/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.widget.QuickFinder;

@BeanTags(value={@BeanTag(name="dialog", parent="Uif-DialogGroup"), @BeanTag(name="dialogOkCancel", parent="Uif-DialogGroup-OkCancel"), @BeanTag(name="dialogOkCancelExpl", parent="Uif-DialogGroup-OkCancelExpl"), @BeanTag(name="dialogYesNo", parent="Uif-DialogGroup-YesNo"), @BeanTag(name="actionConfirmation", parent="Uif-ActionConfirmation"), @BeanTag(name="actionConfirmationExpl", parent="Uif-ActionConfirmationExpl")})
public class DialogGroup
extends GroupBase {
    private static final long serialVersionUID = 1L;
    private MessageField prompt;
    private InputField explanation;
    private List<KeyValue> availableResponses;
    private String dialogCssClass;
    private String onDialogResponseScript;
    private String onShowDialogScript;
    private String onHideDialogScript;
    private String onHiddenDialogScript;
    private boolean destroyDialogOnHidden;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        this.setRefreshedByAction(true);
        if (this.explanation != null && StringUtils.isBlank((String)this.explanation.getPropertyName()) && StringUtils.isBlank((String)this.explanation.getBindingInfo().getBindingPath())) {
            this.explanation.setPropertyName("dialogExplanations['" + this.getId() + "']");
            this.explanation.getBindingInfo().setBindToForm(true);
        }
        if (this.getItems() == null || this.getItems().isEmpty()) {
            ArrayList<Field> items = new ArrayList<Field>();
            if (this.prompt != null) {
                items.add(this.prompt);
            }
            if (this.explanation != null) {
                items.add(this.explanation);
            }
            this.setItems(items);
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.availableResponses != null && !this.availableResponses.isEmpty()) {
            ArrayList<? extends Component> footerItems = new ArrayList<Component>();
            for (KeyValue keyValue : this.availableResponses) {
                Action responseAction = ComponentFactory.getSecondaryAction();
                responseAction.setDialogDismissOption(UifConstants.DialogDismissOption.PRESUBMIT.name());
                responseAction.setDialogResponse(keyValue.getKey());
                responseAction.setActionLabel(keyValue.getValue());
                footerItems.add(responseAction);
            }
            if (this.getFooter() == null) {
                this.setFooter(ComponentFactory.getFooter());
            }
            if (this.getFooter().getItems() != null) {
                footerItems.addAll(this.getFooter().getItems());
            }
            this.getFooter().setItems(footerItems);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (StringUtils.isNotBlank((String)this.onDialogResponseScript)) {
            this.addDataAttribute("response_handler", this.onDialogResponseScript);
        }
        String script = "jQuery.unblockUI();";
        this.onShowDialogScript = StringUtils.isNotBlank((String)this.onShowDialogScript) ? script + this.onShowDialogScript : script;
        this.addDataAttribute("show_handler", this.onShowDialogScript);
        if (StringUtils.isNotBlank((String)this.onHideDialogScript)) {
            this.addDataAttribute("hide_handler", this.onHideDialogScript);
        }
        if (StringUtils.isBlank((String)this.onHiddenDialogScript)) {
            this.onHiddenDialogScript = "";
        }
        if (this.destroyDialogOnHidden) {
            this.onHiddenDialogScript = this.onHiddenDialogScript + "destroyDialog('" + this.getId() + "');";
        }
        if (StringUtils.isNotBlank((String)this.onHiddenDialogScript)) {
            this.addDataAttribute("hidden_handler", this.onHiddenDialogScript);
        }
        this.getDataAttributes().remove("parent");
        List<QuickFinder> quickFinders = ViewLifecycleUtils.getElementsOfTypeDeep(this.getItems(), QuickFinder.class);
        for (QuickFinder quickFinder : quickFinders) {
            Action quickFinderAction = quickFinder.getQuickfinderAction();
            quickFinderAction.addActionParameter("dialogId", this.getId());
        }
    }

    @BeanTagAttribute
    public String getPromptText() {
        if (this.prompt != null) {
            return this.prompt.getMessage().getMessageText();
        }
        return null;
    }

    public void setPromptText(String promptText) {
        if (this.prompt == null) {
            this.prompt = ComponentFactory.getMessageField();
        }
        this.prompt.setMessageText(promptText);
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute
    public MessageField getPrompt() {
        return this.prompt;
    }

    public void setPrompt(MessageField prompt) {
        this.prompt = prompt;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute
    public InputField getExplanation() {
        return this.explanation;
    }

    public void setExplanation(InputField explanation) {
        this.explanation = explanation;
    }

    @BeanTagAttribute
    public List<KeyValue> getAvailableResponses() {
        return this.availableResponses;
    }

    public void setAvailableResponses(List<KeyValue> availableResponses) {
        this.availableResponses = availableResponses;
    }

    @BeanTagAttribute
    public String getDialogCssClass() {
        return this.dialogCssClass;
    }

    public void setDialogCssClass(String dialogCssClass) {
        this.dialogCssClass = dialogCssClass;
    }

    @BeanTagAttribute
    public String getOnDialogResponseScript() {
        return this.onDialogResponseScript;
    }

    public void setOnDialogResponseScript(String onDialogResponseScript) {
        this.onDialogResponseScript = onDialogResponseScript;
    }

    @BeanTagAttribute
    public String getOnShowDialogScript() {
        return this.onShowDialogScript;
    }

    public void setOnShowDialogScript(String onShowDialogScript) {
        this.onShowDialogScript = onShowDialogScript;
    }

    public String getOnHideDialogScript() {
        return this.onHideDialogScript;
    }

    public void setOnHideDialogScript(String onHideDialogScript) {
        this.onHideDialogScript = onHideDialogScript;
    }

    public String getOnHiddenDialogScript() {
        return this.onHiddenDialogScript;
    }

    public void setOnHiddenDialogScript(String onHiddenDialogScript) {
        this.onHiddenDialogScript = onHiddenDialogScript;
    }

    public boolean isDestroyDialogOnHidden() {
        return this.destroyDialogOnHidden;
    }

    public void setDestroyDialogOnHidden(boolean destroyDialogOnHidden) {
        this.destroyDialogOnHidden = destroyDialogOnHidden;
    }
}

