/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;
import org.apache.ojb.broker.util.logging.StringBufferLoggerImpl;

public class LoggerFactoryImpl {
    public static final String BOOT_LOG_LEVEL_STR = "OJB.bootLogLevel";
    protected static final String BOOT_STR = "BOOT";
    protected static final String DEFAULT_STR = "DEFAULT";
    protected static final LoggerFactoryImpl INSTANCE = new LoggerFactoryImpl();
    private Logger defaultLogger = null;
    private Logger bootLogger = null;
    private boolean bootLoggerIsReassigned = false;
    private Map cache = new HashMap();
    private LoggingConfiguration conf;

    private LoggerFactoryImpl() {
    }

    public static LoggerFactoryImpl getInstance() {
        return INSTANCE;
    }

    private LoggingConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = new LoggingConfiguration();
        }
        return this.conf;
    }

    public Logger getBootLogger() {
        if (this.bootLogger == null) {
            this.bootLogger = this.createStringBufferLogger_Boot();
        }
        return this.bootLogger;
    }

    public Logger getDefaultLogger() {
        if (this.defaultLogger == null) {
            this.defaultLogger = this.getLogger(DEFAULT_STR);
        }
        return this.defaultLogger;
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String string) {
        Logger logger = (Logger)this.cache.get(string);
        if (logger == null) {
            try {
                logger = this.createLoggerInstance(string);
                if (this.getBootLogger().isDebugEnabled()) {
                    this.getBootLogger().debug("Using logger class '" + (this.getConfiguration() != null ? this.getConfiguration().getLoggerClass() : null) + "' for " + string);
                }
                this.getBootLogger().debug("Initializing logger instance " + string);
                logger.configure(this.conf);
            }
            catch (Throwable throwable) {
                this.reassignBootLogger(true);
                logger = this.getBootLogger();
                this.getBootLogger().error("[" + this.getClass().getName() + "] Could not initialize logger " + (this.conf != null ? this.conf.getLoggerClass() : null), throwable);
            }
            this.cache.put(string, logger);
            this.reassignBootLogger(false);
        }
        return logger;
    }

    private Logger createLoggerInstance(String string) throws Exception {
        Class clazz = this.getConfiguration().getLoggerClass();
        Logger logger = (Logger)ClassHelper.newInstance(clazz, String.class, (Object)string);
        logger.configure(this.getConfiguration());
        return logger;
    }

    protected synchronized void reassignBootLogger(boolean bl) {
        if (!this.bootLoggerIsReassigned) {
            Logger logger = null;
            String string = this.getBootLogger().getName();
            try {
                logger = this.createLoggerInstance(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logger == null) {
                logger = this.createPoorMansLogger_Boot();
            }
            if (this.getBootLogger() instanceof StringBufferLoggerImpl) {
                StringBufferLoggerImpl stringBufferLoggerImpl = (StringBufferLoggerImpl)this.getBootLogger();
                String string2 = stringBufferLoggerImpl.flushLogBuffer();
                String string3 = SystemUtils.LINE_SEPARATOR;
                if (bl || stringBufferLoggerImpl.isErrorLog()) {
                    logger.error("-- boot log messages -->" + string3 + string2);
                } else {
                    logger.info("-- boot log messages -->" + string3 + string2);
                }
            }
            this.bootLogger = logger;
            this.bootLoggerIsReassigned = true;
        }
    }

    protected Logger createPoorMansLogger_Boot() {
        PoorMansLoggerImpl poorMansLoggerImpl = new PoorMansLoggerImpl(BOOT_STR);
        String string = System.getProperty(BOOT_LOG_LEVEL_STR, "INFO");
        poorMansLoggerImpl.setLevel(string);
        return poorMansLoggerImpl;
    }

    protected Logger createStringBufferLogger_Boot() {
        StringBufferLoggerImpl stringBufferLoggerImpl = new StringBufferLoggerImpl(BOOT_STR);
        String string = System.getProperty(BOOT_LOG_LEVEL_STR, "INFO");
        ((PoorMansLoggerImpl)stringBufferLoggerImpl).setLevel(string);
        return stringBufferLoggerImpl;
    }
}

