/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.UnknownIsolationException;
import org.apache.ojb.otm.lock.isolation.ReadCommittedIsolation;
import org.apache.ojb.otm.lock.isolation.ReadUncommittedIsolation;
import org.apache.ojb.otm.lock.isolation.RepeatableReadIsolation;
import org.apache.ojb.otm.lock.isolation.SerializableIsolation;
import org.apache.ojb.otm.lock.isolation.TransactionIsolation;

public class IsolationFactory {
    private static final TransactionIsolation READ_UNCOMMITTED_ISOLATION = new ReadUncommittedIsolation();
    private static final TransactionIsolation READ_COMMITTED_ISOLATION = new ReadCommittedIsolation();
    private static final TransactionIsolation REPEATABLE_READ_ISOLATION = new RepeatableReadIsolation();
    private static final TransactionIsolation SERIALIZABLE_ISOLATION = new SerializableIsolation();

    public static TransactionIsolation getIsolationLevel(PersistenceBroker persistenceBroker, ObjectLock objectLock) {
        Class clazz = objectLock.getTargetIdentity().getObjectsRealClass();
        ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(clazz);
        int n = classDescriptor.getIsolationLevel();
        TransactionIsolation transactionIsolation = null;
        switch (n) {
            case 2: {
                transactionIsolation = READ_UNCOMMITTED_ISOLATION;
                break;
            }
            case 3: {
                transactionIsolation = READ_COMMITTED_ISOLATION;
                break;
            }
            case 5: {
                transactionIsolation = REPEATABLE_READ_ISOLATION;
                break;
            }
            case 7: {
                transactionIsolation = SERIALIZABLE_ISOLATION;
                break;
            }
            default: {
                throw new UnknownIsolationException("Isolation level " + n + " is not supported");
            }
        }
        return transactionIsolation;
    }
}

