/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.MetadataEncoder;
import org.springframework.messaging.rsocket.PayloadUtils;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class DefaultRSocketRequester
implements RSocketRequester {
    private static final Map<String, Object> EMPTY_HINTS = Collections.emptyMap();
    private final RSocket rsocket;
    private final MimeType dataMimeType;
    private final MimeType metadataMimeType;
    private final RSocketStrategies strategies;
    private final DataBuffer emptyDataBuffer;

    DefaultRSocketRequester(RSocket rsocket, MimeType dataMimeType, MimeType metadataMimeType, RSocketStrategies strategies) {
        Assert.notNull((Object)rsocket, (String)"RSocket is required");
        Assert.notNull((Object)dataMimeType, (String)"'dataMimeType' is required");
        Assert.notNull((Object)metadataMimeType, (String)"'metadataMimeType' is required");
        Assert.notNull((Object)strategies, (String)"RSocketStrategies is required");
        this.rsocket = rsocket;
        this.dataMimeType = dataMimeType;
        this.metadataMimeType = metadataMimeType;
        this.strategies = strategies;
        this.emptyDataBuffer = this.strategies.dataBufferFactory().wrap(new byte[0]);
    }

    @Override
    public RSocket rsocket() {
        return this.rsocket;
    }

    @Override
    public MimeType dataMimeType() {
        return this.dataMimeType;
    }

    @Override
    public MimeType metadataMimeType() {
        return this.metadataMimeType;
    }

    @Override
    public RSocketRequester.RequestSpec route(String route, Object ... vars) {
        return new DefaultRequestSpec(route, vars);
    }

    @Override
    public RSocketRequester.RequestSpec metadata(Object metadata, @Nullable MimeType mimeType) {
        return new DefaultRequestSpec(metadata, mimeType);
    }

    private static boolean isVoid(ResolvableType elementType) {
        return Void.class.equals((Object)elementType.resolve()) || Void.TYPE.equals(elementType.resolve());
    }

    private DataBufferFactory bufferFactory() {
        return this.strategies.dataBufferFactory();
    }

    private class DefaultRequestSpec
    implements RSocketRequester.RequestSpec {
        private final MetadataEncoder metadataEncoder;
        @Nullable
        private Mono<Payload> payloadMono = this.emptyPayload();
        @Nullable
        private Flux<Payload> payloadFlux = null;

        public DefaultRequestSpec(String route, Object ... vars) {
            this.metadataEncoder = new MetadataEncoder(DefaultRSocketRequester.this.metadataMimeType(), DefaultRSocketRequester.this.strategies);
            this.metadataEncoder.route(route, vars);
        }

        public DefaultRequestSpec(@Nullable Object metadata, MimeType mimeType) {
            this.metadataEncoder = new MetadataEncoder(DefaultRSocketRequester.this.metadataMimeType(), DefaultRSocketRequester.this.strategies);
            this.metadataEncoder.metadata(metadata, mimeType);
        }

        @Override
        public RSocketRequester.RequestSpec metadata(Object metadata, MimeType mimeType) {
            this.metadataEncoder.metadata(metadata, mimeType);
            return this;
        }

        @Override
        public RSocketRequester.RequestSpec metadata(Consumer<RSocketRequester.MetadataSpec<?>> configurer) {
            configurer.accept(this);
            return this;
        }

        @Override
        public RSocketRequester.RequestSpec data(Object data) {
            Assert.notNull((Object)data, (String)"'data' must not be null");
            this.createPayload(data, ResolvableType.NONE);
            return this;
        }

        @Override
        public RSocketRequester.RequestSpec data(Object producer, Class<?> elementClass) {
            Assert.notNull((Object)producer, (String)"'producer' must not be null");
            Assert.notNull(elementClass, (String)"'elementClass' must not be null");
            ReactiveAdapter adapter = this.getAdapter(producer.getClass());
            Assert.notNull((Object)adapter, (String)"'producer' type is unknown to ReactiveAdapterRegistry");
            this.createPayload(adapter.toPublisher(producer), ResolvableType.forClass(elementClass));
            return this;
        }

        @Nullable
        private ReactiveAdapter getAdapter(Class<?> aClass) {
            return DefaultRSocketRequester.this.strategies.reactiveAdapterRegistry().getAdapter(aClass);
        }

        @Override
        public RSocketRequester.RequestSpec data(Object producer, ParameterizedTypeReference<?> elementTypeRef) {
            Assert.notNull((Object)producer, (String)"'producer' must not be null");
            Assert.notNull(elementTypeRef, (String)"'elementTypeRef' must not be null");
            ReactiveAdapter adapter = this.getAdapter(producer.getClass());
            Assert.notNull((Object)adapter, (String)"'producer' type is unknown to ReactiveAdapterRegistry");
            this.createPayload(adapter.toPublisher(producer), ResolvableType.forType(elementTypeRef));
            return this;
        }

        private void createPayload(Object input, ResolvableType elementType) {
            Encoder encoder;
            Publisher publisher;
            ReactiveAdapter adapter = this.getAdapter(input.getClass());
            if (input instanceof Publisher) {
                publisher = (Publisher)input;
            } else if (adapter != null) {
                publisher = adapter.toPublisher(input);
            } else {
                this.payloadMono = Mono.fromCallable(() -> this.encodeData(input, ResolvableType.forInstance((Object)input), null)).map(this::firstPayload).doOnDiscard(Payload.class, ReferenceCounted::release).switchIfEmpty(this.emptyPayload());
                this.payloadFlux = null;
                return;
            }
            if (DefaultRSocketRequester.isVoid(elementType) || adapter != null && adapter.isNoValue()) {
                this.payloadMono = Mono.when((Publisher[])new Publisher[]{publisher}).then(this.emptyPayload());
                this.payloadFlux = null;
                return;
            }
            Encoder encoder2 = encoder = elementType != ResolvableType.NONE && !Object.class.equals((Object)elementType.resolve()) ? DefaultRSocketRequester.this.strategies.encoder(elementType, DefaultRSocketRequester.this.dataMimeType) : null;
            if (adapter != null && !adapter.isMultiValue()) {
                this.payloadMono = Mono.from((Publisher)publisher).map(value -> this.encodeData(value, elementType, encoder)).map(this::firstPayload).switchIfEmpty(this.emptyPayload());
                this.payloadFlux = null;
                return;
            }
            this.payloadMono = null;
            this.payloadFlux = Flux.from((Publisher)publisher).map(value -> this.encodeData(value, elementType, encoder)).switchOnFirst((signal, inner) -> {
                DataBuffer data = (DataBuffer)signal.get();
                if (data != null) {
                    return Mono.fromCallable(() -> this.firstPayload(data)).concatWith((Publisher)inner.skip(1L).map(PayloadUtils::createPayload));
                }
                return inner.map(PayloadUtils::createPayload);
            }).doOnDiscard(Payload.class, ReferenceCounted::release).switchIfEmpty(this.emptyPayload());
        }

        private <T> DataBuffer encodeData(T value, ResolvableType elementType, @Nullable Encoder<?> encoder) {
            if (encoder == null) {
                elementType = ResolvableType.forInstance(value);
                encoder = DefaultRSocketRequester.this.strategies.encoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            }
            return encoder.encodeValue(value, DefaultRSocketRequester.this.bufferFactory(), elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS);
        }

        private Payload firstPayload(DataBuffer data) {
            DataBuffer metadata;
            try {
                metadata = this.metadataEncoder.encode();
            }
            catch (Throwable ex) {
                DataBufferUtils.release((DataBuffer)data);
                throw ex;
            }
            return PayloadUtils.createPayload(data, metadata);
        }

        private Mono<Payload> emptyPayload() {
            return Mono.fromCallable(() -> this.firstPayload(DefaultRSocketRequester.this.emptyDataBuffer));
        }

        @Override
        public Mono<Void> send() {
            Assert.state((this.payloadMono != null ? 1 : 0) != 0, (String)"No RSocket interaction model for one-way send with Flux");
            return this.payloadMono.flatMap(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).fireAndForget(arg_0));
        }

        @Override
        public <T> Mono<T> retrieveMono(Class<T> dataType) {
            return this.retrieveMono(ResolvableType.forClass(dataType));
        }

        @Override
        public <T> Mono<T> retrieveMono(ParameterizedTypeReference<T> dataTypeRef) {
            return this.retrieveMono(ResolvableType.forType(dataTypeRef));
        }

        @Override
        public <T> Flux<T> retrieveFlux(Class<T> dataType) {
            return this.retrieveFlux(ResolvableType.forClass(dataType));
        }

        @Override
        public <T> Flux<T> retrieveFlux(ParameterizedTypeReference<T> dataTypeRef) {
            return this.retrieveFlux(ResolvableType.forType(dataTypeRef));
        }

        private <T> Mono<T> retrieveMono(ResolvableType elementType) {
            Assert.notNull(this.payloadMono, (String)"No RSocket interaction model for Flux request to Mono response.");
            Mono payloadMono = this.payloadMono.flatMap(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).requestResponse(arg_0));
            if (DefaultRSocketRequester.isVoid(elementType)) {
                return payloadMono.then();
            }
            Decoder decoder = DefaultRSocketRequester.this.strategies.decoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            return payloadMono.map(this::retainDataAndReleasePayload).map(dataBuffer -> decoder.decode(dataBuffer, elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS));
        }

        private <T> Flux<T> retrieveFlux(ResolvableType elementType) {
            Flux payloadFlux;
            Flux flux = this.payloadMono != null ? this.payloadMono.flatMapMany(arg_0 -> ((RSocket)DefaultRSocketRequester.this.rsocket).requestStream(arg_0)) : (payloadFlux = DefaultRSocketRequester.this.rsocket.requestChannel(this.payloadFlux));
            if (DefaultRSocketRequester.isVoid(elementType)) {
                return payloadFlux.thenMany((Publisher)Flux.empty());
            }
            Decoder decoder = DefaultRSocketRequester.this.strategies.decoder(elementType, DefaultRSocketRequester.this.dataMimeType);
            return payloadFlux.map(this::retainDataAndReleasePayload).map(dataBuffer -> decoder.decode(dataBuffer, elementType, DefaultRSocketRequester.this.dataMimeType, EMPTY_HINTS));
        }

        private DataBuffer retainDataAndReleasePayload(Payload payload) {
            return PayloadUtils.retainDataAndReleasePayload(payload, DefaultRSocketRequester.this.bufferFactory());
        }
    }
}

