/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.action.AdHocToGroup;
import org.kuali.rice.kew.api.action.AdHocToGroup_v2_1_2;
import org.kuali.rice.kew.api.action.AdHocToPrincipal;
import org.kuali.rice.kew.api.action.AdHocToPrincipal_v2_1_2;
import org.kuali.rice.kew.api.action.DocumentActionParameters;
import org.kuali.rice.kew.api.action.DocumentActionResult;
import org.kuali.rice.kew.api.action.MovePoint;
import org.kuali.rice.kew.api.action.RequestedActions;
import org.kuali.rice.kew.api.action.ReturnPoint;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.ValidActions;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.doctype.IllegalDocumentTypeException;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.definition.AttributeDefinition;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.simulation.SimulationCriteria;
import org.kuali.rice.kew.engine.simulation.SimulationResults;
import org.kuali.rice.kew.engine.simulation.SimulationWorkflowEngine;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.WorkflowAttributeXmlValidator;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class WorkflowDocumentActionsServiceImpl
implements WorkflowDocumentActionsService {
    private static final Logger LOG = LogManager.getLogger(WorkflowDocumentActionsServiceImpl.class);
    private DocumentTypeService documentTypeService;
    private static final DocumentActionCallback ACKNOWLEDGE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().acknowledgeDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.ACKNOWLEDGE.getLabel();
        }
    };
    private static final DocumentActionCallback APPROVE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().approveDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.APPROVE.getLabel();
        }
    };
    private static final DocumentActionCallback CANCEL_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().cancelDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.CANCEL.getLabel();
        }
    };
    private static final DocumentActionCallback FYI_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().clearFYIDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.FYI.getLabel();
        }
    };
    private static final DocumentActionCallback COMPLETE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().completeDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.COMPLETE.getLabel();
        }
    };
    private static final DocumentActionCallback DISAPPROVE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().disapproveDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.DISAPPROVE.getLabel();
        }
    };
    private static final DocumentActionCallback ROUTE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().routeDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.ROUTE.getLabel();
        }
    };
    private static final DocumentActionCallback BLANKET_APPROVE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().blanketApproval(principalId, documentBo, annotation, new HashSet());
        }

        @Override
        public String getActionName() {
            return ActionType.BLANKET_APPROVE.getLabel();
        }
    };
    private static final DocumentActionCallback SAVE_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().saveDocument(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return ActionType.SAVE.getLabel();
        }
    };
    private static final DocumentActionCallback PLACE_IN_EXCEPTION_CALLBACK = new StandardDocumentActionCallback(){

        @Override
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
            return KEWServiceLocator.getWorkflowDocumentService().placeInExceptionRouting(principalId, documentBo, annotation);
        }

        @Override
        public String getActionName() {
            return "Place In Exception";
        }
    };

    protected DocumentRouteHeaderValue init(DocumentActionParameters parameters) {
        String documentId = parameters.getDocumentId();
        String principalId = parameters.getPrincipalId();
        DocumentUpdate documentUpdate = parameters.getDocumentUpdate();
        DocumentContentUpdate documentContentUpdate = parameters.getDocumentContentUpdate();
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing Document from incoming documentId: " + documentId);
        }
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        if (document == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document for document id: " + documentId);
        }
        boolean modified = false;
        if (documentUpdate != null) {
            document.applyDocumentUpdate(documentUpdate);
            modified = true;
        }
        if (documentContentUpdate != null) {
            String newDocumentContent = DTOConverter.buildUpdatedDocumentContent(document.getDocContent(), documentContentUpdate, document.getDocumentTypeName());
            document.setDocContent(newDocumentContent);
            modified = true;
        }
        if (modified) {
            document = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(document);
            this.saveRouteNodeInstances(document);
        }
        return document;
    }

    private void saveRouteNodeInstances(DocumentRouteHeaderValue routeHeader) {
        List<RouteNodeInstance> routeNodes = routeHeader.getInitialRouteNodeInstances();
        ArrayList<RouteNodeInstance> persistedRouteNodes = new ArrayList<RouteNodeInstance>();
        RouteNodeInstance persistedRni = null;
        if (routeNodes != null && !routeNodes.isEmpty()) {
            for (RouteNodeInstance rni : routeNodes) {
                persistedRni = KEWServiceLocator.getRouteNodeService().save(rni);
                persistedRouteNodes.add(persistedRni);
            }
        }
        routeHeader.setInitialRouteNodeInstances(persistedRouteNodes);
    }

    public Document create(String documentTypeName, String initiatorPrincipalId, DocumentUpdate documentUpdate, DocumentContentUpdate documentContentUpdate) throws RiceIllegalArgumentException, IllegalDocumentTypeException, org.kuali.rice.kew.api.action.InvalidActionTakenException {
        String documentTypeId;
        this.incomingParamCheck(documentTypeName, "documentTypeName");
        this.incomingParamCheck(initiatorPrincipalId, "initiatorPrincipalId");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create Document [documentTypeName=" + documentTypeName + ", initiatorPrincipalId=" + initiatorPrincipalId + "]");
        }
        if ((documentTypeId = this.documentTypeService.getIdByName(documentTypeName)) == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document type with the given name: " + documentTypeName);
        }
        DocumentRouteHeaderValue documentBo = new DocumentRouteHeaderValue();
        documentBo.setDocumentTypeId(documentTypeId);
        documentBo.setInitiatorWorkflowId(initiatorPrincipalId);
        if (documentUpdate != null) {
            documentBo.setDocTitle(documentUpdate.getTitle());
            documentBo.setAppDocId(documentUpdate.getApplicationDocumentId());
        }
        if (documentContentUpdate != null) {
            String newDocumentContent = DTOConverter.buildUpdatedDocumentContent(null, documentContentUpdate, documentTypeName);
            documentBo.setDocContent(newDocumentContent);
        }
        try {
            documentBo = KEWServiceLocator.getWorkflowDocumentService().createDocument(initiatorPrincipalId, documentBo);
        }
        catch (WorkflowException e) {
            this.translateException(e);
        }
        return DocumentRouteHeaderValue.to(documentBo);
    }

    public ValidActions determineValidActions(String documentId, String principalId) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        if (documentBo == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document for document id: " + documentId);
        }
        return this.determineValidActionsInternal(documentBo, principalId);
    }

    protected ValidActions determineValidActionsInternal(DocumentRouteHeaderValue documentBo, String principalId) {
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        return KEWServiceLocator.getActionRegistry().getValidActions((PrincipalContract)principal, documentBo);
    }

    public boolean isValidAction(String actionTypeCode, String documentId, String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(actionTypeCode, "actionTypeCode");
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        if (documentBo == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document for document id: " + documentId);
        }
        return this.determineValidActionInternal(actionTypeCode, documentBo, principalId);
    }

    protected boolean determineValidActionInternal(String actionTypeCode, DocumentRouteHeaderValue documentBo, String principalId) {
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        return KEWServiceLocator.getActionRegistry().isValidAction(actionTypeCode, (PrincipalContract)principal, documentBo);
    }

    public RequestedActions determineRequestedActions(String documentId, String principalId) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        if (documentBo == null) {
            throw new RiceIllegalArgumentException("Failed to locate a document for document id: " + documentId);
        }
        KEWServiceLocator.getIdentityHelperService().validatePrincipalId(principalId);
        return this.determineRequestedActionsInternal(documentBo, principalId);
    }

    protected RequestedActions determineRequestedActionsInternal(DocumentRouteHeaderValue documentBo, String principalId) {
        Map<String, String> actionsRequested = KEWServiceLocator.getActionRequestService().getActionsRequested(documentBo, principalId, true);
        boolean completeRequested = false;
        boolean approveRequested = false;
        boolean acknowledgeRequested = false;
        boolean fyiRequested = false;
        for (String actionRequestCode : actionsRequested.keySet()) {
            if (ActionRequestType.FYI.getCode().equals(actionRequestCode)) {
                fyiRequested = Boolean.parseBoolean(actionsRequested.get(actionRequestCode));
                continue;
            }
            if (ActionRequestType.ACKNOWLEDGE.getCode().equals(actionRequestCode)) {
                acknowledgeRequested = Boolean.parseBoolean(actionsRequested.get(actionRequestCode));
                continue;
            }
            if (ActionRequestType.APPROVE.getCode().equals(actionRequestCode)) {
                approveRequested = Boolean.parseBoolean(actionsRequested.get(actionRequestCode));
                continue;
            }
            if (!ActionRequestType.COMPLETE.getCode().equals(actionRequestCode)) continue;
            completeRequested = Boolean.parseBoolean(actionsRequested.get(actionRequestCode));
        }
        return RequestedActions.create((boolean)completeRequested, (boolean)approveRequested, (boolean)acknowledgeRequested, (boolean)fyiRequested);
    }

    public DocumentDetail executeSimulation(RoutingReportCriteria reportCriteria) {
        this.incomingParamCheck(reportCriteria, "reportCriteria");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing routing report [docId=" + reportCriteria.getDocumentId() + ", docTypeName=" + reportCriteria.getDocumentTypeName() + "]");
        }
        SimulationCriteria criteria = SimulationCriteria.from(reportCriteria);
        return DTOConverter.convertDocumentDetailNew(KEWServiceLocator.getRoutingReportService().report(criteria));
    }

    protected DocumentActionResult constructDocumentActionResult(DocumentRouteHeaderValue documentBo, String principalId) {
        Document document = DocumentRouteHeaderValue.to(documentBo);
        ValidActions validActions = this.determineValidActionsInternal(documentBo, principalId);
        RequestedActions requestedActions = this.determineRequestedActionsInternal(documentBo, principalId);
        return DocumentActionResult.create((Document)document, (ValidActions)validActions, (RequestedActions)requestedActions);
    }

    public DocumentActionResult acknowledge(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, ACKNOWLEDGE_CALLBACK);
    }

    public DocumentActionResult approve(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, APPROVE_CALLBACK);
    }

    public DocumentActionResult adHocToPrincipal(DocumentActionParameters parameters, final AdHocToPrincipal adHocToPrincipal) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(adHocToPrincipal, "adHocToPrincipal");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "AdHoc Route To Principal [principalId=" + principalId + ", docId=" + documentId + ", actionRequest=" + adHocToPrincipal.getActionRequested() + ", nodeName=" + adHocToPrincipal.getNodeName() + ", targetPrincipalId=" + adHocToPrincipal.getTargetPrincipalId() + ", forceAction=" + adHocToPrincipal.isForceAction() + ", annotation=" + annotation + ", requestLabel=" + adHocToPrincipal.getRequestLabel() + "]";
            }

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().adHocRouteDocumentToPrincipal(principalId, documentBo, adHocToPrincipal.getActionRequested().getCode(), adHocToPrincipal.getNodeName(), adHocToPrincipal.getPriority(), annotation, adHocToPrincipal.getTargetPrincipalId(), adHocToPrincipal.getResponsibilityDescription(), adHocToPrincipal.isForceAction(), adHocToPrincipal.getRequestLabel());
            }
        });
    }

    public DocumentActionResult adHocToPrincipal(DocumentActionParameters parameters, AdHocToPrincipal_v2_1_2 adHocToPrincipal) {
        return this.adHocToPrincipal(parameters, AdHocToPrincipal_v2_1_2.to((AdHocToPrincipal_v2_1_2)adHocToPrincipal));
    }

    public DocumentActionResult adHocToGroup(DocumentActionParameters parameters, final AdHocToGroup adHocToGroup) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(adHocToGroup, "adHocToGroup");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "AdHoc Route To Group [principalId=" + principalId + ", docId=" + documentId + ", actionRequest=" + adHocToGroup.getActionRequested() + ", nodeName=" + adHocToGroup.getNodeName() + ", targetGroupId=" + adHocToGroup.getTargetGroupId() + ", forceAction=" + adHocToGroup.isForceAction() + ", annotation=" + annotation + ", requestLabel=" + adHocToGroup.getRequestLabel() + "]";
            }

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().adHocRouteDocumentToGroup(principalId, documentBo, adHocToGroup.getActionRequested().getCode(), adHocToGroup.getNodeName(), adHocToGroup.getPriority(), annotation, adHocToGroup.getTargetGroupId(), adHocToGroup.getResponsibilityDescription(), adHocToGroup.isForceAction(), adHocToGroup.getRequestLabel());
            }
        });
    }

    public DocumentActionResult adHocToGroup(DocumentActionParameters parameters, AdHocToGroup_v2_1_2 adHocToGroup) {
        return this.adHocToGroup(parameters, AdHocToGroup_v2_1_2.to((AdHocToGroup_v2_1_2)adHocToGroup));
    }

    public DocumentActionResult revokeAdHocRequestById(DocumentActionParameters parameters, final String actionRequestId) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(actionRequestId, "actionRequestId");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Revoke AdHoc from Principal [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + ", actionRequestId=" + actionRequestId + "]";
            }

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().revokeAdHocRequests(principalId, documentBo, actionRequestId, annotation);
            }
        });
    }

    public DocumentActionResult revokeAdHocRequests(DocumentActionParameters parameters, final AdHocRevoke revoke) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(revoke, "revoke");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Revoke AdHoc Requests [principalId=" + principalId + ", docId=" + documentId + ", annotation=" + annotation + ", revoke=" + revoke.toString() + "]";
            }

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().revokeAdHocRequests(principalId, documentBo, revoke, annotation);
            }
        });
    }

    public DocumentActionResult revokeAllAdHocRequests(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Revoke All AdHoc Requests [principalId=" + principalId + ", docId=" + documentId + ", annotation=" + annotation + "]";
            }

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().revokeAdHocRequests(principalId, documentBo, (AdHocRevoke)null, annotation);
            }
        });
    }

    public DocumentActionResult cancel(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, CANCEL_CALLBACK);
    }

    public DocumentActionResult recall(DocumentActionParameters parameters, final boolean cancel) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(cancel, "cancel");
        return this.executeActionInternal(parameters, new StandardDocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().recallDocument(principalId, documentBo, annotation, cancel);
            }

            @Override
            public String getActionName() {
                return ActionType.RECALL.getLabel();
            }
        });
    }

    public DocumentActionResult clearFyi(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, FYI_CALLBACK);
    }

    public DocumentActionResult complete(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, COMPLETE_CALLBACK);
    }

    public DocumentActionResult disapprove(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, DISAPPROVE_CALLBACK);
    }

    public DocumentActionResult route(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, ROUTE_CALLBACK);
    }

    public DocumentActionResult blanketApprove(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, BLANKET_APPROVE_CALLBACK);
    }

    public DocumentActionResult blanketApproveToNodes(DocumentActionParameters parameters, final Set<String> nodeNames) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(nodeNames, "nodeNames");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().blanketApproval(principalId, documentBo, annotation, nodeNames);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Blanket Approve [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + ", nodeNames=" + nodeNames + "]";
            }
        });
    }

    public DocumentActionResult returnToPreviousNode(DocumentActionParameters parameters, final ReturnPoint returnPoint) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(returnPoint, "returnPoint");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().returnDocumentToPreviousNode(principalId, documentBo, returnPoint.getNodeName(), annotation);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Return to Previous [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + ", destNodeName=" + returnPoint.getNodeName() + "]";
            }
        });
    }

    public DocumentActionResult move(DocumentActionParameters parameters, final MovePoint movePoint) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(movePoint, "movePoint");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().moveDocument(principalId, documentBo, movePoint, annotation);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Move Document [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + ", movePoint=" + movePoint + "]";
            }
        });
    }

    public DocumentActionResult takeGroupAuthority(DocumentActionParameters parameters, final String groupId) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(groupId, "groupId");
        return this.executeActionInternal(parameters, new StandardDocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().takeGroupAuthority(principalId, documentBo, groupId, annotation);
            }

            @Override
            public String getActionName() {
                return ActionType.TAKE_GROUP_AUTHORITY.getLabel();
            }
        });
    }

    public DocumentActionResult releaseGroupAuthority(DocumentActionParameters parameters, final String groupId) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(groupId, "groupId");
        return this.executeActionInternal(parameters, new StandardDocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().releaseGroupAuthority(principalId, documentBo, groupId, annotation);
            }

            @Override
            public String getActionName() {
                return ActionType.RELEASE_GROUP_AUTHORITY.getLabel();
            }
        });
    }

    public DocumentActionResult save(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, SAVE_CALLBACK);
    }

    public DocumentActionResult saveDocumentData(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "Saving Routing Data [principalId=" + principalId + ", docId=" + documentId + "]";
            }

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().saveRoutingData(principalId, documentBo);
            }
        });
    }

    public Document delete(String documentId, String principalId) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        DocumentRouteHeaderValue documentBo = this.init(DocumentActionParameters.create((String)documentId, (String)principalId, null));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delete [principalId=" + principalId + ", documentId=" + documentId + "]");
        }
        Document document = null;
        try {
            document = DocumentRouteHeaderValue.to(documentBo);
            KEWServiceLocator.getWorkflowDocumentService().deleteDocument(principalId, documentBo);
        }
        catch (WorkflowException e) {
            this.translateException(e);
        }
        return document;
    }

    public void logAnnotation(String documentId, String principalId, String annotation) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(annotation, "annotation");
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        try {
            KEWServiceLocator.getWorkflowDocumentService().logDocumentAction(principalId, documentBo, annotation);
        }
        catch (WorkflowException e) {
            this.translateException(e);
        }
    }

    public void initiateIndexing(String documentId) {
        this.incomingParamCheck(documentId, "documentId");
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        if (documentBo.getDocumentType().hasSearchableAttributes()) {
            DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)documentBo.getDocumentType().getApplicationId());
            queue.indexDocument(documentId);
        }
    }

    public DocumentActionResult superUserBlanketApprove(DocumentActionParameters parameters, final boolean executePostProcessor) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().superUserApprove(principalId, documentBo, annotation, executePostProcessor);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "SU Blanket Approve [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + "]";
            }
        });
    }

    public DocumentActionResult superUserNodeApprove(DocumentActionParameters parameters, final boolean executePostProcessor, final String nodeName) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(nodeName, "nodeName");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().superUserNodeApproveAction(principalId, documentBo, nodeName, annotation, executePostProcessor);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "SU Node Approve Action [principalId=" + principalId + ", documentId=" + documentId + ", nodeName=" + nodeName + ", annotation=" + annotation + "]";
            }
        });
    }

    public DocumentActionResult superUserTakeRequestedAction(DocumentActionParameters parameters, final boolean executePostProcessor, final String actionRequestId) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(actionRequestId, "actionRequestId");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().superUserActionRequestApproveAction(principalId, documentBo, actionRequestId, annotation, executePostProcessor);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "SU Take Requested Action [principalId=" + principalId + ", docume tId=" + documentId + ", actionRequestId=" + actionRequestId + ", annotation=" + annotation + "]";
            }
        });
    }

    public DocumentActionResult superUserDisapprove(DocumentActionParameters parameters, final boolean executePostProcessor) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().superUserDisapproveAction(principalId, documentBo, annotation, executePostProcessor);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "SU Disapprove [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + "]";
            }
        });
    }

    public DocumentActionResult superUserCancel(DocumentActionParameters parameters, final boolean executePostProcessor) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().superUserCancelAction(principalId, documentBo, annotation, executePostProcessor);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "SU Cancel [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + "]";
            }
        });
    }

    public DocumentActionResult superUserReturnToPreviousNode(DocumentActionParameters parameters, final boolean executePostProcessor, final ReturnPoint returnPoint) {
        this.incomingParamCheck(parameters, "parameters");
        this.incomingParamCheck(returnPoint, "returnPoint");
        return this.executeActionInternal(parameters, new DocumentActionCallback(){

            @Override
            public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue documentBo, String principalId, String annotation) throws WorkflowException {
                return KEWServiceLocator.getWorkflowDocumentService().superUserReturnDocumentToPreviousNode(principalId, documentBo, returnPoint.getNodeName(), annotation, executePostProcessor);
            }

            @Override
            public String getLogMessage(String documentId, String principalId, String annotation) {
                return "SU Return to Previous Node [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + ", returnPoint=" + returnPoint + "]";
            }
        });
    }

    public DocumentActionResult placeInExceptionRouting(DocumentActionParameters parameters) {
        this.incomingParamCheck(parameters, "parameters");
        return this.executeActionInternal(parameters, PLACE_IN_EXCEPTION_CALLBACK);
    }

    public boolean documentWillHaveAtLeastOneActionRequest(RoutingReportCriteria reportCriteria, List<String> actionRequestedCodes, boolean ignoreCurrentActionRequests) {
        this.incomingParamCheck(reportCriteria, "reportCriteria");
        this.incomingParamCheck(actionRequestedCodes, "actionRequestedCodes");
        try {
            SimulationWorkflowEngine simulationEngine = KEWServiceLocator.getSimulationEngine();
            SimulationCriteria criteria = SimulationCriteria.from(reportCriteria);
            criteria.setActivateRequests(Boolean.TRUE);
            SimulationResults results = simulationEngine.runSimulation(criteria);
            List<ActionRequestValue> actionRequestsToProcess = results.getSimulatedActionRequests();
            if (!ignoreCurrentActionRequests) {
                actionRequestsToProcess.addAll(results.getDocument().getActionRequests());
            }
            for (ActionRequestValue actionRequest : actionRequestsToProcess) {
                if (actionRequest.isDone()) continue;
                if (CollectionUtils.isEmpty(actionRequestedCodes)) {
                    return true;
                }
                for (String requestedActionRequestCode : actionRequestedCodes) {
                    boolean satisfiesDestinationUserCriteria;
                    if (!requestedActionRequestCode.equals(actionRequest.getActionRequested()) || !(satisfiesDestinationUserCriteria = criteria.getDestinationRecipients().isEmpty() || this.isRecipientRoutedRequest(actionRequest, criteria.getDestinationRecipients()))) continue;
                    if (StringUtils.isBlank((String)criteria.getDestinationNodeName())) {
                        return true;
                    }
                    if (!StringUtils.equals((String)criteria.getDestinationNodeName(), (String)actionRequest.getNodeInstance().getName())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            String error = "Problems evaluating documentWillHaveAtLeastOneActionRequest: " + ex.getMessage();
            LOG.error(error, (Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(error, ex);
        }
    }

    private boolean isRecipientRoutedRequest(ActionRequestValue actionRequest, List<Recipient> recipients) throws WorkflowException {
        for (Recipient recipient : recipients) {
            if (!actionRequest.isRecipientRoutedRequest(recipient)) continue;
            return true;
        }
        return false;
    }

    public void reResolveRoleByDocTypeName(String documentTypeName, String roleName, String qualifiedRoleNameLabel) {
        this.incomingParamCheck(documentTypeName, "documentTypeName");
        this.incomingParamCheck(roleName, "roleName");
        this.incomingParamCheck(qualifiedRoleNameLabel, "qualifiedRoleNameLabel");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Re-resolving Role [docTypeName=" + documentTypeName + ", roleName=" + roleName + ", qualifiedRoleNameLabel=" + qualifiedRoleNameLabel + "]");
        }
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        if (StringUtils.isEmpty((String)qualifiedRoleNameLabel)) {
            KEWServiceLocator.getRoleService().reResolveRole(documentType, roleName);
        } else {
            KEWServiceLocator.getRoleService().reResolveQualifiedRole(documentType, roleName, qualifiedRoleNameLabel);
        }
    }

    public void reResolveRoleByDocumentId(String documentId, String roleName, String qualifiedRoleNameLabel) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(roleName, "roleName");
        this.incomingParamCheck(qualifiedRoleNameLabel, "qualifiedRoleNameLabel");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Re-resolving Role [documentId=" + documentId + ", roleName=" + roleName + ", qualifiedRoleNameLabel=" + qualifiedRoleNameLabel + "]");
        }
        DocumentRouteHeaderValue routeHeader = this.loadDocument(documentId);
        if (StringUtils.isEmpty((String)qualifiedRoleNameLabel)) {
            KEWServiceLocator.getRoleService().reResolveRole(routeHeader, roleName);
        } else {
            KEWServiceLocator.getRoleService().reResolveQualifiedRole(routeHeader, roleName, qualifiedRoleNameLabel);
        }
    }

    public List<RemotableAttributeError> validateWorkflowAttributeDefinition(WorkflowAttributeDefinition definition) {
        List<? extends RemotableAttributeErrorContract> validationErrors;
        if (definition == null) {
            throw new RiceIllegalArgumentException("definition was null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating WorkflowAttributeDefinition [attributeName=" + definition.getAttributeName() + "]");
        }
        AttributeDefinition attributeDefinition = DTOConverter.convertWorkflowAttributeDefinition(definition);
        WorkflowRuleAttribute attribute = null;
        if (attributeDefinition != null) {
            attribute = (WorkflowRuleAttribute)GlobalResourceLoader.getObject((ObjectDefinition)attributeDefinition.getObjectDefinition());
        }
        if (attribute instanceof GenericXMLRuleAttribute) {
            HashMap<String, String> attributePropMap = new HashMap<String, String>();
            GenericXMLRuleAttribute xmlAttribute = (GenericXMLRuleAttribute)attribute;
            xmlAttribute.setExtensionDefinition(attributeDefinition.getExtensionDefinition());
            for (PropertyDefinition propertyDefinition : definition.getPropertyDefinitions()) {
                attributePropMap.put(propertyDefinition.getName(), propertyDefinition.getValue());
            }
            xmlAttribute.setParamMap(attributePropMap);
        }
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (attribute instanceof WorkflowAttributeXmlValidator && (validationErrors = ((WorkflowAttributeXmlValidator)((Object)attribute)).validateClientRoutingData()) != null) {
            for (RemotableAttributeErrorContract remotableAttributeErrorContract : validationErrors) {
                errors.add(RemotableAttributeError.Builder.create((RemotableAttributeErrorContract)remotableAttributeErrorContract).build());
            }
        }
        return errors;
    }

    public boolean isFinalApprover(String documentId, String principalId) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluating isFinalApprover [docId=" + documentId + ", principalId=" + principalId + "]");
        }
        DocumentRouteHeaderValue routeHeader = this.loadDocument(documentId);
        List<ActionRequestValue> requests = KEWServiceLocator.getActionRequestService().findPendingByDoc(documentId);
        List<RouteNode> finalApproverNodes = KEWServiceLocator.getRouteNodeService().findFinalApprovalRouteNodes(routeHeader.getDocumentType().getDocumentTypeId());
        if (finalApproverNodes.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not locate final approval nodes for document " + documentId);
            }
            return false;
        }
        HashSet<String> finalApproverNodeNames = new HashSet<String>();
        for (RouteNode node : finalApproverNodes) {
            finalApproverNodeNames.add(node.getRouteNodeName());
        }
        int approveRequest = 0;
        for (ActionRequestValue request : requests) {
            RouteNodeInstance nodeInstance = request.getNodeInstance();
            if (nodeInstance == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found an action request on the document with a null node instance, indicating EXCEPTION routing.");
                }
                return false;
            }
            if (!finalApproverNodeNames.contains(nodeInstance.getRouteNode().getRouteNodeName()) || !request.isApproveOrCompleteRequest()) continue;
            ++approveRequest;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found request is approver " + request.getActionRequestId());
            }
            if (request.isRecipientRoutedRequest(principalId)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action Request not for user " + principalId);
            }
            return false;
        }
        if (approveRequest == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Principal " + principalId + " is final approver for document " + documentId);
        }
        return true;
    }

    public boolean routeNodeHasApproverActionRequest(String documentTypeName, String docContent, String nodeName) {
        this.incomingParamCheck(documentTypeName, "documentTypeName");
        this.incomingParamCheck(docContent, "docContent");
        this.incomingParamCheck(nodeName, "nodeName");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluating routeNodeHasApproverActionRequest [docTypeName=" + documentTypeName + ", nodeName=" + nodeName + "]");
        }
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        RouteNode routeNode = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(documentType.getDocumentTypeId(), nodeName);
        return this.routeNodeHasApproverActionRequest(documentType, docContent, routeNode, new Integer(-2));
    }

    private boolean routeNodeHasApproverActionRequest(DocumentType documentType, String docContent, RouteNode node, Integer routeLevel) {
        this.incomingParamCheck(documentType, "documentType");
        this.incomingParamCheck(docContent, "docContent");
        this.incomingParamCheck(node, "node");
        this.incomingParamCheck(routeLevel, "routeLevel");
        RoutingReportCriteria.Builder builder = RoutingReportCriteria.Builder.createByDocumentTypeName((String)documentType.getName());
        builder.setNodeNames(Collections.singletonList(node.getName()));
        builder.setXmlContent(docContent);
        DocumentDetail docDetail = this.executeSimulation(builder.build());
        if (docDetail != null) {
            for (ActionRequest actionRequest : docDetail.getActionRequests()) {
                if (!actionRequest.isApprovalRequest()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLastApproverAtNode(String documentId, String principalId, String nodeName) {
        List<ActionRequestValue> requests;
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(nodeName, "nodeName");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluating isLastApproverAtNode [docId=" + documentId + ", principalId=" + principalId + ", nodeName=" + nodeName + "]");
        }
        this.loadDocument(documentId);
        Boolean activateFirst = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "Feature", "IS_LAST_APPROVER_ACTIVATE_FIRST_IND");
        if (activateFirst == null) {
            activateFirst = Boolean.FALSE;
        }
        if ((requests = KEWServiceLocator.getActionRequestService().findPendingByDocRequestCdNodeName(documentId, "A", nodeName)) == null || requests.isEmpty()) {
            return false;
        }
        ArrayList<Object> copiedRequests = new ArrayList<Object>();
        for (ActionRequestValue request : requests) {
            ActionRequestValue actionRequest = (ActionRequestValue)SerializationUtils.deepCopy((Serializable)request);
            for (ActionItem actionItem : actionRequest.getActionItems()) {
                actionRequest.getSimulatedActionItems().add((ActionItem)SerializationUtils.deepCopy((Serializable)actionItem));
            }
            copiedRequests.add(actionRequest);
        }
        ArrayList<void> savedRequests = new ArrayList<void>();
        ActivationContext activationContext = new ActivationContext(true);
        for (ActionRequestValue actionRequestValue : copiedRequests) {
            void var10_18;
            void var10_15;
            if (activateFirst.booleanValue() && !actionRequestValue.isActive()) {
                ActionRequestValue actionRequestValue2 = KEWServiceLocator.getActionRequestService().activateRequest(actionRequestValue, activationContext);
            }
            if (var10_15.isUserRequest() && var10_15.getPrincipalId().equals(principalId)) {
                ActionRequestValue actionRequestValue3 = KEWServiceLocator.getActionRequestService().deactivateRequest(null, (ActionRequestValue)var10_15, activationContext);
            } else if (var10_15.isGroupRequest() && KimApiServiceLocator.getGroupService().isMemberOfGroup(principalId, var10_15.getGroup().getId())) {
                ActionRequestValue actionRequestValue4 = KEWServiceLocator.getActionRequestService().deactivateRequest(null, (ActionRequestValue)var10_15, activationContext);
            }
            savedRequests.add(var10_18);
        }
        boolean allDeactivated = true;
        for (ActionRequestValue actionRequest : savedRequests) {
            allDeactivated = allDeactivated && actionRequest.isDeactivated();
        }
        return allDeactivated;
    }

    public boolean isUserInRouteLog(String documentId, String principalId, boolean lookFuture) {
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        return this.isUserInRouteLogWithOptionalFlattening(documentId, principalId, lookFuture, false);
    }

    public boolean isUserInRouteLogWithOptionalFlattening(String documentId, String principalId, boolean lookFuture, boolean flattenNodes) {
        List<ActionRequestValue> actionRequests;
        DocumentRouteHeaderValue routeHeader;
        this.incomingParamCheck(documentId, "documentId");
        this.incomingParamCheck(principalId, "principalId");
        boolean authorized = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluating isUserInRouteLog [docId=" + documentId + ", principalId=" + principalId + ", lookFuture=" + lookFuture + "]");
        }
        if ((routeHeader = this.loadDocument(documentId)) == null) {
            throw new IllegalArgumentException("Document for documentId: " + documentId + " does not exist");
        }
        Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        if (principal == null) {
            throw new IllegalArgumentException("Principal for principalId: " + principalId + " does not exist");
        }
        List<ActionTakenValue> actionsTaken = KEWServiceLocator.getActionTakenService().findByDocumentIdPrincipalId(documentId, principal.getPrincipalId());
        if (routeHeader.getInitiatorWorkflowId().equals(principal.getPrincipalId())) {
            return true;
        }
        if (!actionsTaken.isEmpty()) {
            LOG.debug("found action taken by user");
            authorized = true;
        }
        if (this.actionRequestListHasPrincipal(principal, actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(documentId))) {
            authorized = true;
        }
        if (!lookFuture || authorized) {
            return authorized;
        }
        SimulationWorkflowEngine simulationEngine = KEWServiceLocator.getSimulationEngine();
        SimulationCriteria criteria = SimulationCriteria.createSimulationCritUsingDocumentId(documentId);
        criteria.setDestinationNodeName(null);
        criteria.getDestinationRecipients().add(new KimPrincipalRecipient((PrincipalContract)principal));
        criteria.setFlattenNodes(flattenNodes);
        try {
            SimulationResults results = simulationEngine.runSimulation(criteria);
            if (this.actionRequestListHasPrincipal(principal, results.getSimulatedActionRequests())) {
                authorized = true;
            }
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        return authorized;
    }

    private boolean actionRequestListHasPrincipal(Principal principal, List<ActionRequestValue> actionRequests) {
        for (ActionRequestValue actionRequest : actionRequests) {
            if (!actionRequest.isRecipientRoutedRequest(new KimPrincipalRecipient((PrincipalContract)principal))) continue;
            return true;
        }
        return false;
    }

    public List<String> getPrincipalIdsInRouteLog(String documentId, boolean lookFuture) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new IllegalArgumentException("documentId passed in is null or blank");
        }
        HashSet<String> principalIds = new HashSet<String>();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluating isUserInRouteLog [docId=" + documentId + ", lookFuture=" + lookFuture + "]");
            }
            DocumentRouteHeaderValue routeHeader = this.loadDocument(documentId);
            List actionsTakens = (List)KEWServiceLocator.getActionTakenService().findByDocumentId(documentId);
            principalIds.add(routeHeader.getInitiatorWorkflowId());
            for (Object actionTaken : actionsTakens) {
                principalIds.add(((ActionTakenValue)actionTaken).getPrincipalId());
            }
            List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(documentId);
            for (ActionRequestValue actionRequest : actionRequests) {
                principalIds.addAll(this.getPrincipalIdsForActionRequest(actionRequest));
            }
            if (!lookFuture) {
                return new ArrayList<String>(principalIds);
            }
            SimulationWorkflowEngine simulationEngine = KEWServiceLocator.getSimulationEngine();
            SimulationCriteria criteria = SimulationCriteria.createSimulationCritUsingDocumentId(documentId);
            criteria.setDestinationNodeName(null);
            SimulationResults results = simulationEngine.runSimulation(criteria);
            actionRequests = results.getSimulatedActionRequests();
            for (ActionRequestValue actionRequest : actionRequests) {
                principalIds.addAll(this.getPrincipalIdsForActionRequest(actionRequest));
            }
        }
        catch (Exception ex) {
            LOG.warn("Problems getting principalIds in Route Log for documentId: " + documentId + ". Exception:" + ex.getMessage(), (Throwable)ex);
        }
        return new ArrayList<String>(principalIds);
    }

    private DocumentRouteHeaderValue loadDocument(String documentId) {
        return KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
    }

    private List<String> getPrincipalIdsForActionRequest(ActionRequestValue actionRequest) {
        List principalIdsForGroup;
        List<String> results = Collections.emptyList();
        if (actionRequest.getPrincipalId() != null) {
            results = Collections.singletonList(actionRequest.getPrincipalId());
        } else if (actionRequest.getGroupId() != null && (principalIdsForGroup = KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId())) != null) {
            results = principalIdsForGroup;
        }
        return results;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    private void translateException(WorkflowException e) {
        if (e instanceof InvalidActionTakenException) {
            throw new org.kuali.rice.kew.api.action.InvalidActionTakenException(e.getMessage(), (Throwable)e);
        }
        throw new WorkflowRuntimeException(e.getMessage(), (Throwable)e);
    }

    protected DocumentActionResult executeActionInternal(DocumentActionParameters parameters, DocumentActionCallback callback) {
        if (parameters == null) {
            throw new RiceIllegalArgumentException("Document action parameters was null.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(callback.getLogMessage(parameters.getDocumentId(), parameters.getPrincipalId(), parameters.getAnnotation()));
        }
        DocumentRouteHeaderValue documentBo = this.init(parameters);
        try {
            documentBo = callback.doInDocumentBo(documentBo, parameters.getPrincipalId(), parameters.getAnnotation());
        }
        catch (WorkflowException e) {
            this.translateException(e);
        }
        return this.constructDocumentActionResult(documentBo, parameters.getPrincipalId());
    }

    protected static abstract class StandardDocumentActionCallback
    implements DocumentActionCallback {
        protected StandardDocumentActionCallback() {
        }

        @Override
        public final String getLogMessage(String documentId, String principalId, String annotation) {
            return this.getActionName() + " [principalId=" + principalId + ", documentId=" + documentId + ", annotation=" + annotation + "]";
        }

        protected abstract String getActionName();
    }

    protected static interface DocumentActionCallback {
        public DocumentRouteHeaderValue doInDocumentBo(DocumentRouteHeaderValue var1, String var2, String var3) throws WorkflowException;

        public String getLogMessage(String var1, String var2, String var3);
    }
}

