/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document.authorizer;

import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.award.budget.document.authorizer.BudgetAuthorizer;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.document.Document;

public class PostAwardBudgetAuthorizer
extends BudgetAuthorizer {
    private static final String POST_ENABLED_PARAM_VALUE_1 = "1";

    @Override
    public boolean isAuthorized(String userId, Task task) {
        AwardBudgetTask budgetTask = (AwardBudgetTask)task;
        AwardBudgetDocument budgetDocument = budgetTask.getAwardBudgetDocument();
        AwardDocument doc = (AwardDocument)budgetDocument.getBudget().getBudgetParent().getDocument();
        WorkflowDocument workflowDoc = this.getWorkflowDocument((Document)budgetDocument);
        return workflowDoc.isFinal() && this.isAwardBudgetToBePosted(budgetDocument) && this.canPost() && this.hasUnitPermission(userId, doc.getLeadUnitNumber(), "KC-AB", AwardPermissionConstants.POST_AWARD_BUDGET.getAwardPermission());
    }

    private boolean canPost() {
        String postEnabled = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "AWARD_BUDGET_POST_ENABLED");
        return postEnabled.equals(POST_ENABLED_PARAM_VALUE_1);
    }

    private boolean isAwardBudgetToBePosted(AwardBudgetDocument budgetDocument) {
        String toBePostedStatusCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusToBePosted");
        return budgetDocument.getAwardBudget().getAwardBudgetStatusCode().equals(toBePostedStatusCode);
    }

    public ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }
}

