/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionStatus;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentFilter;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.summary.ParticipantSummary;
import org.kuali.kra.irb.summary.ProtocolSummary;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;

public class Protocol
extends ProtocolBase
implements CustomDataContainer {
    private static final long serialVersionUID = 4396393806439396971L;
    private static final String DEFAULT_PROTOCOL_TYPE_CODE = "1";
    private String vulnerableSubjectIndicator;
    private List<ProtocolRiskLevel> protocolRiskLevels = new ArrayList<ProtocolRiskLevel>();
    private List<ProtocolParticipant> protocolParticipants = new ArrayList<ProtocolParticipant>();
    private transient boolean lookupActionNotifyIRBProtocol;
    private transient ProtocolVersionService protocolVersionService;

    public String getVulnerableSubjectIndicator() {
        return this.vulnerableSubjectIndicator;
    }

    public void setVulnerableSubjectIndicator(String vulnerableSubjectIndicator) {
        this.vulnerableSubjectIndicator = vulnerableSubjectIndicator;
    }

    public List<ProtocolRiskLevel> getProtocolRiskLevels() {
        return this.protocolRiskLevels;
    }

    public void setProtocolRiskLevels(List<ProtocolRiskLevel> protocolRiskLevels) {
        this.protocolRiskLevels = protocolRiskLevels;
        for (ProtocolRiskLevel riskLevel : protocolRiskLevels) {
            riskLevel.init(this);
        }
    }

    public List<ProtocolParticipant> getProtocolParticipants() {
        return this.protocolParticipants;
    }

    public void setProtocolParticipants(List<ProtocolParticipant> protocolParticipants) {
        this.protocolParticipants = protocolParticipants;
        for (ProtocolParticipant participant : protocolParticipants) {
            participant.init(this);
        }
    }

    public ProtocolParticipant getProtocolParticipant(int index) {
        return this.getProtocolParticipants().get(index);
    }

    @Override
    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getProtocolRiskLevels());
        managedLists.add(this.getProtocolParticipants());
        return managedLists;
    }

    @Override
    protected ProtocolPersonnelService getProtocolPersonnelService() {
        return KcServiceLocator.getService(ProtocolPersonnelService.class);
    }

    @Override
    public ProtocolSubmission getProtocolSubmission() {
        return (ProtocolSubmission)super.getProtocolSubmission();
    }

    @Override
    public ProtocolAction getLastProtocolAction() {
        return (ProtocolAction)super.getLastProtocolAction();
    }

    @Override
    public void merge(ProtocolBase amendment, String protocolModuleTypeCode) {
        if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"001")) {
            this.mergeGeneralInfo(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"004")) {
            this.mergeResearchAreas(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"024")) {
            this.mergeFundingSources(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"017")) {
            this.mergeOrganizations(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"002")) {
            this.mergePersonnel(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"008")) {
            if (amendment.isAmendment() || amendment.isRenewal() || !amendment.getAttachmentProtocols().isEmpty() && this.getAttachmentProtocols().isEmpty()) {
                this.mergeAttachments(amendment);
            } else {
                this.restoreAttachments(this);
            }
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"016")) {
            this.mergeReferences(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"007")) {
            this.mergeSpecialReview(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"006")) {
            this.mergeSubjects((Protocol)amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"023")) {
            this.mergeOthers(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"025")) {
            this.mergeProtocolPermissions(amendment);
        } else if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"026")) {
            this.mergeProtocolQuestionnaire(amendment);
        }
    }

    @Override
    protected void removeMergeableLists(List<ProtocolAmendRenewModuleBase> modules) {
        for (ProtocolAmendRenewModuleBase module : modules) {
            String protocolModuleTypeCode = module.getProtocolModuleTypeCode();
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"004")) {
                this.getProtocolResearchAreas().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"024")) {
                this.getProtocolFundingSources().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"017")) {
                this.getProtocolLocations().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"002")) {
                this.getProtocolPersons().clear();
                continue;
            }
            if (StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"016")) {
                this.getProtocolReferences().clear();
                continue;
            }
            if (!StringUtils.equals((CharSequence)protocolModuleTypeCode, (CharSequence)"006")) continue;
            this.getProtocolParticipants().clear();
        }
    }

    @Override
    public List<AnswerHeader> getAnswerHeaderForProtocol(ProtocolBase protocol) {
        ProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new ProtocolModuleQuestionnaireBean((Protocol)protocol);
        moduleQuestionnaireBean.setModuleSubItemCode("0");
        return this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
    }

    @Override
    protected void mergeProtocolAction(ProtocolBase amendment) {
        List<ProtocolActionBase> protocolActions = this.deepCopy(amendment.getProtocolActions());
        Collections.sort(protocolActions, (action1, action2) -> action1.getActionId().compareTo(action2.getActionId()));
        protocolActions.remove(0);
        protocolActions.remove(protocolActions.size() - 1);
        for (ProtocolActionBase protocolAction : protocolActions) {
            protocolAction.setProtocolNumber(this.getProtocolNumber());
            protocolAction.setProtocolActionId(null);
            protocolAction.setSequenceNumber(this.getSequenceNumber());
            protocolAction.setProtocolId(this.getProtocolId());
            String index = amendment.getProtocolNumber().substring(11);
            protocolAction.setActionId(this.getNextValue("actionId"));
            String type = ProtocolSpecialVersion.AMENDMENT.getDescription();
            if (amendment.isRenewal()) {
                type = ProtocolSpecialVersion.RENEWAL.getDescription();
            } else if (amendment.isFYI()) {
                type = ProtocolSpecialVersion.FYI.getDescription();
            }
            if (StringUtils.isNotBlank((CharSequence)protocolAction.getComments())) {
                protocolAction.setComments(type + "-" + index + ": " + protocolAction.getComments());
            } else {
                protocolAction.setComments(type + "-" + index + ": ");
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.resetPersistenceState();
                notification.setOwningDocumentIdFk(null);
            }
            this.getProtocolActions().add(protocolAction);
        }
    }

    private void mergeSubjects(Protocol amendment) {
        this.setProtocolParticipants(this.deepCopy(amendment.getProtocolParticipants()));
    }

    @Override
    public ProtocolSummary getProtocolSummary() {
        ProtocolSummary protocolSummary = this.createProtocolSummary();
        this.addPersonnelSummaries(protocolSummary);
        this.addResearchAreaSummaries(protocolSummary);
        this.addAttachmentSummaries(protocolSummary);
        this.addFundingSourceSummaries(protocolSummary);
        this.addParticipantSummaries(protocolSummary);
        this.addOrganizationSummaries(protocolSummary);
        this.addSpecialReviewSummaries(protocolSummary);
        this.addAdditionalInfoSummary(protocolSummary);
        return protocolSummary;
    }

    private void addParticipantSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolParticipant participant : this.getProtocolParticipants()) {
            ParticipantSummary participantSummary = new ParticipantSummary();
            participantSummary.setDescription(participant.getParticipantType().getDescription());
            participantSummary.setCount(participant.getParticipantCount());
            protocolSummary.add(participantSummary);
        }
    }

    @Override
    protected ProtocolSummary createProtocolSummary() {
        ProtocolSummary summary = new ProtocolSummary();
        summary.setLastProtocolAction(this.getLastProtocolAction());
        summary.setProtocolNumber(this.getProtocolNumber());
        summary.setPiName(this.getPrincipalInvestigator().getPersonName());
        summary.setPiProtocolPersonId(this.getPrincipalInvestigator().getProtocolPersonId());
        summary.setInitialSubmissionDate(this.getInitialSubmissionDate());
        summary.setApprovalDate(this.getApprovalDate());
        summary.setLastApprovalDate(this.getLastApprovalDate());
        summary.setExpirationDate(this.getExpirationDate());
        if (this.getProtocolType() == null) {
            this.refreshReferenceObject("protocolType");
        }
        summary.setType(this.getProtocolType().getDescription());
        if (this.getProtocolStatus() == null) {
            this.refreshReferenceObject("protocolStatus");
        }
        summary.setStatus(this.getProtocolStatus().getDescription());
        summary.setTitle(this.getTitle());
        return summary;
    }

    @Override
    public String getDocumentKey() {
        return "protocol";
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("Protocol Aggregator");
        roleNames.add("Protocol Viewer");
        return roleNames;
    }

    @Override
    public String getNamespace() {
        return "KC-PROTOCOL";
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-PROTOCOL-DOC";
    }

    @Override
    public void initializeProtocolAttachmentFilter() {
        ProtocolAttachmentFilter protocolAttachmentFilter = new ProtocolAttachmentFilter();
        try {
            String defaultSortBy = this.getParameterService().getParameterValueAsString(ProtocolDocument.class, "protocolAttachmentDefaultSort");
            if (StringUtils.isNotBlank((CharSequence)defaultSortBy)) {
                protocolAttachmentFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProtocolAttachmentFilter(protocolAttachmentFilter);
    }

    @Override
    public KrmsRulesContext getKrmsRulesContext() {
        return this.getProtocolDocument();
    }

    @Override
    protected ProtocolStatusBase getProtocolStatusNewInstanceHook() {
        return new ProtocolStatus();
    }

    @Override
    protected String getDefaultProtocolStatusCodeHook() {
        return "100";
    }

    @Override
    protected String getDefaultProtocolTypeCodeHook() {
        return DEFAULT_PROTOCOL_TYPE_CODE;
    }

    @Override
    protected ProtocolResearchAreaBase getNewProtocolResearchAreaInstance() {
        return new ProtocolResearchArea();
    }

    @Override
    protected ProtocolSubmissionStatusBase getProtocolSubmissionStatusNewInstanceHook() {
        return new ProtocolSubmissionStatus();
    }

    @Override
    protected ProtocolSubmissionTypeBase getProtocolSubmissionTypeNewInstanceHook() {
        return new ProtocolSubmissionType();
    }

    @Override
    protected ProtocolSubmissionBase getProtocolSubmissionNewInstanceHook() {
        return new ProtocolSubmission();
    }

    @Override
    protected String getProtocolModuleAddModifyAttachmentCodeHook() {
        return "008";
    }

    @Override
    protected Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook() {
        return ProtocolAttachmentProtocol.class;
    }

    public boolean isLookupActionNotifyIRBProtocol() {
        return this.lookupActionNotifyIRBProtocol;
    }

    public void setLookupActionNotifyIRBProtocol(boolean lookupActionNotifyIRBProtocol) {
        this.lookupActionNotifyIRBProtocol = lookupActionNotifyIRBProtocol;
    }

    @Override
    protected void mergeProtocolSubmission(ProtocolBase amendment) {
        List<ProtocolSubmissionBase> submissions = this.deepCopy(amendment.getProtocolSubmissions());
        this.setNewSubmissionReferences(submissions);
        this.getProtocolVersionService().setExpeditedAndExemptCheckListReferences(submissions, this);
    }

    protected ProtocolVersionService getProtocolVersionService() {
        if (this.protocolVersionService == null) {
            this.protocolVersionService = KcServiceLocator.getService(ProtocolVersionService.class);
        }
        return this.protocolVersionService;
    }

    public void setProtocolVersionService(ProtocolVersionService protocolVersionService) {
        this.protocolVersionService = protocolVersionService;
    }

    @Override
    public List<? extends DocumentCustomData> getCustomDataList() {
        return this.getProtocolDocument().getDocumentCustomData();
    }
}

