/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.LookupableDevelopmentProposal;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.service.FundingSourceTypeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupableHelperService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolFundingSourceServiceImplBase
implements ProtocolFundingSourceService {
    private static final String BO_SPONSOR_NAME = "sponsor.sponsorName";
    private static final String TITLE = "title";
    private static final String SPONSOR_CODE = "sponsorCode";
    private static final String SPONSOR_NAME = "sponsorName";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String UNIT_NAME = "unitName";
    private static final String PROPOSAL_ID = "proposalId";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String AWARD_ID = "awardId";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String MAINT_DOC_LOOKUP_URL_PREFIX = "${kuali.docHandler.url.prefix}/kr/";
    private static final Logger LOG = LogManager.getLogger(ProtocolFundingSourceServiceImplBase.class);
    private FundingSourceTypeService fundingSourceTypeService;
    private SponsorService sponsorService;
    private UnitService unitService;
    private InstitutionalProposalService institutionalProposalService;
    private AwardService awardService;
    private LookupableHelperService protocolLookupableHelperService;
    private DocumentService documentService;
    private ParameterService parameterService;
    private DataObjectService dataObjectService;

    @Override
    public ProtocolFundingSourceBase updateProtocolFundingSource(String fundingSourceTypeCode, String fundingSourceNumber, String fundingSourceName) {
        ProtocolFundingSourceBase protocolFundingSource = null;
        if (StringUtils.isBlank((CharSequence)fundingSourceTypeCode) || this.isAuthorizedToAccess(fundingSourceTypeCode)) {
            if (StringUtils.isNotBlank((CharSequence)fundingSourceTypeCode) && fundingSourceTypeCode.contains(":")) {
                fundingSourceTypeCode = StringUtils.split((String)fundingSourceTypeCode, (String)":")[0];
            }
            protocolFundingSource = "1".equals(fundingSourceTypeCode) ? this.buildSponsorFundingSource(fundingSourceNumber) : ("2".equals(fundingSourceTypeCode) ? this.buildUnitFundingSource(fundingSourceNumber) : ("4".equals(fundingSourceTypeCode) && this.isDevelopmentProposalLinkEnabled() ? this.buildProposalDevelopmentFundingSource(fundingSourceNumber, fundingSourceName) : ("5".equals(fundingSourceTypeCode) && this.isInstitionalProposalLinkEnabled() ? this.buildInstitutionalProposalFundingSource(fundingSourceNumber, fundingSourceName) : ("6".equals(fundingSourceTypeCode) && this.isAwardLinkEnabled() ? this.buildAwardFundingSource(fundingSourceNumber, fundingSourceName) : this.buildOtherFundingSource(fundingSourceTypeCode, fundingSourceNumber, fundingSourceName)))));
        }
        return protocolFundingSource;
    }

    private boolean isAuthorizedToAccess(String fundingSourceTypeCode) {
        boolean isAuthorized = true;
        if (fundingSourceTypeCode.contains(":")) {
            if (GlobalVariables.getUserSession() != null) {
                ProtocolFormBase protocolForm;
                Object formObj;
                String[] invalues = StringUtils.split((String)fundingSourceTypeCode, (String)":");
                String formKey = invalues[1];
                fundingSourceTypeCode = invalues[0];
                isAuthorized = StringUtils.isBlank((CharSequence)formKey) ? false : ((formObj = GlobalVariables.getUserSession().retrieveObject(formKey)) == null || !(formObj instanceof ProtocolFormBase) ? false : (protocolForm = (ProtocolFormBase)formObj).getProtocolHelper().getModifyProtocol() && protocolForm.getProtocolHelper().getModifyFundingSource());
            } else {
                LOG.info("dwr/ajax does not have session ");
            }
        }
        return isAuthorized;
    }

    protected ProtocolFundingSourceBase buildSponsorFundingSource(String fundingSourceNumber) {
        ProtocolFundingSourceBase fundingSource = null;
        if (StringUtils.isNotBlank((CharSequence)fundingSourceNumber)) {
            String fundingSourceName = this.getSponsorService().getSponsorName(fundingSourceNumber);
            String fundingSourceTitle = "";
            fundingSource = this.creatNewProtocolFundingSourceInstanceHook(fundingSourceNumber, "1", fundingSourceName, fundingSourceTitle);
        }
        return fundingSource;
    }

    protected abstract ProtocolFundingSourceBase creatNewProtocolFundingSourceInstanceHook(String var1, String var2, String var3, String var4);

    protected ProtocolFundingSourceBase buildUnitFundingSource(String fundingSourceNumber) {
        ProtocolFundingSourceBase fundingSource = null;
        if (StringUtils.isNotBlank((CharSequence)fundingSourceNumber)) {
            String fundingSourceName = this.getUnitService().getUnitName(fundingSourceNumber);
            String fundingSourceTitle = "";
            fundingSource = this.creatNewProtocolFundingSourceInstanceHook(fundingSourceNumber, "2", fundingSourceName, fundingSourceTitle);
        }
        return fundingSource;
    }

    protected ProtocolFundingSourceBase buildProposalDevelopmentFundingSource(String fundingSourceNumber, String fundingSourceName) {
        ProtocolFundingSourceBase fundingSource = null;
        if (StringUtils.isNotBlank((CharSequence)fundingSourceNumber)) {
            String fundingSourceTitle = "";
            DevelopmentProposal devProposal = this.getDevelopmentProposal(fundingSourceNumber);
            if (devProposal != null) {
                fundingSourceName = devProposal.getSponsorName();
                fundingSourceTitle = devProposal.getTitle();
            }
            fundingSource = this.creatNewProtocolFundingSourceInstanceHook(fundingSourceNumber, "4", fundingSourceName, fundingSourceTitle);
        }
        return fundingSource;
    }

    protected DevelopmentProposal getDevelopmentProposal(String fundingSourceNumber) {
        return (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)fundingSourceNumber);
    }

    protected ProtocolFundingSourceBase buildInstitutionalProposalFundingSource(String fundingSourceNumber, String fundingSourceName) {
        ProtocolFundingSourceBase fundingSource = null;
        if (StringUtils.isNotBlank((CharSequence)fundingSourceNumber)) {
            String fundingSourceTitle = "";
            InstitutionalProposal instProposal = this.getInstitutionalProposal(fundingSourceNumber);
            if (instProposal != null) {
                fundingSourceName = instProposal.getSponsorName();
                fundingSourceTitle = instProposal.getTitle();
            }
            fundingSource = this.creatNewProtocolFundingSourceInstanceHook(fundingSourceNumber, "5", fundingSourceName, fundingSourceTitle);
        }
        return fundingSource;
    }

    protected InstitutionalProposal getInstitutionalProposal(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal;
    }

    protected ProtocolFundingSourceBase buildAwardFundingSource(String fundingSourceNumber, String fundingSourceName) {
        ProtocolFundingSourceBase fundingSource = null;
        if (StringUtils.isNotBlank((CharSequence)fundingSourceNumber)) {
            String fundingSourceTitle = "";
            Award award = this.getAward(fundingSourceNumber);
            if (award != null) {
                fundingSourceName = award.getSponsorName();
                fundingSourceTitle = award.getTitle();
            }
            fundingSource = this.creatNewProtocolFundingSourceInstanceHook(fundingSourceNumber, "6", fundingSourceName, fundingSourceTitle);
        }
        return fundingSource;
    }

    protected Award getAward(String fundingSourceNumber) {
        Award award = null;
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = awards.get(awards.size() - 1);
        }
        return award;
    }

    protected ProtocolFundingSourceBase buildOtherFundingSource(String fundingSourceTypeCode, String fundingSourceNumber, String fundingSourceName) {
        ProtocolFundingSourceBase fundingSource = null;
        FundingSourceType fundingSourceType = this.getFundingSourceTypeService().getFundingSourceType(fundingSourceTypeCode);
        if (fundingSourceType != null && StringUtils.isNotBlank((CharSequence)fundingSourceNumber)) {
            fundingSource = this.creatNewProtocolFundingSourceInstanceHook(fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, "");
        }
        return fundingSource;
    }

    @Override
    public boolean isValidIdForType(ProtocolFundingSourceBase protocolFundingSource) {
        boolean valid = false;
        if (protocolFundingSource != null && StringUtils.isNotBlank((CharSequence)protocolFundingSource.getFundingSourceTypeCode())) {
            String fundingSourceTypeCode = protocolFundingSource.getFundingSourceTypeCode();
            if ("3".equals(fundingSourceTypeCode)) {
                valid = true;
            } else if ("4".equals(fundingSourceTypeCode) && !this.isDevelopmentProposalLinkEnabled()) {
                valid = true;
            } else if ("5".equals(fundingSourceTypeCode) && !this.isInstitionalProposalLinkEnabled()) {
                valid = true;
            } else if ("6".equals(fundingSourceTypeCode) && !this.isAwardLinkEnabled()) {
                valid = true;
            } else {
                String number = protocolFundingSource.getFundingSourceNumber();
                String name = protocolFundingSource.getFundingSourceName();
                ProtocolFundingSourceBase source = this.updateProtocolFundingSource(fundingSourceTypeCode.toString(), number, name);
                if (source != null && StringUtils.isNotBlank((CharSequence)source.getFundingSourceName())) {
                    valid = true;
                }
            }
        }
        return valid;
    }

    @Override
    public Map.Entry<String, String> getLookupParameters(String fundingSourceTypeCode) {
        HashMap<String, String> boAndFields = new HashMap<String, String>();
        FundingSourceLookup sourceLookup = FundingSourceLookup.OTHER;
        if ("2".equals(fundingSourceTypeCode)) {
            sourceLookup = FundingSourceLookup.UNIT;
        } else if ("1".equals(fundingSourceTypeCode)) {
            sourceLookup = FundingSourceLookup.SPONSOR;
        } else if ("6".equals(fundingSourceTypeCode)) {
            sourceLookup = FundingSourceLookup.AWARD;
        } else if ("4".equals(fundingSourceTypeCode)) {
            sourceLookup = FundingSourceLookup.PROPOSAL_DEVELOPMENT;
        } else if ("5".equals(fundingSourceTypeCode)) {
            sourceLookup = FundingSourceLookup.INSTITUTIONAL_PROPOSAL;
        } else {
            throw new IllegalArgumentException("Funding source parameter lookup error. The processIsValidLookup rule was not invoked or missed error condition.");
        }
        if (sourceLookup != FundingSourceLookup.OTHER) {
            String fieldConversions = this.createCustomFieldConversions(sourceLookup);
            boAndFields.put(sourceLookup.getBOClass().getName(), fieldConversions);
        }
        return boAndFields.entrySet().iterator().next();
    }

    private String createCustomFieldConversions(FundingSourceLookup fundingSourceLookup) {
        StringBuffer fieldConversions = new StringBuffer();
        if (fundingSourceLookup != FundingSourceLookup.OTHER) {
            if (StringUtils.isNotBlank((CharSequence)fundingSourceLookup.getKeyCode())) {
                fieldConversions.append(fundingSourceLookup.getKeyCode() + ":");
                fieldConversions.append("protocolHelper.newFundingSource.fundingSource,");
            }
            fieldConversions.append(fundingSourceLookup.getNumber() + ":");
            fieldConversions.append("protocolHelper.newFundingSource.fundingSourceNumber,");
            fieldConversions.append(fundingSourceLookup.getName() + ":");
            fieldConversions.append("protocolHelper.newFundingSource.fundingSourceName");
            if (StringUtils.isNotBlank((CharSequence)fundingSourceLookup.getTitle())) {
                fieldConversions.append(",");
                fieldConversions.append(fundingSourceLookup.getTitle() + ":");
                fieldConversions.append("protocolHelper.newFundingSource.fundingSourceTitle");
            }
        }
        return fieldConversions.toString();
    }

    @Override
    public String updateLookupParameter(String parameter, String boClassName, String fieldConversions) {
        StringBuffer fullParameterBuffer = new StringBuffer(parameter);
        int start = fullParameterBuffer.indexOf("(!!") + "(!!".length();
        int end = fullParameterBuffer.indexOf("!!)");
        fullParameterBuffer.replace(start, end, boClassName);
        start = fullParameterBuffer.indexOf("(((") + "(((".length();
        end = fullParameterBuffer.indexOf(")))");
        fullParameterBuffer.replace(start, end, fieldConversions);
        return fullParameterBuffer.toString();
    }

    @Override
    public String getViewProtocolFundingSourceUrl(ProtocolFundingSourceBase protocolFundingSource, ProtocolActionBase action) throws Exception {
        String fundingSourceTypeCode = protocolFundingSource.getFundingSourceTypeCode();
        String fundingSourceNumber = protocolFundingSource.getFundingSourceNumber();
        String viewUrl = null;
        if ("1".equals(fundingSourceTypeCode)) {
            Sponsor sponsor = new Sponsor();
            sponsor.setSponsorCode(fundingSourceNumber);
            viewUrl = this.buildViewMaintenanceFundingSourceUrl((BusinessObject)sponsor, FundingSourceLookup.SPONSOR.getNumber());
        } else if ("2".equals(fundingSourceTypeCode)) {
            Unit unit = new Unit();
            unit.setUnitNumber(fundingSourceNumber);
            viewUrl = this.buildViewMaintenanceFundingSourceUrl((BusinessObject)unit, FundingSourceLookup.UNIT.getNumber());
        } else if ("4".equals(fundingSourceTypeCode)) {
            DevelopmentProposal developmentProposal = this.getDevelopmentProposal(fundingSourceNumber);
            String documentNumber = developmentProposal.getProposalDocument().getDocumentNumber();
            viewUrl = this.buildViewTransactionalFundingSourceUrl(documentNumber, action);
        } else if ("5".equals(fundingSourceTypeCode)) {
            InstitutionalProposal institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber);
            String documentNumber = institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber();
            viewUrl = this.buildViewTransactionalFundingSourceUrl(documentNumber, action);
        } else if ("6".equals(fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            String documentNumber = award.getAwardDocument().getDocumentNumber();
            viewUrl = this.buildViewTransactionalFundingSourceUrl(documentNumber, action);
        }
        return viewUrl;
    }

    private String buildViewMaintenanceFundingSourceUrl(BusinessObject businessObject, String propertyName) {
        HtmlData forward = this.getProtocolLookupableHelperService().getInquiryUrl(businessObject, propertyName);
        return Utilities.substituteConfigParameters((String)(MAINT_DOC_LOOKUP_URL_PREFIX + ((HtmlData.AnchorHtmlData)forward).getHref()));
    }

    private String buildViewTransactionalFundingSourceUrl(String documentNumber, ProtocolActionBase action) throws Exception {
        Document document = this.getDocumentService().getByDocumentHeaderId(documentNumber);
        String routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
        Properties parameters = new Properties();
        parameters.put("viewDocument", Boolean.TRUE.toString());
        parameters.put("viewFundingSource", Boolean.TRUE.toString());
        StringBuilder builder = new StringBuilder();
        builder.append(action.buildForwardUrl(routeHeaderId));
        for (Map.Entry<Object, Object> parameter : parameters.entrySet()) {
            builder.append("&");
            builder.append(parameter.getKey());
            builder.append("=");
            builder.append(parameter.getValue());
        }
        return builder.toString();
    }

    private boolean isDevelopmentProposalLinkEnabled() {
        return this.isLinkEnabled("irb.protocol.development.proposal.linking.enabled");
    }

    private boolean isInstitionalProposalLinkEnabled() {
        return this.isLinkEnabled("irb.protocol.institute.proposal.linking.enabled");
    }

    private boolean isAwardLinkEnabled() {
        return this.isLinkEnabled("irb.protocol.award.linking.enabled");
    }

    protected boolean isLinkEnabled(String link) {
        assert (link != null) : "link is null";
        boolean isLinkEnabled = false;
        isLinkEnabled = this.parameterService.parameterExists(this.getProtocolDocumentBOClassHook(), link) == false ? true : this.parameterService.getParameterValueAsBoolean(this.getProtocolDocumentBOClassHook(), link);
        return isLinkEnabled;
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook();

    @Override
    public boolean isEditable(String fundingSourceTypeCode) {
        boolean isEditable = true;
        if ("1".equals(fundingSourceTypeCode)) {
            isEditable = false;
        } else if ("2".equals(fundingSourceTypeCode)) {
            isEditable = false;
        } else if ("4".equals(fundingSourceTypeCode) && this.isDevelopmentProposalLinkEnabled()) {
            isEditable = false;
        } else if ("5".equals(fundingSourceTypeCode) && this.isInstitionalProposalLinkEnabled()) {
            isEditable = false;
        } else if ("6".equals(fundingSourceTypeCode) && this.isAwardLinkEnabled()) {
            isEditable = false;
        }
        return isEditable;
    }

    @Override
    public boolean isLookupable(String fundingSourceTypeCode) {
        boolean isLookupable = false;
        if ("1".equals(fundingSourceTypeCode)) {
            isLookupable = true;
        } else if ("2".equals(fundingSourceTypeCode)) {
            isLookupable = true;
        } else if ("6".equals(fundingSourceTypeCode) && this.isAwardLinkEnabled()) {
            isLookupable = true;
        } else if ("4".equals(fundingSourceTypeCode) && this.isDevelopmentProposalLinkEnabled()) {
            isLookupable = true;
        } else if ("5".equals(fundingSourceTypeCode) && this.isInstitionalProposalLinkEnabled()) {
            isLookupable = true;
        }
        return isLookupable;
    }

    public FundingSourceTypeService getFundingSourceTypeService() {
        return this.fundingSourceTypeService;
    }

    public void setFundingSourceTypeService(FundingSourceTypeService fundingSourceTypeService) {
        this.fundingSourceTypeService = fundingSourceTypeService;
    }

    public SponsorService getSponsorService() {
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public LookupableHelperService getProtocolLookupableHelperService() {
        return this.protocolLookupableHelperService;
    }

    public void setProtocolLookupableHelperService(LookupableHelperService protocolLookupableHelperService) {
        this.protocolLookupableHelperService = protocolLookupableHelperService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    private static enum FundingSourceLookup {
        SPONSOR(Sponsor.class, "", "sponsorCode", "sponsorName", ""),
        UNIT(Unit.class, "", "unitNumber", "unitName", ""),
        OTHER(Object.class, "", "", "", ""),
        PROPOSAL_DEVELOPMENT(LookupableDevelopmentProposal.class, "", "proposalNumber", "sponsor.sponsorName", "title"),
        INSTITUTIONAL_PROPOSAL(InstitutionalProposal.class, "proposalId", "proposalNumber", "sponsor.sponsorName", "title"),
        AWARD(Award.class, "awardId", "awardNumber", "sponsor.sponsorName", "title");

        private final Class<?> clazz;
        private final String keyCode;
        private final String number;
        private final String name;
        private final String title;

        private FundingSourceLookup(Class<?> clazz, String keyCode, String number, String name, String title) {
            this.clazz = clazz;
            this.keyCode = keyCode;
            this.number = number;
            this.title = title;
            this.name = name;
        }

        public Class<?> getBOClass() {
            return this.clazz;
        }

        public String getKeyCode() {
            return this.keyCode;
        }

        public String getNumber() {
            return this.number;
        }

        public String getTitle() {
            return this.title;
        }

        public String getName() {
            return this.name;
        }
    }
}

