/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.query.operator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Operator;
import org.kuali.coeus.common.budget.framework.query.operator.Or;

public abstract class RelationalOperator
implements Operator {
    private static final Logger LOG = LogManager.getLogger(RelationalOperator.class);
    protected String fieldName;
    protected Comparable fixedData;
    protected boolean booleanFixedData;
    protected boolean isBoolean;
    private Field field;
    private Method method;
    private Class dataClass;

    public RelationalOperator(String fieldName, Comparable fixedData) {
        this.fieldName = fieldName;
        this.fixedData = fixedData;
    }

    public RelationalOperator(String fieldName, boolean booleanFixedData) {
        this.fieldName = fieldName;
        this.booleanFixedData = booleanFixedData;
        this.isBoolean = true;
    }

    protected int compare(Object baseBean) {
        int compareValue = 0;
        if (this.dataClass == null || !this.dataClass.equals(baseBean.getClass())) {
            this.dataClass = baseBean.getClass();
            try {
                this.field = this.dataClass.getDeclaredField(this.fieldName);
                if (!this.field.isAccessible()) {
                    throw new NoSuchFieldException();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.tryAccessingWithGetters();
            }
        }
        try {
            if (this.field != null && this.field.isAccessible()) {
                if (!this.isBoolean) {
                    Comparable comparable = (Comparable)this.field.get(baseBean);
                    if (comparable == null && this.fixedData == null) {
                        compareValue = 0;
                    } else {
                        if (comparable == null) {
                            throw new UnsupportedOperationException();
                        }
                        compareValue = comparable.compareTo(this.fixedData);
                    }
                } else {
                    compareValue = (Boolean)this.field.get(baseBean) == this.booleanFixedData ? 0 : 1;
                }
            } else if (!this.isBoolean) {
                Comparable comparable = (Comparable)this.method.invoke(baseBean, null);
                if (comparable == null && this.fixedData == null) {
                    compareValue = 0;
                } else {
                    if (comparable == null) {
                        throw new UnsupportedOperationException();
                    }
                    compareValue = comparable != null && this.fixedData == null ? -1 : comparable.compareTo(this.fixedData);
                }
            } else {
                Boolean booleanObj = (Boolean)this.method.invoke(baseBean, null);
                compareValue = booleanObj == null ? -1 : (booleanObj == this.booleanFixedData ? 0 : 1);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error(illegalAccessException.getMessage(), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error(invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        return compareValue;
    }

    protected void tryAccessingWithGetters() {
        try {
            String methodName = this.isBoolean ? "is" + ("" + this.fieldName.charAt(0)).toUpperCase() + this.fieldName.substring(1) : "get" + ("" + this.fieldName.charAt(0)).toUpperCase() + this.fieldName.substring(1);
            this.method = this.dataClass.getMethod(methodName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.tryAccessingBooleanWithGet();
        }
    }

    protected void tryAccessingBooleanWithGet() {
        try {
            String methodName = "get" + ("" + this.fieldName.charAt(0)).toUpperCase() + this.fieldName.substring(1);
            this.method = this.dataClass.getMethod(methodName, null);
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException(exception);
        }
    }

    public And and(Operator relatesTo) {
        return new And(this, relatesTo);
    }

    public Or or(Operator relatesTo) {
        return new Or(this, relatesTo);
    }
}

