/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.instprop.impl.sponsor;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.instprop.api.sponsor.InstPropSponsorService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="instPropSponsorService")
public class InstPropSponsorServiceImpl
implements InstPropSponsorService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public void updateSponsorProposalNumber(Long institutionalProposalId, String sponsorProposalNumber) {
        if (institutionalProposalId == null) {
            throw new IllegalArgumentException("institutionalProposalId is null");
        }
        if (StringUtils.isBlank((CharSequence)sponsorProposalNumber)) {
            throw new IllegalArgumentException("sponsorProposalNumber is blank");
        }
        InstitutionalProposal ip = (InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, Collections.singletonMap("proposalId", institutionalProposalId));
        if (ip != null && StringUtils.isBlank((CharSequence)ip.getSponsorProposalNumber())) {
            ip.setSponsorProposalNumber(sponsorProposalNumber);
            this.businessObjectService.save((PersistableBusinessObject)ip);
        }
    }
}

