/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.project.ExconProjectRPSEntity;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ExconProjectRPSEntitiesBean
implements Serializable {
    private static final long serialVersionUID = 23434534457L;
    private static final Logger LOG = LogManager.getLogger(ExconProjectRPSEntitiesBean.class);
    protected ExconProjectRPSEntity newRPSEntity;
    protected ExconProjectForm exconProjectForm;
    private transient BusinessObjectService businessObjectService;
    private transient ParameterService parameterService;

    public ExconProjectRPSEntitiesBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public void addRpsEntity() {
        boolean success = true;
        if (success) {
            this.getExconProject().add(this.getRpsEntity());
        }
    }

    public ExconProjectRPSEntity getRpsEntity() {
        ExconProjectRPSEntity savedRpsEntity = this.getExconProject().getRpsEntity();
        if (savedRpsEntity != null) {
            return savedRpsEntity;
        }
        return this.newRPSEntity;
    }

    public void deleteRpsEntity() {
        this.getExconProject().deleteRPSEntity();
        this.init();
    }

    public void editRpsEntity() {
        if (this.newRPSEntity.getConcatNames() == null || StringUtils.isEmpty((CharSequence)this.newRPSEntity.getConcatNames().trim())) {
            this.newRPSEntity = this.getExconProject().getRpsEntity();
        }
        this.getExconProject().deleteRPSEntity();
    }

    public ExconProjectRPSEntity getSavedRPSEntity() {
        return this.getExconProject().getRpsEntity();
    }

    private String parmReplace(String inStr) {
        ExconProjectRPSEntity entity = this.getRpsEntity();
        return inStr.replace("[firstName]", this.encode(entity.getFirstName())).replace("[otherNames]", this.encode(entity.getOtherNames())).replace("[lastName]", this.encode(entity.getLastName())).replace("[companyName]", this.encode(entity.getCompanyName())).replace("[streetAddress]", this.encode(entity.getStreetAddress())).replace("[city]", this.encode(entity.getCity())).replace("[state]", this.encode(entity.getState())).replace("[shortCountryCode]", this.encode(entity.getShortCountryCode())).replace("[countryCode]", this.encode(entity.getCountryCode()));
    }

    public String getRpsURL() {
        String rawRpsURL = this.getParameterService().getParameterValueAsString("KC-GEN", "Document", "rpsURL");
        if (rawRpsURL == null) {
            return "rpsURL parameter is not set";
        }
        return this.parmReplace(rawRpsURL);
    }

    public String encode(String inStr) {
        if (inStr == null) {
            return "";
        }
        try {
            return URLEncoder.encode(inStr, StandardCharsets.US_ASCII);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return inStr;
        }
    }

    protected void init() {
        this.newRPSEntity = new ExconProjectRPSEntity();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

