/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public class RefreshControllerServiceImpl
implements RefreshControllerService {
    private ModelAndViewService modelAndViewService;

    @Override
    public ModelAndView refresh(UifFormBase form) {
        String refreshStatus;
        String messageToDisplay;
        HttpServletRequest request = form.getRequest();
        if (request.getParameterMap().containsKey("messageToDisplay") && StringUtils.isNotBlank((String)(messageToDisplay = request.getParameter("messageToDisplay")))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("GLOBAL_ERRORS", messageToDisplay, new String[0]);
        }
        if (request.getParameterMap().containsKey("refreshStatus") && "ERROR".equals(refreshStatus = request.getParameter("refreshStatus"))) {
            return this.getModelAndViewService().getModelAndView(form);
        }
        String refreshCallerType = "";
        if (request.getParameterMap().containsKey("refreshCallerType")) {
            refreshCallerType = request.getParameter("refreshCallerType");
        }
        if (StringUtils.equals((String)refreshCallerType, (String)"MULTI_VALUE_LOOKUP")) {
            this.processMultiValueReturn(form, request);
        }
        if (request.getParameterMap().containsKey("referencesToRefresh")) {
            final String referencesToRefresh = request.getParameter("referencesToRefresh");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ViewLifecycle.getHelper().refreshReferences(referencesToRefresh);
                }
            };
            ViewLifecycle.encapsulateLifecycle(form.getView(), form, form.getViewPostMetadata(), null, request, runnable);
        }
        if (request.getParameterMap().containsKey("quickfinderId")) {
            String quickfinderId = request.getParameter("quickfinderId");
            this.setFocusJumpFromQuickfinder(form, quickfinderId);
            this.invokeQuickfinderCallback(form, request, quickfinderId);
        }
        return this.getModelAndViewService().getModelAndView(form);
    }

    protected void processMultiValueReturn(final UifFormBase form, HttpServletRequest request) {
        final String lookupCollectionId = request.getParameter("lookupCollectionId");
        final String lookupCollectionName = request.getParameter("lookupCollectionName");
        if (StringUtils.isBlank((String)lookupCollectionName)) {
            throw new RuntimeException("Lookup collection name is required for processing multi-value lookup results");
        }
        final String multiValueReturnFields = request.getParameter("multiValueReturnFields");
        String selectedLineValuesParam = request.getParameter("selectedLineValues");
        String flashMapSelectedLineValues = "";
        if (RequestContextUtils.getInputFlashMap((HttpServletRequest)request) != null) {
            flashMapSelectedLineValues = (String)RequestContextUtils.getInputFlashMap((HttpServletRequest)request).get("selectedLineValues");
        }
        if (!StringUtils.isBlank((String)flashMapSelectedLineValues)) {
            selectedLineValuesParam = flashMapSelectedLineValues;
        }
        final String selectedLineValues = selectedLineValuesParam;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewLifecycle.getHelper().processMultipleValueLookupResults(form, lookupCollectionId, lookupCollectionName, multiValueReturnFields, selectedLineValues);
            }
        };
        ViewLifecycle.encapsulateLifecycle(form.getView(), form, form.getViewPostMetadata(), null, request, runnable);
    }

    protected void setFocusJumpFromQuickfinder(UifFormBase form, String quickfinderId) {
        String jumpToId;
        String focusId = (String)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderFocusId");
        if (StringUtils.isNotBlank((String)focusId)) {
            form.setFocusId(focusId);
        }
        if (StringUtils.isNotBlank((String)(jumpToId = (String)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderJumpToId")))) {
            form.setJumpToId(jumpToId);
        }
    }

    protected void invokeQuickfinderCallback(UifFormBase form, HttpServletRequest request, final String quickfinderId) {
        String callbackMethodToCall = (String)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderCallbackMethodToCall");
        MethodInvokerConfig callbackMethod = (MethodInvokerConfig)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderCallbackMethod");
        if (StringUtils.isBlank((String)callbackMethodToCall) && callbackMethod == null) {
            return;
        }
        if (callbackMethod == null) {
            callbackMethod = new MethodInvokerConfig();
        }
        Map callbackContext = (Map)form.getViewPostMetadata().getComponentPostData(quickfinderId, "quickfinderCallbackContext");
        if (callbackMethod.getTargetClass() == null && callbackMethod.getTargetObject() == null) {
            callbackMethod.setTargetObject(form.getViewHelperService());
        }
        callbackMethod.setTargetMethod(callbackMethodToCall);
        Object[] arguments = new Object[]{form, quickfinderId, callbackContext};
        callbackMethod.setArguments(arguments);
        final MethodInvokerConfig methodToInvoke = callbackMethod;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    methodToInvoke.prepare();
                    methodToInvoke.invoke();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking callback method for quickfinder: " + quickfinderId, e);
                }
            }
        };
        ViewLifecycle.encapsulateLifecycle(form.getView(), form, form.getViewPostMetadata(), null, request, runnable);
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

