/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.protocol.ProtocolType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolTypeValuesFinder
extends UifKeyValuesFinderBase {
    private PermissionService permissionService;
    private static final String PERMISSION_NAME = "View Active Protocol Types";

    public List<KeyValue> getKeyValues() {
        KeyValuesService keyValuesService = (KeyValuesService)KcServiceLocator.getService("keyValuesService");
        Collection protocolTypes = keyValuesService.findAllOrderBy(ProtocolType.class, "description", true);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        boolean canViewNonGlobalProtocolTypes = this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", PERMISSION_NAME);
        for (ProtocolType protocolType : protocolTypes) {
            if (!protocolType.isGlobalFlag() && !canViewNonGlobalProtocolTypes) continue;
            if (StringUtils.equals((CharSequence)protocolType.getDescription(), (CharSequence)"Standard")) {
                keyValues.add(0, (KeyValue)new ConcreteKeyValue(protocolType.getProtocolTypeCode().toString(), protocolType.getDescription()));
                continue;
            }
            keyValues.add((KeyValue)new ConcreteKeyValue(protocolType.getProtocolTypeCode().toString(), protocolType.getDescription()));
        }
        return keyValues;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }
}

