/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.style;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.coreservice.api.style.Style;
import org.kuali.rice.coreservice.api.style.StyleRepositoryService;
import org.kuali.rice.coreservice.impl.style.StyleBo;
import org.kuali.rice.coreservice.impl.style.StyleDao;
import org.kuali.rice.coreservice.impl.style.StyleXmlParser;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class StyleRepositoryServiceImpl
implements StyleRepositoryService {
    private static final Logger LOG = LogManager.getLogger(StyleRepositoryServiceImpl.class);
    private static final String STYLE_CONFIG_PREFIX = "edl.style";
    private StyleXmlParser styleXmlParser;
    private DataObjectService dataObjectService;
    private StyleDao styleDao;

    public void setStyleXmlParser(StyleXmlParser styleXmlParser) {
        this.styleXmlParser = styleXmlParser;
    }

    public Style getStyle(String styleName) {
        if (StringUtils.isBlank((String)styleName)) {
            throw new RiceIllegalArgumentException("styleName was null or blank");
        }
        StyleBo style = this.getStyleByName(styleName);
        if (style == null) {
            String propertyName = "edl.style." + styleName;
            String location = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
            if (location != null) {
                InputStream xml;
                try {
                    xml = RiceUtilities.getResourceAsStream((String)location);
                }
                catch (MalformedURLException e) {
                    throw new RiceRuntimeException(this.getUnableToLoadMessage(propertyName, location), (Throwable)e);
                }
                catch (IOException e) {
                    throw new RiceRuntimeException(this.getUnableToLoadMessage(propertyName, location), (Throwable)e);
                }
                if (xml == null) {
                    throw new RiceRuntimeException(this.getUnableToLoadMessage(propertyName, location) + ", no such file");
                }
                LOG.info("Automatically loading style '" + styleName + "' from '" + location + "' as configured by " + propertyName);
                List<Style> styles = this.styleXmlParser.parseStyles(xml);
                for (Style autoLoadedStyle : styles) {
                    if (!autoLoadedStyle.getName().equals(styleName)) continue;
                    return autoLoadedStyle;
                }
                throw new RiceRuntimeException("Failed to locate auto-loaded style '" + styleName + "' after successful parsing of file from '" + location + "' as configured by " + propertyName);
            }
        }
        return StyleBo.to(style);
    }

    private String getUnableToLoadMessage(String propertyName, String location) {
        return "unable to load resource at '" + location + "' specified by configuration parameter '" + propertyName + "'";
    }

    private StyleBo getStyleByName(String styleName) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", styleName);
        attributes.put("active", Boolean.TRUE);
        QueryResults styleBos = this.dataObjectService.findMatching(StyleBo.class, QueryByCriteria.Builder.andAttributes(attributes).build());
        if (styleBos != null && styleBos.getResults().size() > 0) {
            return (StyleBo)((Object)styleBos.getResults().get(0));
        }
        return null;
    }

    public void saveStyle(Style data) {
        if (data == null) {
            throw new RiceIllegalArgumentException("The given style was null.");
        }
        StyleBo styleToUpdate = StyleBo.from(data);
        this.saveStyleBo(styleToUpdate);
    }

    protected void saveStyleBo(StyleBo styleBo) {
        StyleBo existingData = this.getStyleByName(styleBo.getName());
        if (existingData != null) {
            existingData.setActive(false);
            this.dataObjectService.save((Object)existingData, new PersistenceOption[0]);
        }
        this.dataObjectService.save((Object)styleBo, new PersistenceOption[0]);
    }

    public List<String> getAllStyleNames() {
        return this.styleDao.getAllStyleNames();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Required
    public void setStyleDao(StyleDao styleDao) {
        this.styleDao = styleDao;
    }
}

