/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.rule;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.rule.RoleNameContract;
import org.w3c.dom.Element;

@XmlRootElement(name="roleName")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RoleNameType", propOrder={"name", "baseName", "returnUrl", "label", "_futureElements"})
public final class RoleName
extends AbstractDataTransferObject
implements RoleNameContract {
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="baseName", required=true)
    private final String baseName;
    @XmlElement(name="returnUrl", required=false)
    private final String returnUrl;
    @XmlElement(name="label", required=true)
    private final String label;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RoleName() {
        this.name = null;
        this.baseName = null;
        this.returnUrl = null;
        this.label = null;
    }

    private RoleName(Builder builder) {
        this.name = builder.getName();
        this.baseName = builder.getBaseName();
        this.returnUrl = builder.getReturnUrl();
        this.label = builder.getLabel();
    }

    public RoleName(String attributeClassName, String baseName, String label) {
        this(Builder.createWithClassName(attributeClassName, baseName, label));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public static String constructRoleValue(String attributeClassName, String roleName) {
        return attributeClassName + "!" + roleName;
    }

    static class Elements {
        static final String NAME = "name";
        static final String BASE_NAME = "baseName";
        static final String RETURN_URL = "returnUrl";
        static final String LABEL = "label";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "roleName";
        static final String TYPE_NAME = "RoleNameType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RoleNameContract {
        private String name;
        private String baseName;
        private String returnUrl;
        private String label;

        private Builder(String name, String baseName, String label) {
            this.setName(name);
            this.setBaseName(baseName);
            this.setLabel(label);
        }

        public static Builder createWithClassName(String attributeClassName, String baseName, String label) {
            return new Builder(RoleName.constructRoleValue(attributeClassName, baseName), baseName, label);
        }

        public static Builder create(String name, String baseName, String label) {
            return new Builder(name, baseName, label);
        }

        public static Builder create(RoleNameContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getName(), contract.getBaseName(), contract.getLabel());
            builder.setReturnUrl(contract.getReturnUrl());
            return builder;
        }

        public RoleName build() {
            return new RoleName(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new RiceIllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setBaseName(String baseName) {
            if (StringUtils.isBlank((String)baseName)) {
                throw new RiceIllegalArgumentException("baseName is blank");
            }
            this.baseName = baseName;
        }

        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        public void setLabel(String label) {
            if (StringUtils.isBlank((String)label)) {
                throw new RiceIllegalArgumentException("label is blank");
            }
            this.label = label;
        }
    }
}

