/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.kew.docsearch.SearchableAttributeBase;

public abstract class SearchableAttributeNumericBase
extends SearchableAttributeBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    static final long serialVersionUID = 3113454241181917742L;

    protected abstract Pattern getDefaultValidationPattern();

    @Override
    public boolean isPassesDefaultValidation(String valueEntered) {
        boolean isValid = true;
        if (StringUtils.contains((String)valueEntered, (String)SearchOperator.AND.op())) {
            isValid = this.isOperandsValid(valueEntered, SearchOperator.AND);
        } else if (StringUtils.contains((String)valueEntered, (String)SearchOperator.OR.op())) {
            isValid = this.isOperandsValid(valueEntered, SearchOperator.OR);
        } else if (StringUtils.contains((String)valueEntered, (String)SearchOperator.BETWEEN.op())) {
            isValid = this.isOperandsValid(valueEntered, SearchOperator.BETWEEN);
        } else {
            Pattern pattern = this.getDefaultValidationPattern();
            Matcher matcher = pattern.matcher(SQLUtils.cleanNumericOfValidOperators((String)valueEntered).trim());
            isValid = matcher.matches();
        }
        return isValid;
    }

    private boolean isOperandsValid(String valueEntered, SearchOperator binaryOperator) {
        if (StringUtils.contains((String)valueEntered, (String)binaryOperator.op())) {
            String[] l;
            for (String value : l = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)valueEntered, (String)binaryOperator.op())) {
                if (this.isPassesDefaultValidation(value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SearchableAttributeNumericBase();
    }

    @Override
    public Object _persistence_get(String string) {
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        super._persistence_set(string, object);
    }
}

