/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.krad.kim.NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl;

public class PopulateGroupPermissionTypeServiceImpl
extends NamespaceWildcardAllowedAndOrStringExactMatchPermissionTypeServiceImpl {
    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        PermissionBo bo;
        String requestedGroupName = requestedDetails.get("groupName");
        String requestedKimTypeName = requestedDetails.get("kimTypeName");
        String requestedNamespaceCode = requestedDetails.get("namespaceCode");
        ArrayList<Permission> exactMatchingPermissions = new ArrayList<Permission>();
        ArrayList<Permission> nonKimTypeMatchingPermissions = new ArrayList<Permission>();
        for (Permission kpi : permissionsList) {
            bo = PermissionBo.from((Permission)kpi);
            String groupName = (String)bo.getDetails().get("groupName");
            if (!StringUtils.equals((String)requestedGroupName, (String)groupName)) continue;
            exactMatchingPermissions.add(kpi);
        }
        if (exactMatchingPermissions.isEmpty()) {
            for (Permission kpi : permissionsList) {
                bo = PermissionBo.from((Permission)kpi);
                String kimTypeName = (String)bo.getDetails().get("kimTypeName");
                String namespaceCode = (String)bo.getDetails().get("namespaceCode");
                if (StringUtils.equals((String)requestedKimTypeName, (String)kimTypeName) && StringUtils.isNotBlank((String)namespaceCode) && StringUtils.isNotBlank((String)requestedNamespaceCode) && requestedNamespaceCode.matches(namespaceCode.replaceAll("\\*", ".*"))) {
                    exactMatchingPermissions.add(kpi);
                    continue;
                }
                if (!StringUtils.isEmpty((String)kimTypeName)) continue;
                nonKimTypeMatchingPermissions.add(kpi);
            }
        }
        if (exactMatchingPermissions.isEmpty()) {
            for (Permission kpi : permissionsList) {
                bo = PermissionBo.from((Permission)kpi);
                String namespaceCode = (String)bo.getDetails().get("namespaceCode");
                if (!StringUtils.equals((String)requestedNamespaceCode, (String)namespaceCode)) continue;
                exactMatchingPermissions.add(kpi);
            }
        }
        if (!exactMatchingPermissions.isEmpty()) {
            return super.performPermissionMatches(requestedDetails, exactMatchingPermissions);
        }
        return super.performPermissionMatches(requestedDetails, nonKimTypeMatchingPermissions);
    }
}

