/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.document;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectDestinationsAuditRule
implements DocumentAuditRule {
    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ExconProjectDocument exconProjectDocument = (ExconProjectDocument)document;
        return valid &= this.projectHasDestination(exconProjectDocument);
    }

    private boolean projectHasDestination(ExconProjectDocument exconProjectDocument) {
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        ExconProject project = exconProjectDocument.getExconProject();
        if (project != null && StringUtils.equals((CharSequence)"International Travel", (CharSequence)project.getProjectType().getDescription()) && project.getExconProjectDestinations().size() < 1) {
            auditErrors.add(new AuditError("exconProjectDestinationsBean.newDestination.destinationCountryCode", "error.exconProjectDestination.missing", "destinations.destinations"));
            GlobalVariables.getAuditErrorMap().put("destinationsAuditErrors", new AuditCluster("Destinations", auditErrors, "Error"));
            return false;
        }
        return true;
    }
}

