/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.engine.RoutingNodeFactory;
import org.kuali.rice.kew.engine.node.BasicJoinEngine;
import org.kuali.rice.kew.engine.node.DynamicNode;
import org.kuali.rice.kew.engine.node.JoinEngine;
import org.kuali.rice.kew.engine.node.JoinNode;
import org.kuali.rice.kew.engine.node.Node;
import org.kuali.rice.kew.engine.node.RequestActivationNode;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SubProcessNode;

public class RouteHelper {
    private JoinEngine joinEngine = new BasicJoinEngine();
    private RoutingNodeFactory nodeFactory = new RoutingNodeFactory();

    public JoinEngine getJoinEngine() {
        return this.joinEngine;
    }

    public RoutingNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public boolean isSimpleNode(RouteNode routeNode) {
        return ClassLoaderUtils.isInstanceOf((Object)this.getNode(routeNode), SimpleNode.class);
    }

    public boolean isJoinNode(RouteNode routeNode) {
        return ClassLoaderUtils.isInstanceOf((Object)this.getNode(routeNode), JoinNode.class);
    }

    public boolean isSplitNode(RouteNode routeNode) {
        return ClassLoaderUtils.isInstanceOf((Object)this.getNode(routeNode), SplitNode.class);
    }

    public boolean isDynamicNode(RouteNode routeNode) {
        return ClassLoaderUtils.isInstanceOf((Object)this.getNode(routeNode), DynamicNode.class);
    }

    public boolean isSubProcessNode(RouteNode routeNode) {
        return ClassLoaderUtils.isInstanceOf((Object)this.getNode(routeNode), SubProcessNode.class);
    }

    public boolean isRequestActivationNode(RouteNode routeNode) {
        return ClassLoaderUtils.isInstanceOf((Object)this.getNode(routeNode), RequestActivationNode.class);
    }

    public boolean isRequestsNode(RouteNode routeNode) {
        return this.getNode(routeNode) instanceof RequestsNode;
    }

    public Node getNode(RouteNode routeNode) {
        return (Node)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(routeNode.getNodeType(), routeNode.getDocumentType().getApplicationId()));
    }
}

