/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.krms.KcRulesEngineExecuter;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;

public class ProposalDevelopmentRulesEngineExecutorImpl
extends KcRulesEngineExecuter {
    private KcKrmsFactBuilderServiceHelper kcKrmsFactBuilderServiceHelper;

    protected KcKrmsFactBuilderServiceHelper getKcKrmsFactBuilderServiceHelper() {
        if (this.kcKrmsFactBuilderServiceHelper == null) {
            this.kcKrmsFactBuilderServiceHelper = this.getProposalDevelopmentFactBuilderService();
        }
        return this.kcKrmsFactBuilderServiceHelper;
    }

    @Override
    public EngineResults performExecute(RouteContext routeContext, Engine engine) {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("namespaceCode", "KC-PD");
        contextQualifiers.put("name", "KC Proposal Development Context");
        String docContent = routeContext.getDocument().getDocContent();
        String proposalNumber = this.getElementValue(docContent, "//proposalNumber");
        List<String> unitNumbers = this.getProposalUnits(proposalNumber, routeContext);
        String unitNumbersAsString = StringUtils.join(unitNumbers, (char)',');
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumbersAsString));
        KcKrmsFactBuilderServiceHelper fbService = this.getProposalDevelopmentFactBuilderService();
        Facts.Builder factsBuilder = Facts.Builder.create();
        fbService.addFacts(factsBuilder, docContent);
        EngineResults results = engine.execute(selectionCriteria, factsBuilder.build(), null);
        return results;
    }

    private KcKrmsFactBuilderServiceHelper getProposalDevelopmentFactBuilderService() {
        return (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("proposalDevelopmentFactBuilderService");
    }

    public List<String> getProposalUnits(String proposalNumber, RouteContext routeContext) {
        DataObjectService dataObjectService = this.getDataObjectService();
        String docContent = routeContext.getDocument().getDocContent();
        String unitNumber = this.getElementValue(docContent, "//ownedByUnitNumber");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("developmentProposal.proposalNumber", proposalNumber);
        List proposalPersons = dataObjectService.findMatching(ProposalPerson.class, QueryByCriteria.Builder.andAttributes(params).build()).getResults();
        ArrayList<String> units = new ArrayList<String>();
        units.add(unitNumber);
        for (ProposalPerson proposalPerson : proposalPersons) {
            List<ProposalPersonUnit> proposalPersonUnits = proposalPerson.getUnits();
            for (ProposalPersonUnit proposalPersonUnit : proposalPersonUnits) {
                if (units.contains(proposalPersonUnit.getUnitNumber())) continue;
                units.add(proposalPersonUnit.getUnitNumber());
            }
        }
        return units;
    }

    private DataObjectService getDataObjectService() {
        return KcServiceLocator.getService(DataObjectService.class);
    }
}

