/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ProtocolAffiliateTypeDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected List<String> requiredAttributes = new ArrayList<String>();

    public ProtocolAffiliateTypeDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                if (person.getAffiliationType() == null || !StringUtils.equals((CharSequence)person.getAffiliationType().getDescription(), (CharSequence)roleName) || !StringUtils.isNotBlank((CharSequence)person.getPerson().getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)person.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        Protocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                if (!StringUtils.equals((CharSequence)principalId, (CharSequence)person.getPersonId()) || person.getAffiliationType() == null || !StringUtils.equals((CharSequence)roleName, (CharSequence)person.getAffiliationType().getDescription())) continue;
                return true;
            }
        }
        return false;
    }

    private Protocol getProtocol(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        return (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, keymap);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

