/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.Version;

public class Dot {
    private static Dot instance = new Dot();
    private final Version version;
    private final Version supportedVersion;
    private final Version badVersion;
    private final String lineSeparator;
    private String dotExe;
    private String format;
    private String renderer;
    private final Set<String> validatedRenderers;
    private final Set<String> invalidatedRenderers;
    private final Logger logger;

    private Dot() {
        String string;
        block5: {
            this.supportedVersion = new Version("2.2.1");
            this.badVersion = new Version("2.4");
            this.lineSeparator = System.getProperty("line.separator");
            this.format = "png";
            this.validatedRenderers = Collections.synchronizedSet(new HashSet());
            this.invalidatedRenderers = Collections.synchronizedSet(new HashSet());
            this.logger = Logger.getLogger(Dot.class.getName());
            string = null;
            String[] stringArray = new String[]{this.getExe(), "-V"};
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String string2 = bufferedReader.readLine();
                this.logger.config("Version: \"" + string2 + "\"");
                Matcher matcher = Pattern.compile("[0-9][0-9.]+").matcher(string2);
                if (matcher.find()) {
                    string = matcher.group();
                } else if (Config.getInstance().isHtmlGenerationEnabled()) {
                    System.err.println();
                    this.logger.warning("Invalid dot configuration detected.  '" + Dot.getDisplayableCommand(stringArray) + "' returned:");
                    this.logger.warning("   " + string2);
                }
            }
            catch (Exception exception) {
                if (!Config.getInstance().isHtmlGenerationEnabled()) break block5;
                System.err.println();
                this.logger.warning("Failed to query Graphviz version information");
                this.logger.warning("  with: " + Dot.getDisplayableCommand(stringArray));
                this.logger.warning("  " + exception);
                this.logger.log(Level.INFO, "Graphviz query failure details:", exception);
            }
        }
        this.version = new Version(string);
        this.validatedRenderers.add("");
    }

    public static Dot getInstance() {
        return instance;
    }

    public boolean exists() {
        return this.version.toString() != null;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isValid() {
        return this.exists() && (this.getVersion().equals(this.supportedVersion) || this.getVersion().compareTo(this.badVersion) > 0);
    }

    public String getSupportedVersions() {
        return "dot version " + this.supportedVersion + " or versions greater than " + this.badVersion;
    }

    public boolean supportsCenteredEastWestEdges() {
        return this.getVersion().compareTo(new Version("2.6")) >= 0;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean requiresGdRenderer() {
        return this.getVersion().compareTo(new Version("2.12")) >= 0 && this.supportsRenderer(":gd");
    }

    public void setRenderer(String string) {
        if (this.isValid() && !this.supportsRenderer(string)) {
            this.logger.info("renderer '" + string + "' is not supported by your version of dot");
        }
        this.renderer = string;
    }

    public String getRenderer() {
        if (this.renderer == null) {
            this.setHighQuality(true);
        }
        return this.supportsRenderer(this.renderer) ? this.renderer : (this.requiresGdRenderer() ? ":gd" : "");
    }

    public void setHighQuality(boolean bl) {
        if (bl && this.supportsRenderer(":cairo")) {
            this.setRenderer(":cairo");
        } else if (this.supportsRenderer(":gd")) {
            this.setRenderer(":gd");
        } else {
            this.setRenderer("");
        }
    }

    public boolean isHighQuality() {
        return this.getRenderer().indexOf(":cairo") != -1;
    }

    public boolean supportsRenderer(String string) {
        if (!this.exists()) {
            return false;
        }
        if (this.validatedRenderers.contains(string)) {
            return true;
        }
        if (this.invalidatedRenderers.contains(string)) {
            return false;
        }
        try {
            String string2;
            String[] stringArray = new String[]{this.getExe(), "-T" + this.getFormat() + ":"};
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contains(this.getFormat() + string)) continue;
                this.validatedRenderers.add(string);
            }
            process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.validatedRenderers.contains(string)) {
            this.logger.info("Failed to validate " + this.getFormat() + " renderer '" + string + "'.  Reverting to default renderer for " + this.getFormat() + ".");
            this.invalidatedRenderers.add(string);
            return false;
        }
        return true;
    }

    private String getExe() {
        if (this.dotExe == null) {
            File file = Config.getInstance().getGraphvizDir();
            this.dotExe = file == null ? "dot" : new File(new File(file, "bin"), "dot").toString();
        }
        return this.dotExe;
    }

    public String generateDiagram(File file, File file2) throws DotFailure {
        StringBuilder stringBuilder = new StringBuilder(1024);
        BufferedReader bufferedReader = null;
        String[] stringArray = new String[]{this.getExe(), "-T" + this.getFormat() + this.getRenderer(), file.toString(), "-o" + file2, "-Tcmapx"};
        String string = Dot.getDisplayableCommand(stringArray);
        this.logger.fine(string);
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(stringArray);
            new ProcessOutputReader(string, process.getErrorStream()).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append(this.lineSeparator);
            }
            int n = process.waitFor();
            if (n != 0) {
                throw new DotFailure("'" + string + "' failed with return code " + n);
            }
            if (!file2.exists()) {
                throw new DotFailure("'" + string + "' failed to create output file");
            }
            String string3 = stringBuilder.toString().replace("/>", ">");
            return string3;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (DotFailure dotFailure) {
            file2.delete();
            throw dotFailure;
        }
        catch (IOException iOException) {
            file2.delete();
            throw new DotFailure("'" + string + "' failed with exception " + iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getDisplayableCommand(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private static class ProcessOutputReader
    extends Thread {
        private final BufferedReader processReader;
        private final String command;

        ProcessOutputReader(String string, InputStream inputStream) {
            this.processReader = new BufferedReader(new InputStreamReader(inputStream));
            this.command = string;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.processReader.readLine()) != null) {
                    if (string.indexOf("unrecognized") != -1 || string.indexOf("port") != -1) continue;
                    System.err.println(this.command + ": " + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    this.processReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public class DotFailure
    extends IOException {
        private static final long serialVersionUID = 3833743270181351987L;

        public DotFailure(String string) {
            super(string);
        }
    }
}

