/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.net.URL;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.RestServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.ResourceFacade;
import org.kuali.rice.ksb.messaging.BusClientFailureProxy;
import org.kuali.rice.ksb.messaging.bam.BAMClientProxy;
import org.kuali.rice.ksb.security.soap.CredentialsOutHandler;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class ResourceFacadeImpl
implements ResourceFacade {
    private static final Logger LOG = LogManager.getLogger(ResourceFacadeImpl.class);
    private final RestServiceConfiguration serviceConfiguration;
    private CredentialsSource credentialsSource;
    private URL actualEndpointUrl;

    public ResourceFacadeImpl(RestServiceConfiguration serviceConfiguration, URL actualEndpointUrl) {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException("serviceConfiguration cannot be null");
        }
        if (actualEndpointUrl == null) {
            throw new IllegalArgumentException("actual endpoint url cannot be null");
        }
        this.serviceConfiguration = serviceConfiguration;
        this.actualEndpointUrl = actualEndpointUrl;
    }

    public <R> R getResource(Class<R> resourceClass) {
        if (resourceClass == null) {
            throw new IllegalArgumentException("resourceClass argument must not be null");
        }
        if (!this.serviceConfiguration.hasClass(resourceClass.getName())) {
            throw new IllegalArgumentException("Service " + this.serviceConfiguration.getServiceName() + " does not contain an implementation of type " + resourceClass.getName());
        }
        return this.getServiceProxy(resourceClass);
    }

    public <R> R getResource(String resourceName) {
        String resourceClassName = null;
        Map resourceToClassNameMap = this.serviceConfiguration.getResourceToClassNameMap();
        resourceClassName = resourceName != null && resourceToClassNameMap != null ? (String)resourceToClassNameMap.get(resourceName) : this.serviceConfiguration.getResourceClass();
        if (resourceClassName == null) {
            throw new RiceRuntimeException("No resource class name was found for the specified resourceName: " + resourceName);
        }
        Class<?> resourceClass = null;
        try {
            resourceClass = Class.forName(resourceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RiceRuntimeException("Configured resource class " + resourceClassName + " in service " + this.serviceConfiguration.getServiceName() + " is not loadable", (Throwable)e);
        }
        Object serviceProxy = this.getServiceProxy(resourceClass);
        return (R)serviceProxy;
    }

    private <R> R getServiceProxy(Class<R> resourceClass) {
        JAXRSClientFactoryBean clientFactory = new JAXRSClientFactoryBean();
        clientFactory.setBus(KSBServiceLocator.getCXFBus());
        clientFactory.setResourceClass(resourceClass);
        clientFactory.setAddress(this.actualEndpointUrl.toString());
        BindingFactoryManager bindingFactoryManager = (BindingFactoryManager)KSBServiceLocator.getCXFBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory bindingFactory = new JAXRSBindingFactory();
        bindingFactory.setBus(KSBServiceLocator.getCXFBus());
        bindingFactoryManager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)bindingFactory);
        if (LOG.isDebugEnabled()) {
            clientFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        }
        if (this.getCredentialsSource() != null) {
            clientFactory.getOutInterceptors().add(new CredentialsOutHandler(this.getCredentialsSource(), (ServiceConfiguration)this.serviceConfiguration));
        }
        if (LOG.isDebugEnabled()) {
            clientFactory.getInInterceptors().add(new LoggingInInterceptor());
        }
        Client service = clientFactory.create();
        return this.getServiceProxyWithFailureMode(resourceClass, service, this.serviceConfiguration);
    }

    public boolean isSingleResourceService() {
        return MapUtils.isEmpty((Map)this.serviceConfiguration.getResourceToClassNameMap());
    }

    public void setCredentialsSource(CredentialsSource credentialsSource) {
        this.credentialsSource = credentialsSource;
    }

    protected CredentialsSource getCredentialsSource() {
        return this.credentialsSource;
    }

    protected <R> R getServiceProxyWithFailureMode(Class<R> resourceClass, Object service, RestServiceConfiguration serviceConfiguration) {
        Object bamWrappedClientProxy = BAMClientProxy.wrap(service, (ServiceConfiguration)serviceConfiguration);
        Object proxy = BusClientFailureProxy.wrap(bamWrappedClientProxy, (ServiceConfiguration)serviceConfiguration);
        if (!resourceClass.isInstance(proxy)) {
            throw new IllegalArgumentException("Wrapped proxy is of the wrong type " + proxy.getClass() + ", expected " + resourceClass);
        }
        return resourceClass.cast(proxy);
    }
}

