/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.InvalidPropertyException;
import com.codiform.moo.MissingSourcePropertyException;
import com.codiform.moo.MissingSourcePropertyValueException;
import com.codiform.moo.NoSourceException;
import com.codiform.moo.NothingToTranslateException;
import com.codiform.moo.UnsupportedTranslationException;
import com.codiform.moo.annotation.Access;
import com.codiform.moo.annotation.AccessMode;
import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.property.CollectionProperty;
import com.codiform.moo.property.MapProperty;
import com.codiform.moo.property.Property;
import com.codiform.moo.property.PropertyFactory;
import com.codiform.moo.property.source.SourceProperty;
import com.codiform.moo.property.source.SourcePropertyFactory;
import com.codiform.moo.session.TranslationSource;
import com.codiform.moo.translator.TranslatorFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectTranslator<T> {
    private Class<T> destinationClass;
    private Configuration configuration;
    private TranslatorFactory translatorFactory;
    private SourcePropertyFactory sourcePropertyFactory;

    public ObjectTranslator(Class<T> destination, Configuration configuration, TranslatorFactory translatorFactory, SourcePropertyFactory sourcePropertyFactory) {
        this.destinationClass = destination;
        this.configuration = configuration;
        this.translatorFactory = translatorFactory;
        this.sourcePropertyFactory = sourcePropertyFactory;
    }

    public void update(Object source, T destination, TranslationSource translationSource, Map<String, Object> variables) {
        this.assureSource(source);
        boolean updated = false;
        List<Property> properties = this.getProperties(this.destinationClass);
        for (Property item : properties) {
            if (item.isIgnored() || !this.updateProperty(source, destination, translationSource, item, variables)) continue;
            updated = true;
        }
        if (!updated) {
            throw new NothingToTranslateException(source.getClass(), destination.getClass());
        }
    }

    private void assureSource(Object source) {
        if (source == null) {
            throw new NoSourceException();
        }
    }

    public void castAndUpdate(Object source, Object from, TranslationSource translationSource, Map<String, Object> variables) {
        this.update(source, this.destinationClass.cast(from), translationSource, variables);
    }

    private Object getPropertyValueTranslation(Object value, Property property, TranslationSource translationSource) {
        if (value == null) {
            return null;
        }
        if (property instanceof CollectionProperty) {
            return this.transformCollection(value, (CollectionProperty)property, translationSource);
        }
        if (property instanceof MapProperty) {
            return this.transformMap(value, (MapProperty)property, translationSource);
        }
        if (value.getClass().isArray()) {
            return this.transformArray((Object[])value, property, translationSource);
        }
        if (property.shouldBeTranslated()) {
            return translationSource.getTranslation(value, property.getFactory(), property.getType());
        }
        return value;
    }

    private Object transformMap(Object value, MapProperty property, TranslationSource translationSource) {
        return this.translatorFactory.getMapTranslator().translate(value, property, translationSource);
    }

    private Object transformArray(Object[] value, Property property, TranslationSource translationSource) {
        Class<?> fieldType = property.getType();
        Class<?> valueType = value.getClass();
        if (valueType.isAssignableFrom(fieldType)) {
            return this.translatorFactory.getArrayTranslator().defensiveCopy(value);
        }
        if (fieldType.isArray()) {
            if (valueType.isAssignableFrom(fieldType.getComponentType())) {
                return this.translatorFactory.getArrayTranslator().copyTo(value, fieldType);
            }
            return this.translatorFactory.getArrayTranslator().translate(value, fieldType.getComponentType(), translationSource);
        }
        throw new UnsupportedTranslationException(String.format("Cannot translate from source array type %s[] to destination type %s", valueType.getComponentType(), fieldType.getName()));
    }

    private Object transformCollection(Object value, CollectionProperty property, TranslationSource translationSource) {
        return this.translatorFactory.getCollectionTranslator().translate(value, property, translationSource);
    }

    private Object getValue(Object source, Property property, Map<String, Object> variables) {
        SourceProperty sourceProperty = this.sourcePropertyFactory.getSourceProperty(property.getSourcePropertyExpression());
        if (variables == null || variables.isEmpty()) {
            return sourceProperty.getValue(source);
        }
        return sourceProperty.getValue(source, variables);
    }

    List<Property> getProperties(Class<T> destinationClass) {
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        for (Class<T> current = destinationClass; current != null; current = current.getSuperclass()) {
            if (this.shouldIgnoreClass(current)) continue;
            this.merge(properties, this.getPropertiesForClass(current));
        }
        return this.getOrderedProperties(properties);
    }

    private List<Property> getOrderedProperties(Map<String, Property> properties) {
        ArrayList<Property> ordered = new ArrayList<Property>(properties.size());
        for (Map.Entry<String, Property> entry : properties.entrySet()) {
            ordered.add(0, entry.getValue());
        }
        return ordered;
    }

    private boolean shouldIgnoreClass(Class<?> current) {
        return current.getSimpleName().contains("$$_javassist");
    }

    private void merge(Map<String, Property> currentProperties, Set<Property> superclassProperties) {
        for (Property item : superclassProperties) {
            if (currentProperties.containsKey(item.getName())) {
                if (!item.isExplicit() || currentProperties.get(item.getName()).isExplicit()) continue;
                currentProperties.remove(item.getName());
                currentProperties.put(item.getName(), item);
                continue;
            }
            currentProperties.put(item.getName(), item);
        }
    }

    private Set<Property> getPropertiesForClass(Class<?> clazz) {
        Property property;
        HashMap<String, Property> properties = new HashMap<String, Property>();
        Access access = clazz.getAnnotation(Access.class);
        AccessMode mode = access == null ? this.configuration.getDefaultAccessMode() : access.value();
        for (Field field : clazz.getDeclaredFields()) {
            property = PropertyFactory.createProperty(field, mode);
            if (property == null) continue;
            properties.put(property.getName(), property);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            property = PropertyFactory.createProperty((Method)accessibleObject, mode);
            if (property == null) continue;
            if (properties.containsKey(property.getName())) {
                Property current = (Property)properties.get(property.getName());
                if (current.isExplicit() && property.isExplicit()) {
                    throw new InvalidPropertyException(property.getName(), property.getDeclaringClass(), "Property %s (in %s) is explicitly defined with @Property as both field and method properties; Moo expects no more than one annotation per property name per class.");
                }
                if (current.isExplicit() || !property.isExplicit()) continue;
                properties.put(property.getName(), property);
                continue;
            }
            properties.put(property.getName(), property);
        }
        return new HashSet<Property>(properties.values());
    }

    private <V> boolean updateProperty(Object source, T destination, TranslationSource translationSource, Property property, Map<String, Object> variables) {
        try {
            Object sourceValue = this.getValue(source, property, variables);
            this.updateOrReplaceProperty(destination, sourceValue, property, translationSource);
            return true;
        }
        catch (MissingSourcePropertyValueException exception) {
            if (property.isSourceRequired(this.configuration.isSourcePropertyRequired())) {
                throw exception;
            }
            return false;
        }
        catch (MissingSourcePropertyException exception) {
            if (property.isSourceRequired(this.configuration.isSourcePropertyRequired())) {
                throw exception;
            }
            return false;
        }
    }

    private void updateOrReplaceProperty(T destination, Object sourceValue, Property property, TranslationSource translationSource) {
        Object destinationValue;
        Object object = destinationValue = property.canGetValue() ? property.getValue(destination) : null;
        if (property.shouldUpdate() && sourceValue != null && destinationValue != null) {
            if (property.isTypeOrSubtype(Collection.class)) {
                this.updateCollection(sourceValue, (Collection)destinationValue, (CollectionProperty)property, translationSource);
            } else if (property.isTypeOrSubtype(Map.class)) {
                this.updateMap(sourceValue, (Map)destinationValue, (MapProperty)property, translationSource);
            } else {
                translationSource.update(sourceValue, destinationValue);
            }
        } else {
            destinationValue = this.getPropertyValueTranslation(sourceValue, property, translationSource);
            property.setValue(destination, destinationValue);
        }
    }

    private void updateMap(Object source, Map<Object, Object> destinationMap, MapProperty property, TranslationSource translationSource) {
        this.translatorFactory.getMapTranslator().updateMap(source, destinationMap, translationSource, property);
    }

    private void updateCollection(Object source, Collection<Object> destinationCollection, CollectionProperty property, TranslationSource translationSource) {
        this.translatorFactory.getCollectionTranslator().updateCollection(source, destinationCollection, translationSource, property);
    }
}

