/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.DataTypeConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.processor.ExistenceConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.processor.LengthConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.processor.RangeConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public class SimpleConstraintProcessor
extends MandatoryElementConstraintProcessor<SimpleConstraint> {
    private static final String CONSTRAINT_NAME = "simple constraint";
    RangeConstraintProcessor rangeConstraintProcessor = new RangeConstraintProcessor();
    LengthConstraintProcessor lengthConstraintProcessor = new LengthConstraintProcessor();
    ExistenceConstraintProcessor existenceConstraintProcessor = new ExistenceConstraintProcessor();
    DataTypeConstraintProcessor dataTypeConstraintProcessor = new DataTypeConstraintProcessor();

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, SimpleConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        ProcessorResult dataTypePR = this.dataTypeConstraintProcessor.process(result, value, constraint, attributeValueReader);
        ProcessorResult existencePR = this.existenceConstraintProcessor.process(result, value, constraint, attributeValueReader);
        ProcessorResult rangePR = this.rangeConstraintProcessor.process(result, value, constraint, attributeValueReader);
        ProcessorResult lengthPR = this.lengthConstraintProcessor.process(result, value, constraint, attributeValueReader);
        ArrayList<ConstraintValidationResult> cvrList = new ArrayList<ConstraintValidationResult>();
        cvrList.addAll(existencePR.getConstraintValidationResults());
        cvrList.addAll(rangePR.getConstraintValidationResults());
        cvrList.addAll(lengthPR.getConstraintValidationResults());
        cvrList.addAll(dataTypePR.getConstraintValidationResults());
        return new ProcessorResult(cvrList);
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return SimpleConstraint.class;
    }
}

