/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleCache;
import org.drools.compiler.kie.builder.impl.KieModuleCacheHelper;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;

public class KieMetaInfoBuilder {
    private final InternalKieModule kModule;

    public KieMetaInfoBuilder(InternalKieModule kModule) {
        this.kModule = kModule;
    }

    public void writeKieModuleMetaInfo(ResourceStore trgMfs) {
        KieModuleMetaInfo info = this.generateKieModuleMetaInfo(trgMfs);
        trgMfs.write("META-INF/kmodule.info", info.marshallMetaInfos().getBytes(IoUtils.UTF8_CHARSET), true);
    }

    public KieModuleMetaInfo getKieModuleMetaInfo() {
        return this.generateKieModuleMetaInfo(null);
    }

    public KieModuleMetaInfo generateKieModuleMetaInfo(ResourceStore trgMfs) {
        HashMap<String, TypeMetaInfo> typeInfos = new HashMap<String, TypeMetaInfo>();
        HashMap rulesPerPackage = new HashMap();
        KieModuleModel kieModuleModel = this.kModule.getKieModuleModel();
        for (String kieBaseName : kieModuleModel.getKieBaseModels().keySet()) {
            KnowledgeBuilderImpl kBuilder = (KnowledgeBuilderImpl)this.kModule.getKnowledgeBuilderForKieBase(kieBaseName);
            Map<String, PackageRegistry> pkgRegistryMap = kBuilder.getPackageRegistry();
            KieModuleCache.KModuleCache.Builder _kmoduleCacheBuilder = this.createCacheBuilder();
            KieModuleCache.CompilationData.Builder _compData = this.createCompilationData();
            for (KiePackage kPkg : kBuilder.getKnowledgePackages()) {
                PackageRegistry pkgRegistry = pkgRegistryMap.get(kPkg.getName());
                JavaDialectRuntimeData runtimeData = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
                ArrayList<String> types = new ArrayList<String>();
                for (FactType factType : kPkg.getFactTypes()) {
                    byte[] bytes;
                    Class typeClass = ((ClassDefinition)factType).getDefinedClass();
                    TypeDeclaration typeDeclaration = pkgRegistry.getPackage().getTypeDeclaration(typeClass);
                    if (typeDeclaration != null) {
                        typeInfos.put(typeClass.getName(), new TypeMetaInfo(typeDeclaration));
                    }
                    String className = factType.getName();
                    String internalName = className.replace('.', '/') + ".class";
                    if (trgMfs != null && (bytes = runtimeData.getBytecode(internalName)) != null) {
                        trgMfs.write(internalName, bytes, true);
                    }
                    types.add(internalName);
                }
                HashSet<String> rules = (HashSet<String>)rulesPerPackage.get(kPkg.getName());
                if (rules == null) {
                    rules = new HashSet<String>();
                }
                for (Rule rule : kPkg.getRules()) {
                    if (rules.contains(rule.getName())) continue;
                    rules.add(rule.getName());
                }
                if (!rules.isEmpty()) {
                    rulesPerPackage.put(kPkg.getName(), rules);
                }
                this.addToCompilationData(_compData, runtimeData, types);
            }
            _kmoduleCacheBuilder.addCompilationData(_compData.build());
            if (trgMfs == null) continue;
            this.writeCompilationDataToTrg(_kmoduleCacheBuilder.build(), kieBaseName, trgMfs);
        }
        return new KieModuleMetaInfo(typeInfos, rulesPerPackage);
    }

    private KieModuleCache.KModuleCache.Builder createCacheBuilder() {
        return KieModuleCache.KModuleCache.newBuilder();
    }

    private KieModuleCache.CompilationData.Builder createCompilationData() {
        return KieModuleCache.CompilationData.newBuilder().setDialect("java");
    }

    private void addToCompilationData(KieModuleCache.CompilationData.Builder _cdata, JavaDialectRuntimeData runtimeData, List<String> types) {
        for (Map.Entry entry : runtimeData.getStore().entrySet()) {
            if (types.contains(entry.getKey())) continue;
            KieModuleCache.CompDataEntry _entry = KieModuleCache.CompDataEntry.newBuilder().setId((String)entry.getKey()).setData(ByteString.copyFrom((byte[])((byte[])entry.getValue()))).build();
            _cdata.addEntry(_entry);
        }
    }

    private void writeCompilationDataToTrg(KieModuleCache.KModuleCache _kmoduleCache, String kieBaseName, ResourceStore trgMfs) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            KieModuleCacheHelper.writeToStreamWithHeader(out, (Message)_kmoduleCache);
            String compilatonDataPath = "META-INF/" + kieBaseName.replace('.', '/') + "/kbase.cache";
            trgMfs.write(compilatonDataPath, out.toByteArray(), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

