/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.s3.impl;

import co.kuali.coeus.s3.api.S3File;
import co.kuali.coeus.s3.api.S3FileMetadata;
import co.kuali.coeus.s3.api.S3FileService;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class S3FileServiceimpl
implements S3FileService {
    private String bucketName;
    private String replicationBucketName;
    private AmazonS3 amazonS3;

    @Override
    public String createFile(S3File s3File) {
        String uniqueFileNameGuid;
        if (s3File == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (s3File.getFileContents() == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        if (!this.amazonS3.doesBucketExist(this.bucketName)) {
            this.amazonS3.createBucket(new CreateBucketRequest(this.bucketName));
        }
        if (StringUtils.isNotBlank((CharSequence)this.replicationBucketName) && !this.amazonS3.doesBucketExist(this.replicationBucketName)) {
            this.amazonS3.createBucket(new CreateBucketRequest(this.replicationBucketName));
        }
        String string = uniqueFileNameGuid = StringUtils.isNotBlank((CharSequence)s3File.getId()) ? s3File.getId() : UUID.randomUUID().toString();
        if (this.amazonS3.doesObjectExist(this.bucketName, uniqueFileNameGuid)) {
            throw new IllegalStateException("file already exists with id " + uniqueFileNameGuid);
        }
        TransferManager manager = TransferManagerBuilder.standard().withS3Client(this.amazonS3).build();
        ObjectMetadata metadata = this.createObjectMetadata(s3File);
        Upload upload = manager.upload(this.bucketName, uniqueFileNameGuid, s3File.getFileContents(), metadata);
        try {
            upload.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to upload file to s3", e);
        }
        s3File.setId(uniqueFileNameGuid);
        return uniqueFileNameGuid;
    }

    protected ObjectMetadata createObjectMetadata(S3File file) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (file.getFileMetaData() != null) {
            Map<String, Object> suppliedMetadata = file.getFileMetaData().getMetadata();
            if (suppliedMetadata != null) {
                Date lastModified;
                String contentLanguage;
                String contentMd5;
                String contentEncoding;
                String cacheControl;
                Long contentLength;
                String contentType = (String)suppliedMetadata.remove("Content-Type");
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    metadata.setContentType(S3FileServiceimpl.flattenToAscii(contentType));
                }
                if ((contentLength = (Long)suppliedMetadata.remove("Content-Length")) != null) {
                    metadata.setContentLength(contentLength.longValue());
                }
                if (StringUtils.isNotBlank((CharSequence)(cacheControl = (String)suppliedMetadata.remove("Cache-Control")))) {
                    metadata.setCacheControl(S3FileServiceimpl.flattenToAscii(cacheControl));
                }
                if (StringUtils.isNotBlank((CharSequence)(contentEncoding = (String)suppliedMetadata.remove("Content-Encoding")))) {
                    metadata.setContentEncoding(S3FileServiceimpl.flattenToAscii(contentEncoding));
                }
                if (StringUtils.isNotBlank((CharSequence)(contentMd5 = (String)suppliedMetadata.remove("Content-MD5")))) {
                    metadata.setContentMD5(contentMd5);
                }
                if (StringUtils.isNotBlank((CharSequence)(contentLanguage = (String)suppliedMetadata.remove("Content-Language")))) {
                    metadata.setContentLanguage(S3FileServiceimpl.flattenToAscii(contentLanguage));
                }
                if ((lastModified = (Date)suppliedMetadata.remove("Last-Modified")) != null) {
                    metadata.setLastModified(lastModified);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)file.getFileMetaData().getFileName())) {
                metadata.setContentDisposition("attachment; filename=" + S3FileServiceimpl.flattenToAscii(file.getFileMetaData().getFileName()));
            }
            if (suppliedMetadata != null) {
                suppliedMetadata.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).forEach(e -> metadata.addUserMetadata(S3FileServiceimpl.flattenToAscii((String)e.getKey()), S3FileServiceimpl.flattenToAscii(String.valueOf(e.getValue()))));
            }
        }
        metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        return metadata;
    }

    private static String flattenToAscii(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        for (char c : string.toCharArray()) {
            if (c > '\u007f') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public S3File retrieveFile(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id cannot be blank");
        }
        if (!this.amazonS3.doesObjectExist(this.bucketName, id)) {
            return null;
        }
        S3Object s3Object = this.amazonS3.getObject(this.bucketName, id);
        S3File s3File = new S3File();
        s3File.setFileContents((InputStream)s3Object.getObjectContent());
        HashMap<String, Object> metadata = new HashMap<String, Object>(s3Object.getObjectMetadata().getRawMetadata());
        metadata.putAll(s3Object.getObjectMetadata().getUserMetadata());
        S3FileMetadata s3FileMetadata = new S3FileMetadata();
        s3FileMetadata.setMetadata(metadata);
        s3FileMetadata.setFileName(s3Object.getObjectMetadata().getUserMetaDataOf("File-Name"));
        s3File.setFileMetaData(s3FileMetadata);
        s3File.setId(id);
        return s3File;
    }

    @Override
    public void updateFile(S3File s3File) {
        if (s3File == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)s3File.getId())) {
            throw new IllegalArgumentException("file id cannot be blank");
        }
        if (s3File.getFileContents() == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        if (!this.amazonS3.doesObjectExist(this.bucketName, s3File.getId())) {
            throw new IllegalStateException("file does not exist with id " + s3File.getId());
        }
        TransferManager manager = new TransferManager(this.amazonS3);
        ObjectMetadata metadata = this.createObjectMetadata(s3File);
        Upload upload = manager.upload(this.bucketName, s3File.getId(), s3File.getFileContents(), metadata);
        try {
            upload.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to upload file to s3", e);
        }
    }

    @Override
    public void deleteFile(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id cannot be blank");
        }
        if (this.amazonS3.doesObjectExist(this.bucketName, id)) {
            this.amazonS3.deleteObject(new DeleteObjectRequest(this.bucketName, id));
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getReplicationBucketName() {
        return this.replicationBucketName;
    }

    public void setReplicationBucketName(String replicationBucketName) {
        this.replicationBucketName = replicationBucketName;
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }

    public void setAmazonS3(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }
}

