/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.inquiry;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.inquiry.InquiryControllerService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.impl.ControllerServiceImpl;
import org.springframework.web.servlet.ModelAndView;

public class InquiryControllerServiceImpl
extends ControllerServiceImpl
implements InquiryControllerService {
    @Override
    public ModelAndView start(UifFormBase form) {
        ModelAndView redirectModelAndView;
        InquiryForm inquiryForm = (InquiryForm)form;
        HttpServletRequest request = form.getRequest();
        Boolean hasRedirectedInquiryParameter = request.getParameter("redirectedInquiry") != null && request.getParameter("redirectedInquiry").contains("true");
        if (!inquiryForm.isRedirectedInquiry() && !hasRedirectedInquiryParameter.booleanValue() && (redirectModelAndView = this.checkForModuleInquiryRedirect(inquiryForm, request)) != null) {
            return redirectModelAndView;
        }
        Object dataObject = inquiryForm.getInquirable().retrieveDataObject(KRADUtils.translateRequestParameterMap(request.getParameterMap()));
        inquiryForm.setDataObject(dataObject);
        return super.start(inquiryForm);
    }

    protected ModelAndView checkForModuleInquiryRedirect(InquiryForm inquiryForm, HttpServletRequest request) {
        Class<?> inquiryObjectClass;
        try {
            inquiryObjectClass = Class.forName(inquiryForm.getDataObjectClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RiceRuntimeException("Unable to get class for name: " + inquiryForm.getDataObjectClassName(), (Throwable)e);
        }
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass)) {
            String inquiryUrl = responsibleModuleService.getExternalizableDataObjectInquiryUrl(inquiryObjectClass, KRADUtils.convertRequestMapToProperties(request.getParameterMap()));
            Properties redirectUrlProps = new Properties();
            redirectUrlProps.put("redirectedInquiry", "true");
            GlobalVariables.getUifFormManager().removeSessionForm(inquiryForm);
            return this.getModelAndViewService().performRedirect(inquiryForm, inquiryUrl, redirectUrlProps);
        }
        return null;
    }

    @Override
    public void downloadDataObjectAttachment(InquiryForm form, HttpServletResponse response) {
        Object dataObject = form.getDataObject();
        if (dataObject instanceof PersistableAttachment) {
            PersistableAttachment attachment = (PersistableAttachment)dataObject;
            byte[] attachmentContent = attachment.getAttachmentContent();
            this.addAttachmentToResponse(response, attachmentContent, attachment.getContentType(), attachment.getFileName());
        } else if (dataObject instanceof PersistableAttachmentList) {
            PersistableAttachmentList attachmentListBo = (PersistableAttachmentList)dataObject;
            PersistableAttachment attachment = (PersistableAttachment)attachmentListBo.getAttachments().get(Integer.parseInt(form.getActionParamaterValue("selectedLineIndex")));
            byte[] attachmentContent = attachment.getAttachmentContent();
            this.addAttachmentToResponse(response, attachmentContent, attachment.getContentType(), attachment.getFileName());
        }
    }

    @Override
    public void downloadCustomDataObjectAttachment(InquiryForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = request.getParameter("fileName");
        String contentType = request.getParameter("contentType");
        String fileContentDataObjField = request.getParameter("fileContentDataObjectField");
        if (fileName == null) {
            throw new RuntimeException("Request Parameter fileName must be provided");
        }
        if (contentType == null) {
            throw new RuntimeException("Request Parameter contentType must be provided");
        }
        if (fileContentDataObjField == null) {
            throw new RuntimeException("Request Parameter fileContentDataObjectField must be provided");
        }
        this.checkViewAuthorization(form);
        Object dataObject = form.getDataObject();
        if (dataObject == null && GlobalVariables.getMessageMap().hasNoMessages()) {
            throw new UnsupportedOperationException("The record you have inquired on does not exist.");
        }
        Method method = dataObject.getClass().getMethod("get" + StringUtils.capitalize((String)fileContentDataObjField), new Class[0]);
        byte[] attachmentContent = (byte[])method.invoke(dataObject, new Object[0]);
        this.addAttachmentToResponse(response, attachmentContent, contentType, fileName);
    }

    private void addAttachmentToResponse(HttpServletResponse response, byte[] attachmentContent, String contentType, String fileName) {
        int attachmentContentLength;
        ByteArrayInputStream inputStream = null;
        if (attachmentContent != null) {
            inputStream = new ByteArrayInputStream(attachmentContent);
            attachmentContentLength = attachmentContent.length;
        } else {
            attachmentContentLength = 0;
        }
        try {
            KRADUtils.addAttachmentToResponse(response, inputStream, contentType, fileName, attachmentContentLength);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to retrieve attachment contents", e);
        }
    }
}

